/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc.perm;

import com.sap.security.api.UMFactory;
import com.sap.security.api.acl.IAclManager;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtils {
    public static void removePermissions() throws Exception {
        IAclManager aclManager = UMFactory.getAclManager();
        List permissions = UMFactory.getAclManager().getAllPermissions();
        if (permissions != null) {
            if (permissions.contains("XKN.FULL_CONTROL")) {
                UMFactory.getAclManager().removePermission("XKN.FULL_CONTROL");
            }
            if (permissions.contains("XKN.READ")) {
                UMFactory.getAclManager().removePermission("XKN.READ");
            }
            if (permissions.contains("XKN.WRITE")) {
                UMFactory.getAclManager().removePermission("XKN.WRITE");
            }
            if (permissions.contains("XKN.READ_WRITE")) {
                UMFactory.getAclManager().removePermission("XKN.READ_WRITE");
            }
            if (permissions.contains("XKN.DELETE")) {
                UMFactory.getAclManager().removePermission("XKN.DELETE");
            }
        }
    }

    public static void adaptPermissionsHierarchically() throws Exception {
        List permissions = UMFactory.getAclManager().getAllPermissions();
        IAclManager aclManager = UMFactory.getAclManager();
        if (permissions == null) {
            aclManager.addPermission("XKN.READ", null);
            aclManager.addPermission("XKN.WRITE", null);
            aclManager.addPermission("XKN.DELETE", null);
            ArrayList<String> members = new ArrayList<String>(2);
            members.add("XKN.READ");
            members.add("XKN.WRITE");
            aclManager.addPermission("XKN.READ_WRITE", members);
            members = new ArrayList(3);
            members.add("XKN.READ");
            members.add("XKN.WRITE");
            members.add("XKN.DELETE");
            aclManager.addPermission("XKN.FULL_CONTROL", members);
        } else {
            ArrayList<String> members;
            if (!permissions.contains("XKN.READ")) {
                aclManager.addPermission("XKN.READ", null);
            }
            if (!permissions.contains("XKN.WRITE")) {
                aclManager.addPermission("XKN.WRITE", null);
            }
            if (!permissions.contains("XKN.DELETE")) {
                aclManager.addPermission("XKN.DELETE", null);
            }
            if (!permissions.contains("XKN.READ_WRITE")) {
                members = new ArrayList<String>(2);
                members.add("XKN.READ");
                members.add("XKN.WRITE");
                aclManager.addPermission("XKN.READ_WRITE", members);
            }
            if (!permissions.contains("XKN.FULL_CONTROL")) {
                members = new ArrayList(2);
                members.add("XKN.READ");
                members.add("XKN.WRITE");
                members.add("XKN.DELETE");
                aclManager.addPermission("XKN.FULL_CONTROL", members);
            }
        }
    }
}

