/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc;

import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.security.api.IGroup;
import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;

public class CoreServiceUser {
    private static final String CAF_MP_CORE_SERVICEUSER_NAME = "caf_mp_svcuser";
    private static final String BUILTIN_GROUP_ADMINISTRATORS = "Administrators";
    private static IUser m_user = CoreServiceUser.checkServiceUser();
    static /* synthetic */ Class class$com$sap$caf$mp$core$svc$CoreServiceUser;

    private static IUser checkServiceUser() {
        IUser svcUser = null;
        try {
            svcUser = UMFactory.getServiceUserFactory().getServiceUser(CAF_MP_CORE_SERVICEUSER_NAME);
        }
        catch (Exception ex) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Error accessing service user.", (Exception)ex);
        }
        try {
            if (svcUser == null) {
                UMFactory.getServiceUserFactory().createServiceUser(CAF_MP_CORE_SERVICEUSER_NAME);
                BaseLogManager.info((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Service user created.");
                svcUser = UMFactory.getServiceUserFactory().getServiceUser(CAF_MP_CORE_SERVICEUSER_NAME);
                BaseLogManager.info((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Service user created and accessible.");
            }
        }
        catch (Exception ex) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Error accessing service user.", (Exception)ex);
        }
        try {
            if (svcUser != null) {
                IGroup adminGroup = UMFactory.getGroupFactory().getGroupByUniqueName(BUILTIN_GROUP_ADMINISTRATORS);
                BaseLogManager.info((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Core service retrieved administrators group.");
                if (!svcUser.isMemberOfGroup(adminGroup.getUniqueID(), true)) {
                    UMFactory.getGroupFactory().addUserToGroup(svcUser.getUniqueID(), adminGroup.getUniqueID());
                    BaseLogManager.info((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Core service user added to administrators group.");
                }
            }
        }
        catch (Exception ex) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$svc$CoreServiceUser == null ? (class$com$sap$caf$mp$core$svc$CoreServiceUser = CoreServiceUser.class$("com.sap.caf.mp.core.svc.CoreServiceUser")) : class$com$sap$caf$mp$core$svc$CoreServiceUser), (String)"Error adding core service user to administrators group", (Exception)ex);
        }
        return svcUser;
    }

    public static IUser getCoreServiceUser() {
        return m_user;
    }

    public static boolean isServiceUser(IUser user) {
        return m_user.getUniqueID().equals(user.getUniqueID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

