/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc;

import com.sap.caf.mp.base.db.ConnectionPoolJ2EE;
import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreContext;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.IUserFactory;
import com.sap.caf.mp.core.bag.BagFactory;
import com.sap.caf.mp.core.bag.IBagFactory;
import com.sap.caf.mp.core.data.service.DataServiceFactory;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.types.meta.api.ITypeFactory;
import com.sap.caf.mp.core.data.types.meta.base.TypeFactory;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueFactory;
import com.sap.caf.mp.core.data.values.meta.base.TypeValueFactory;
import com.sap.caf.mp.core.language.LanguageManager;
import com.sap.caf.mp.core.languages.ILanguageManager;
import com.sap.caf.mp.core.svc.CAFMPCoreServiceFrame;
import com.sap.caf.mp.core.svc.CoreContext;
import com.sap.caf.mp.core.svc.persist.IPersistenceManagers;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.caf.mp.core.user.UserFactory;
import java.io.InputStream;
import java.util.Properties;

public class CoreFactory
implements ICoreFactory {
    public static final String JNDI_REGISTERED_NAME = "/sap.com/com.sap.caf/CoreFactory";
    private CAFMPCoreServiceFrame m_serviceFrame;
    private CoreContext m_coreContext;
    private UserFactory m_userFactory;
    private LanguageManager m_languageManager;
    private ICNConnectionPool m_connectionPool;
    private PersistenceManagers m_persistenceManagers;
    private DataServiceFactory m_dataServiceFactory;
    private BagFactory m_bagFactory;
    private ITypeFactory m_typeFactory;
    private ITypeValueFactory m_typeValueFactory;

    private void createConnectionPool() throws EngineException {
        BaseLogManager.info(this.getClass(), (String)("Using database pool: " + this.m_serviceFrame.getDatabasepoolName()));
        Properties config = new Properties();
        config.put("DBPOOL_NAME", this.m_serviceFrame.getDatabasepoolName());
        this.m_connectionPool = new ConnectionPoolJ2EE();
        try {
            this.m_connectionPool.initialize(config);
        }
        catch (InvocationException e) {
            throw new EngineException((Exception)((Object)e));
        }
    }

    public CoreFactory(CAFMPCoreServiceFrame service) throws EngineException {
        try {
            this.m_serviceFrame = service;
            this.m_coreContext = new CoreContext(service, service.getServiceConfig(), service.getFallbackLanguage(), service.getParticipantName());
            this.createConnectionPool();
            this.m_persistenceManagers = new PersistenceManagers(this.m_connectionPool, this);
            try {
                this.m_userFactory = new UserFactory(this, this.m_coreContext.getSystemInstallationNumber());
            }
            catch (InvocationException ex) {
                BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
                throw new EngineException((Exception)((Object)ex));
            }
            InputStream languageFile = this.getCoreContext().getPersistenFile("supported_languages.xml");
            this.m_languageManager = new LanguageManager(this, languageFile, this.m_serviceFrame.getFallbackLanguage());
            this.m_bagFactory = new BagFactory();
            this.m_typeFactory = new TypeFactory();
            this.m_typeValueFactory = new TypeValueFactory();
            this.m_dataServiceFactory = new DataServiceFactory(this, this.m_serviceFrame.getServiceContext());
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    public ICoreContext getCoreContext() {
        return this.m_coreContext;
    }

    public IPersistenceManagers getPersistenceManagers() {
        return this.m_persistenceManagers;
    }

    public IUserFactory getUserFactory() {
        return this.m_userFactory;
    }

    public ILanguageManager getLanguageManager() {
        return this.m_languageManager;
    }

    public IDataServiceFactory getDataServiceFactory() {
        return this.m_dataServiceFactory;
    }

    public IBagFactory getBagFactory() {
        return this.m_bagFactory;
    }

    public ITypeFactory getTypeFactory() {
        return this.m_typeFactory;
    }

    public ITypeValueFactory getTypeValueFactory() {
        return this.m_typeValueFactory;
    }

    public void onMetaModelChange() {
    }
}

