/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreContext;
import com.sap.caf.mp.core.IRuntimeInfoProvider;
import com.sap.caf.mp.core.runtime.RuntimeInfoProvider;
import com.sap.caf.mp.core.svc.CAFMPCoreServiceFrame;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IUser;
import com.sap.security.api.UMFactory;
import com.sap.security.api.acl.IAcl;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectRetrievalException;
import com.sap.security.core.server.securestorage.exception.ObjectStorageException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class CoreContext
implements ICoreContext {
    private static final String CORE_SERVICE_ADMIN_ACL = "xkn:core:adminacl";
    private CAFMPCoreServiceFrame m_frame;
    private RuntimeInfoProvider m_runtimeInfoProvider;
    private Properties m_serviceConfig;
    private int m_installationNumber;
    private String m_fallbackLanguage;
    private String m_participantName;
    private Locale m_fallbackLocale;
    private Object m_secureStorageLock = new Object();
    static /* synthetic */ Class class$com$sap$caf$mp$core$svc$CoreContext;

    public CoreContext(CAFMPCoreServiceFrame frame, Properties serviceConfig, String fallbackLanguage, String participantName) {
        this.m_frame = frame;
        this.m_runtimeInfoProvider = new RuntimeInfoProvider(this.m_frame);
        this.m_serviceConfig = serviceConfig;
        if (serviceConfig.getProperty("system.instnr") == null) {
            serviceConfig.setProperty("system.instnr", "0");
        }
        this.m_installationNumber = Integer.parseInt(serviceConfig.getProperty("system.instnr", "0"));
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_participantName = participantName;
        this.m_fallbackLocale = new Locale(this.m_fallbackLanguage);
    }

    public CoreContext() {
        this.m_frame = null;
        this.m_serviceConfig = null;
    }

    public Principal getCallerPrincipal() {
        return this.m_frame.getCallerPrincipal();
    }

    public InputStream getPersistenFile(String name) {
        return this.m_frame.getPersistentFile(name);
    }

    public void updatePersistentFile(String name, InputStream newFile) throws EngineException {
        this.m_frame.updatePersistentFile(name, newFile);
    }

    public Properties getServiceConfig() {
        return this.m_serviceConfig;
    }

    public void startThread(Runnable target) {
        if (this.m_frame != null) {
            this.m_frame.getThreadSystem().startThread(target, false);
        } else {
            Thread thread = new Thread(target);
            thread.start();
        }
    }

    public int getAdminMembersMode(IUser user) throws InvocationException, EngineException {
        return this.m_frame.getAdminMembersMode();
    }

    public String getAminModeInternalAclName(IUser user) throws InvocationException, EngineException {
        if (!this.isAdministrator(user)) {
            throw new InvocationException("You are not authorized to call this method.");
        }
        return CORE_SERVICE_ADMIN_ACL;
    }

    public boolean isAdministrator(IUser user) throws EngineException {
        switch (this.m_frame.getAdminMembersMode()) {
            case 2: {
                return user.isMemberOfRole(this.m_frame.getAdminMembersRole(), true);
            }
            case 1: {
                return user.isMemberOfGroup(this.m_frame.getAdminMembersGroup(), true);
            }
            case 0: {
                try {
                    IAcl acl = UMFactory.getAclManager().getAcl(CORE_SERVICE_ADMIN_ACL);
                    if (acl == null) {
                        return true;
                    }
                    if (acl.isOwner((IPrincipal)user)) {
                        return true;
                    }
                    return acl.isAllowed((IPrincipal)user, "XKN.FULL_CONTROL");
                }
                catch (Exception ex) {
                    throw new EngineException("Unable to check permissions for this user: " + ex.getMessage(), ex);
                }
            }
        }
        throw new EngineException("Internal error: admin members mode invalid.");
    }

    public String getAdminPrincipalId(IUser user) throws InvocationException, EngineException {
        if (!this.isAdministrator(user)) {
            throw new InvocationException("You are not authorized to call this method.");
        }
        switch (this.m_frame.getAdminMembersMode()) {
            case 1: {
                return this.m_frame.getAdminMembersGroup();
            }
            case 2: {
                return this.m_frame.getAdminMembersRole();
            }
        }
        return null;
    }

    public int getSystemInstallationNumber() {
        return this.m_installationNumber;
    }

    public String getFallbackLanguage() {
        return this.m_fallbackLanguage;
    }

    public String getParticipantName() {
        return this.m_participantName;
    }

    public int getParticipantId() {
        return this.m_frame.getParticipantId();
    }

    public Vector getPersistentFileNames() {
        return this.m_frame.getPersistentFileNames();
    }

    public IRuntimeInfoProvider getRuntimeInfoProvider() {
        return this.m_runtimeInfoProvider;
    }

    public String getHttpServerPrefix() {
        return this.m_frame.getHttpServerPrefix();
    }

    public Locale getFallbackLocale() {
        return this.m_fallbackLocale;
    }

    public String getWorkingDirectory() {
        return this.m_frame.getServiceContext().getServiceState().getWorkingDirectoryName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromSecureStore(String objectId) throws EngineException, InvocationException {
        try {
            Object object = this.m_secureStorageLock;
            synchronized (object) {
                RemoteSecureStorageClientContextInterface secureStoreClientContext = this.getSecureStore();
                BaseLogManager.info(this.getClass(), (String)"got secure store client context");
                secureStoreClientContext.deleteObject(objectId);
                BaseLogManager.info(this.getClass(), (String)"deleted object from secure store");
            }
        }
        catch (ObjectDeletionException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw new EngineException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFromSecureStore(String objectId) throws EngineException, InvocationException {
        ClassLoader currentClassLoader = null;
        try {
            try {
                Object object;
                Object object2 = this.m_secureStorageLock;
                synchronized (object2) {
                    RemoteSecureStorageClientContextInterface secureStoreClientContext = this.getSecureStore();
                    BaseLogManager.info(this.getClass(), (String)"got secure store client context");
                    currentClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((class$com$sap$caf$mp$core$svc$CoreContext == null ? (class$com$sap$caf$mp$core$svc$CoreContext = CoreContext.class$("com.sap.caf.mp.core.svc.CoreContext")) : class$com$sap$caf$mp$core$svc$CoreContext).getClassLoader());
                    BaseLogManager.info(this.getClass(), (String)"corrected class loader");
                    Object retVal = secureStoreClientContext.retrieveObject(objectId);
                    BaseLogManager.info(this.getClass(), (String)"found object in secure store");
                    object = retVal;
                }
                Object var9_9 = null;
                if (currentClassLoader == null) return object;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                return object;
            }
            catch (ObjectRetrievalException ex) {
                BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
                Object var9_10 = null;
                if (currentClassLoader == null) return null;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                return null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (currentClassLoader == null) throw throwable;
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setToSecureStore(String objectId, Serializable serialObject) throws EngineException, InvocationException {
        ClassLoader currentClassLoader = null;
        try {
            try {
                boolean bl;
                Object object = this.m_secureStorageLock;
                synchronized (object) {
                    RemoteSecureStorageClientContextInterface secureStoreClientContext = this.getSecureStore();
                    BaseLogManager.info(this.getClass(), (String)"got secure store client context");
                    currentClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((class$com$sap$caf$mp$core$svc$CoreContext == null ? (class$com$sap$caf$mp$core$svc$CoreContext = CoreContext.class$("com.sap.caf.mp.core.svc.CoreContext")) : class$com$sap$caf$mp$core$svc$CoreContext).getClassLoader());
                    BaseLogManager.info(this.getClass(), (String)"corrected class loader");
                    try {
                        Object currentObject = secureStoreClientContext.retrieveObject(objectId);
                        BaseLogManager.info(this.getClass(), (String)"found object in secure store");
                        if (currentObject != null) {
                            secureStoreClientContext.deleteObject(objectId);
                            BaseLogManager.info(this.getClass(), (String)"deleted object from secure store");
                        }
                    }
                    catch (Exception ex) {
                        BaseLogManager.error(this.getClass(), (Exception)ex);
                    }
                    secureStoreClientContext.storeObject(serialObject, objectId);
                    BaseLogManager.info(this.getClass(), (String)"stored object in secure store");
                    bl = true;
                }
                Object var9_11 = null;
                if (currentClassLoader == null) return bl;
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                return bl;
            }
            catch (ObjectStorageException ex) {
                BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
                throw new EngineException((Exception)((Object)ex));
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (currentClassLoader == null) throw throwable;
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            throw throwable;
        }
    }

    private RemoteSecureStorageClientContextInterface getSecureStore() throws EngineException {
        try {
            SecureStorageRuntimeInterface secureStore = (SecureStorageRuntimeInterface)this.m_frame.getServiceContext().getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~securestorage~service");
            BaseLogManager.info(this.getClass(), (String)"got secure storage interface");
            RemoteSecureStorageClientContextInterface secureStoreClientContext = secureStore.getSecureStorageClientContext();
            BaseLogManager.info(this.getClass(), (String)"got client context");
            return secureStoreClientContext;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

