/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.runtime;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.IRuntimeInfoProvider;
import com.sap.caf.mp.core.runtime.ApplicationRuntimeInfo;
import com.sap.caf.mp.core.runtime.IApplicationRuntimeInfo;
import com.sap.caf.mp.core.runtime.IPortalRuntimeInfo;
import com.sap.caf.mp.core.runtime.PortalRuntimeInfo;
import com.sap.caf.mp.core.svc.CAFMPCoreServiceFrame;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.services.deploy.DeployService;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public class RuntimeInfoProvider
implements IRuntimeInfoProvider {
    private static final String JNDI_NAME_DEPLOY_SERVICE = "deploy";
    private static final String JNDI_NAME_TRANSACTION_SERVICE = "ts";
    private static final String JNDI_NAME_PRTBRIDGE = "prtbridge";
    private static final String JNDI_NAME_PRT_SAPJ2EE = "com.sap.portal.prt.sapj2ee";
    private static final String JNDI_NAME_SERVLET_IRJ = "sap.com/irj";
    private static final String APPLICATION_STOPPED = "STOPPED";
    private static final String APPLICATION_IMPLICIT_STOPPED = "IMPLICIT_STOPPED";
    private static final String APPLICATION_STARTED = "STARTED";
    private static final String APPLICATION_STARTING = "STARTING";
    private static final String APPLICATION_STOPPING = "STOPPING";
    private static final String APPLICATION_UPGRADING = "UPGRADING";
    private static final String APPLICATION_UNKNOWN = "UNKNOWN";
    private Properties m_applicationStatus;
    private SystemMonitor m_systemMonitor;
    private DeployService m_deployService;
    private TransactionManager m_transactionManager;

    public RuntimeInfoProvider(CAFMPCoreServiceFrame frame) {
        this.m_systemMonitor = frame.getServiceContext().getContainerContext().getSystemMonitor();
        this.m_deployService = (DeployService)frame.getServiceContext().getContainerContext().getObjectRegistry().getServiceInterface(JNDI_NAME_DEPLOY_SERVICE);
        this.m_transactionManager = (TransactionManager)frame.getServiceContext().getContainerContext().getObjectRegistry().getServiceInterface(JNDI_NAME_TRANSACTION_SERVICE);
        this.m_applicationStatus = this.initApplicationStatus();
    }

    public IPortalRuntimeInfo getPortalRuntimeInfo() {
        try {
            ServiceMonitor prtBridgeMonitor = this.m_systemMonitor.getService(JNDI_NAME_PRTBRIDGE);
            ServiceMonitor prtJ2EEMonitor = this.m_systemMonitor.getService(JNDI_NAME_PRT_SAPJ2EE);
            String irjServletStatus = this.getApplicationStatus(JNDI_NAME_SERVLET_IRJ);
            if (prtBridgeMonitor == null || prtJ2EEMonitor == null || irjServletStatus == null || irjServletStatus.length() == 0) {
                return new PortalRuntimeInfo(0);
            }
            byte prtBridgeStatus = prtBridgeMonitor.getStatus();
            byte prtJ2EEStatus = prtJ2EEMonitor.getStatus();
            if (prtBridgeStatus == 5 && prtJ2EEStatus == 5 && irjServletStatus.equals(APPLICATION_STARTED)) {
                return new PortalRuntimeInfo(1);
            }
            boolean prtBridgeStopped = false;
            boolean prtJ2EEStopped = false;
            if (prtBridgeStatus == 2 || prtBridgeStatus == 4) {
                prtBridgeStopped = true;
            }
            if (prtJ2EEStatus == 2 || prtJ2EEStatus == 4) {
                prtJ2EEStopped = true;
            }
            if (prtBridgeStopped && prtJ2EEStopped && irjServletStatus.equals(APPLICATION_STOPPED)) {
                return new PortalRuntimeInfo(2);
            }
            return new PortalRuntimeInfo(3);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            return new PortalRuntimeInfo(3);
        }
    }

    public IApplicationRuntimeInfo getApplicationRuntimeInfo(String applicationName) {
        String status = this.getApplicationStatus(applicationName);
        int applicationStatus = this.mapApplicationStatus(status);
        return new ApplicationRuntimeInfo(applicationName, applicationStatus);
    }

    public void startApplication(String applicationName, boolean synchronous) throws EngineException, InvocationException {
        IApplicationRuntimeInfo applicationRuntimeInfo = this.getApplicationRuntimeInfo(applicationName);
        switch (applicationRuntimeInfo.getStatus()) {
            case 0: {
                throw new InvocationException("application not deployed on this server");
            }
            case 1: {
                throw new InvocationException("application already started on this server");
            }
            case 2: {
                throw new InvocationException("application already starting on this server");
            }
            case 6: {
                throw new InvocationException("application upgrading on this server");
            }
            case 7: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new InvocationException("application in unknown status on this server");
            }
        }
        this.startApplicationInt(applicationName, synchronous);
    }

    public void stopApplication(String applicationName, boolean synchronous) throws EngineException, InvocationException {
        IApplicationRuntimeInfo applicationRuntimeInfo = this.getApplicationRuntimeInfo(applicationName);
        switch (applicationRuntimeInfo.getStatus()) {
            case 0: {
                throw new InvocationException("application not deployed on this server");
            }
            case 3: {
                throw new InvocationException("application already stopped on this server");
            }
            case 5: {
                throw new InvocationException("application already stopping on this server");
            }
            case 6: {
                throw new InvocationException("application upgrading on this server");
            }
            case 7: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                return;
            }
            default: {
                throw new InvocationException("application in unknown status on this server");
            }
        }
        this.stopApplicationInt(applicationName, synchronous);
    }

    public int getTransactionStatus() throws EngineException, InvocationException {
        try {
            return this.m_transactionManager.getStatus();
        }
        catch (SystemException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw new EngineException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new InvocationException(ex);
        }
    }

    private void startApplicationInt(String applicationName, boolean synchronous) throws EngineException {
        try {
            if (synchronous) {
                this.m_deployService.startApplicationAndWait(applicationName);
            } else {
                this.m_deployService.startApplication(applicationName);
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private void stopApplicationInt(String applicationName, boolean synchronous) throws EngineException {
        try {
            if (synchronous) {
                this.m_deployService.stopApplicationAndWait(applicationName);
            } else {
                this.m_deployService.stopApplication(applicationName);
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private String getApplicationStatus(String applicationName) {
        try {
            return this.m_deployService.getApplicationStatus(applicationName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private int mapApplicationStatus(String status) {
        if (status == null || status.length() == 0) {
            return 0;
        }
        Integer applicationStatus = (Integer)this.m_applicationStatus.get(status);
        if (applicationStatus == null) {
            return 0;
        }
        return applicationStatus;
    }

    private Properties initApplicationStatus() {
        Properties applicationStatus = new Properties();
        applicationStatus.put(APPLICATION_STOPPED, new Integer(3));
        applicationStatus.put(APPLICATION_IMPLICIT_STOPPED, new Integer(4));
        applicationStatus.put(APPLICATION_STARTED, new Integer(1));
        applicationStatus.put(APPLICATION_STARTING, new Integer(2));
        applicationStatus.put(APPLICATION_STOPPING, new Integer(5));
        applicationStatus.put(APPLICATION_UPGRADING, new Integer(6));
        applicationStatus.put(APPLICATION_UNKNOWN, new Integer(7));
        return applicationStatus;
    }
}

