/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.language;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.languages.ILanguageManager;
import com.sap.caf.mp.core.languages.LanguageInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageManager
implements ILanguageManager {
    private static final String NAMESPACE = "http://www.sap.com/caf/core/SupportedLanguages_v1";
    private static final String ELEMENT_NAME_LANGUAGE = "Language";
    private static final String ELEMENT_NAME_DISPLAY_TEXT = "DisplayText";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_LANGUAGE = "language";
    private static final String ATTRIBUTE_NAME_TEXT = "text";
    private String m_fallbackLanguage;
    private String m_workingDir;
    private Hashtable m_languageInfos;
    private ICoreFactory m_coreFactory;

    public LanguageManager(ICoreFactory coreFactory, InputStream xmlFile, String fallbackLanguage) throws EngineException {
        this.m_coreFactory = coreFactory;
        this.m_languageInfos = new Hashtable();
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_workingDir = coreFactory.getCoreContext().getWorkingDirectory();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            Element docNode = doc.getDocumentElement();
            NodeList children = docNode.getChildNodes();
            int count = children.getLength();
            for (int i = 0; i < count; ++i) {
                Node child = children.item(i);
                String name = child.getLocalName();
                if (name == null || !name.equalsIgnoreCase(ELEMENT_NAME_LANGUAGE)) continue;
                LanguageInfo info = null;
                NamedNodeMap attrs = child.getAttributes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Attr attr = (Attr)attrs.item(j);
                    if (!attr.getLocalName().equals(ATTRIBUTE_NAME_ID)) continue;
                    info = new LanguageInfo(attr.getValue(), (ILanguageManager)this);
                }
                if (info == null) {
                    BaseLogManager.warn(this.getClass(), (String)"Invalid language element in supported languages document.");
                    continue;
                }
                this.m_languageInfos.put(info.getId(), info);
                NodeList languageTexts = child.getChildNodes();
                for (int j = 0; j < languageTexts.getLength(); ++j) {
                    Node languageText = languageTexts.item(j);
                    String elename = languageText.getLocalName();
                    if (elename == null || !elename.equalsIgnoreCase("Displaytext")) continue;
                    String displanguage = ((Attr)languageText.getAttributes().getNamedItem(ATTRIBUTE_NAME_LANGUAGE)).getValue();
                    String disptext = ((Attr)languageText.getAttributes().getNamedItem(ATTRIBUTE_NAME_TEXT)).getValue();
                    info.addDisplayText(displanguage, disptext);
                }
            }
            if (this.m_languageInfos.size() == 0) {
                throw new EngineException("There are no supported languages specified.");
            }
            if (this.getLanguage(this.m_fallbackLanguage) == null) {
                throw new EngineException("The fallback language is not in the list of supported languages.");
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException("The languages file could not be parsed: " + ex.getMessage(), ex);
        }
    }

    public String getFallbackLanguage() {
        return this.m_fallbackLanguage;
    }

    public LanguageInfo getLanguage(String lang) {
        return (LanguageInfo)this.m_languageInfos.get(lang);
    }

    public Hashtable getSupportedLanguages() {
        return this.m_languageInfos;
    }

    /*
     * Loose catch block
     */
    public void updateLanguageInfo(LanguageInfo newLanguageInfo) throws EngineException, InvocationException {
        block24: {
            if (this.m_languageInfos.size() == 0) {
                throw new EngineException("There are no supported languages specified.");
            }
            if (this.getLanguage(this.m_fallbackLanguage) == null) {
                throw new EngineException("The fallback language is not in the list of supported languages.");
            }
            InputStream xmlFile = null;
            File tempFile = null;
            InputStream newFile = null;
            xmlFile = this.m_coreFactory.getCoreContext().getPersistenFile("supported_languages.xml");
            if (xmlFile == null) {
                throw new EngineException("No language installed on this server");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            Element docNode = doc.getDocumentElement();
            this.removeExistingInfoFromXML(newLanguageInfo, docNode);
            this.updateXML(newLanguageInfo, docNode, doc);
            tempFile = this.createTempFile(this.m_workingDir);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult stream = new StreamResult(tempFile);
            DOMSource source = new DOMSource(docNode);
            transformer.transform(source, stream);
            newFile = new FileInputStream(tempFile);
            this.m_coreFactory.getCoreContext().updatePersistentFile("supported_languages.xml", newFile);
            this.m_languageInfos.put(newLanguageInfo.getId(), newLanguageInfo);
            Object var14_14 = null;
            try {
                if (xmlFile != null) {
                    xmlFile.close();
                }
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            try {
                if (newFile != null) {
                    newFile.close();
                }
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            try {
                if (tempFile != null) {
                    tempFile.delete();
                }
                break block24;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block24;
            {
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    throw new EngineException("The languages file could not be parsed: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (xmlFile != null) {
                        xmlFile.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                try {
                    if (newFile != null) {
                        newFile.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                try {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private void updateXML(LanguageInfo newLanguageInfo, Element parent, Document doc) throws EngineException {
        try {
            Element element = doc.createElement(ELEMENT_NAME_LANGUAGE);
            element.setAttribute(ATTRIBUTE_NAME_ID, newLanguageInfo.getId());
            Enumeration languages = newLanguageInfo.getLanguages();
            while (languages.hasMoreElements()) {
                String language = (String)languages.nextElement();
                String dispayText = newLanguageInfo.resolveDisplayText(language);
                Element textElement = doc.createElement(ELEMENT_NAME_DISPLAY_TEXT);
                textElement.setAttribute(ATTRIBUTE_NAME_TEXT, dispayText);
                textElement.setAttribute(ATTRIBUTE_NAME_LANGUAGE, language);
                element.appendChild(textElement);
            }
            parent.appendChild(element);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveToFile(InputStream inFile) {
        block12: {
            OutputStream out = null;
            File destDir = new File("C:\\temp");
            File destinationFile = File.createTempFile("UpdatedLanguages", ".xml", destDir);
            out = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[10240];
            int readOut = 0;
            while ((readOut = inFile.read(buffer)) != -1) {
                ((FileOutputStream)out).write(buffer, 0, readOut);
            }
            Object var8_8 = null;
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                break block12;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block12;
            {
                catch (Exception exception) {
                    Object var8_9 = null;
                    try {
                        if (out != null) {
                            out.flush();
                            ((FileOutputStream)out).close();
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        BaseLogManager.error(this.getClass(), (Exception)ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (out != null) {
                        out.flush();
                        ((FileOutputStream)out).close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private void appendLanguageInformationExport(LanguageInfo languageInfo, Element parent, Document doc) throws EngineException {
        try {
            Element element = doc.createElement(ELEMENT_NAME_LANGUAGE);
            element.setAttribute(ATTRIBUTE_NAME_ID, languageInfo.getId());
            Enumeration enumeration = languageInfo.getLanguages();
            while (enumeration.hasMoreElements()) {
                String language = (String)enumeration.nextElement();
                Element textElement = doc.createElement(ELEMENT_NAME_DISPLAY_TEXT);
                String dispayText = languageInfo.resolveDisplayText(language);
                textElement.setAttribute(ATTRIBUTE_NAME_TEXT, dispayText);
                textElement.setAttribute(ATTRIBUTE_NAME_LANGUAGE, language);
                element.appendChild(textElement);
            }
            parent.appendChild(element);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private void removeExistingInfoFromXML(LanguageInfo newLanguageInfo, Node docNode) throws EngineException {
        try {
            NodeList children = docNode.getChildNodes();
            int count = children.getLength();
            Node currentLanguageInfo = null;
            for (int index = 0; index < count; ++index) {
                Element languageElement;
                String id;
                Node child = children.item(index);
                String name = child.getLocalName();
                if (name == null || !name.equalsIgnoreCase(ELEMENT_NAME_LANGUAGE) || !(id = (languageElement = (Element)child).getAttribute(ATTRIBUTE_NAME_ID)).equals(newLanguageInfo.getId())) continue;
                currentLanguageInfo = child;
                break;
            }
            if (currentLanguageInfo != null) {
                docNode.removeChild(currentLanguageInfo);
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private File createTempFile(String tempDir) throws IOException {
        File tempFile = File.createTempFile("SupportedLanguages", ".xml", new File(tempDir));
        return tempFile;
    }
}

