/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.text.TitleTextList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TitleListHelper {
    public static final String ATTRIBUTE_NAME_MASTERLANGUAGE = "masterLanguage";
    public static final String ELEMENT_NAME_TITLE = "Title";
    public static final String ATTRIBUTE_NAME_LANGUAGE = "language";
    public static final String ATTRIBUTE_NAME_TEXT = "text";

    protected TitleListHelper() {
    }

    public static TitleTextList parseTitleTextList(Element element, String fallbackLanguage) throws EngineException {
        String masterLanguage = null;
        NamedNodeMap attributes = element.getAttributes();
        int count = attributes.getLength();
        for (int i = 0; i < count; ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (!attr.getLocalName().equals(ATTRIBUTE_NAME_MASTERLANGUAGE)) continue;
            masterLanguage = attr.getValue();
        }
        if (masterLanguage == null) {
            throw new EngineException("Input file invalid: masterLanguage attribute missing on element TitleLis");
        }
        TitleTextList list = new TitleTextList(masterLanguage, fallbackLanguage);
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null || !localName.equals(ELEMENT_NAME_TITLE)) continue;
            Element titleElement = (Element)child;
            attributes = titleElement.getAttributes();
            String language = null;
            String text = null;
            int attrCount = attributes.getLength();
            for (int j = 0; j < attrCount; ++j) {
                Attr attr = (Attr)attributes.item(j);
                String attrName = attr.getLocalName();
                if (attrName.equals(ATTRIBUTE_NAME_LANGUAGE)) {
                    language = attr.getValue();
                    continue;
                }
                if (!attrName.equals(ATTRIBUTE_NAME_TEXT)) continue;
                text = attr.getValue();
            }
            if (language == null) {
                throw new EngineException("Input file invalid: language attribute missing for Title element.");
            }
            if (text == null) {
                throw new EngineException("Input file invalid: text attribute missing for Title element.");
            }
            list.addTitleText(language, text);
        }
        return list;
    }
}

