/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.text.TitleText;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.service.registry.types.IOperationParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDefEnumeration;
import com.sap.caf.mp.core.data.service.registry.types.IPortParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefConstants;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefs;
import com.sap.caf.mp.core.data.service.registry.types.IUsageConstraintDef;
import com.sap.caf.mp.core.data.service.registry.types.IUsageConstraintValueDef;
import com.sap.caf.mp.core.data.service.registry.types.ServiceProviderTypeDef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServiceProviderTypeDefs
implements IServiceProviderTypeDefs,
IServiceProviderTypeDefConstants {
    private static final String ELEMENT_NAME_SERVICEPROVIDERTYPES = "ServiceProviderTypes";
    private Hashtable m_typeDefs;
    private String m_fallbackLanguage;
    private String m_workingDir;
    private ICoreFactory m_coreFactory;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs;

    public ServiceProviderTypeDefs(ICoreFactory coreFactory, InputStream stream, String fallbackLanguage) throws EngineException {
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_coreFactory = coreFactory;
        this.m_typeDefs = new Hashtable();
        this.m_workingDir = coreFactory.getCoreContext().getWorkingDirectory();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals(ELEMENT_NAME_SERVICEPROVIDERTYPES)) {
                throw new EngineException("The xml file is invalid.");
            }
            NodeList children = docEl.getChildNodes();
            int count = children.getLength();
            for (int i = 0; i < count; ++i) {
                Node child = children.item(i);
                String localName = child.getLocalName();
                if (localName == null) continue;
                ServiceProviderTypeDef typeDef = new ServiceProviderTypeDef((Element)child, fallbackLanguage);
                this.m_typeDefs.put(typeDef.getName(), typeDef);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new EngineException("Unable to create xml parser instance.", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new EngineException("Unable to parse input file.", (Exception)ex);
        }
        catch (IOException ex) {
            throw new EngineException("Unable to read input file.", (Exception)ex);
        }
    }

    public Enumeration getServiceProviderTypeDefs() {
        return this.m_typeDefs.elements();
    }

    public IServiceProviderTypeDef getServiceProviderDef(String name) {
        return (IServiceProviderTypeDef)this.m_typeDefs.get(name);
    }

    /*
     * Loose catch block
     */
    public void updateServiceProviderTypeDef(IServiceProviderTypeDef newServiceProviderTypeDef) throws EngineException, InvocationException {
        block25: {
            File tempFile = null;
            InputStream is = null;
            InputStream newFile = null;
            BaseLogManager.info(this.getClass(), (String)("newServiceProviderTypeDef name " + newServiceProviderTypeDef.getName()));
            is = this.m_coreFactory.getCoreContext().getPersistenFile("service_provider_type_definitions.xml");
            String fallBackLanguage = this.m_coreFactory.getCoreContext().getFallbackLanguage();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals(ELEMENT_NAME_SERVICEPROVIDERTYPES)) {
                throw new EngineException("The xml file is invalid.");
            }
            NodeList children = docEl.getChildNodes();
            int count = children.getLength();
            Node newServiceProviderTypeDefNode = null;
            for (int index = 0; index < count; ++index) {
                Node child = children.item(index);
                String localName = child.getLocalName();
                if (localName == null) continue;
                BaseLogManager.info(this.getClass(), (String)("child " + localName));
                boolean found = this.findElementByNameAttribute(child, newServiceProviderTypeDef.getName());
                if (!found) continue;
                newServiceProviderTypeDefNode = child;
                break;
            }
            if (newServiceProviderTypeDefNode != null) {
                docEl.removeChild(newServiceProviderTypeDefNode);
                BaseLogManager.info(this.getClass(), (String)"removed newServiceProviderTypeDefNode");
            }
            this.appendNewServiceProviderTypeDef(newServiceProviderTypeDef, doc, docEl);
            tempFile = this.createTempFile(this.m_workingDir);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult stream = new StreamResult(tempFile);
            DOMSource source = new DOMSource(docEl);
            transformer.transform(source, stream);
            newFile = new FileInputStream(tempFile);
            this.m_coreFactory.getCoreContext().updatePersistentFile("service_provider_type_definitions.xml", newFile);
            this.m_typeDefs.put(newServiceProviderTypeDef.getName(), newServiceProviderTypeDef);
            Object var18_21 = null;
            try {
                if (newFile != null) {
                    newFile.close();
                }
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            try {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            try {
                if (is != null) {
                    is.close();
                }
                break block25;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block25;
            {
                catch (EngineException ex) {
                    BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
                    throw new InvocationException((Exception)((Object)ex));
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    throw new InvocationException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                try {
                    if (newFile != null) {
                        newFile.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                try {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private boolean findElementByNameAttribute(Node child, String serviceProviderTypeDefName) {
        NamedNodeMap attribs = child.getAttributes();
        int length = attribs.getLength();
        for (int index = 0; index < length; ++index) {
            String name;
            Attr attrib = (Attr)attribs.item(index);
            if (!attrib.getLocalName().equals("name") || !(name = attrib.getValue()).equals(serviceProviderTypeDefName)) continue;
            BaseLogManager.info(this.getClass(), (String)"found newServiceProviderTypeDefNode");
            return true;
        }
        return false;
    }

    private void appendNewServiceProviderTypeDef(IServiceProviderTypeDef serviceProviderTypeDef, Document doc, Element parent) throws EngineException {
        try {
            Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ServiceProviderType");
            element.setAttribute("name", serviceProviderTypeDef.getName());
            element.setAttribute("implementationClassName", serviceProviderTypeDef.getImplementationClassName());
            this.appendTitleTextList(serviceProviderTypeDef.getTitleTextList(), element, doc);
            this.appendPortParameterList(serviceProviderTypeDef, element, doc);
            this.appendOperationParameterList(serviceProviderTypeDef, element, doc);
            parent.appendChild(element);
        }
        catch (EngineException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveToFile(InputStream inFile) {
        block12: {
            OutputStream out = null;
            File destDir = new File("C:\\temp");
            File destinationFile = File.createTempFile("Updatedserviceprovidertypedefinitions", ".xml", destDir);
            out = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[10240];
            int readOut = 0;
            while ((readOut = inFile.read(buffer)) != -1) {
                ((FileOutputStream)out).write(buffer, 0, readOut);
            }
            Object var8_8 = null;
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                break block12;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block12;
            {
                catch (Exception exception) {
                    Object var8_9 = null;
                    try {
                        if (out != null) {
                            out.flush();
                            ((FileOutputStream)out).close();
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        BaseLogManager.error(this.getClass(), (Exception)ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (out != null) {
                        out.flush();
                        ((FileOutputStream)out).close();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private void appendServiceProviderTypeDef(IServiceProviderTypeDef serviceProviderTypeDef, Element parent, Document document) throws EngineException {
        try {
            Element element = document.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ServiceProviderType");
            element.setAttribute("name", serviceProviderTypeDef.getName());
            element.setAttribute("implementationClassName", serviceProviderTypeDef.getImplementationClassName());
            this.appendTitleTextList(serviceProviderTypeDef.getTitleTextList(), element, document);
            this.appendPortParameterList(serviceProviderTypeDef, element, document);
            this.appendOperationParameterList(serviceProviderTypeDef, element, document);
            parent.appendChild(element);
        }
        catch (EngineException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            throw new EngineException(ex);
        }
    }

    private void appendOperationParameterList(IServiceProviderTypeDef serviceProviderTypeDef, Element parent, Document doc) throws EngineException {
        Enumeration operationParameters = serviceProviderTypeDef.getOperationParameters();
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:OperationParameterList");
        while (operationParameters.hasMoreElements()) {
            IOperationParameterDef operationParameterDef = (IOperationParameterDef)operationParameters.nextElement();
            Element operationParameterElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:OperationParameter");
            operationParameterElement.setAttribute("name", operationParameterDef.getName());
            operationParameterElement.setAttribute("obligate", String.valueOf(operationParameterDef.isObligate()));
            operationParameterElement.setAttribute("inherited", String.valueOf(operationParameterDef.isInherited()));
            operationParameterElement.setAttribute("changeable", String.valueOf(operationParameterDef.isChangeable()));
            String type = this.getTypeAsString(operationParameterDef.getType(), operationParameterDef.getName());
            operationParameterElement.setAttribute("type", type);
            this.appendTitleTextList(operationParameterDef.getTitleList(), operationParameterElement, doc);
            this.appendOperationParameterValueDefinitions(operationParameterDef.getParameterValueDefEnumeration(), operationParameterElement, doc);
            this.appendUsageConstraints(operationParameterDef.getUsageConstraints(), operationParameterElement, doc);
            element.appendChild(operationParameterElement);
        }
        parent.appendChild(element);
    }

    private void appendOperationParameterValueDefinitions(IParameterValueDefEnumeration valueDefinitions, Element parent, Document doc) {
        if (valueDefinitions == null) {
            return;
        }
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ParameterValueEnumeration");
        if (valueDefinitions.getDefault() == null) {
            element.setAttribute("default", "NONE");
        } else {
            element.setAttribute("default", valueDefinitions.getDefault().getName());
        }
        Enumeration enumeration = valueDefinitions.elements();
        while (enumeration.hasMoreElements()) {
            IParameterValueDef valueDef = (IParameterValueDef)enumeration.nextElement();
            Element valueDefElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ParameterValue");
            valueDefElement.setAttribute("name", valueDef.getName());
            this.appendTitleTextList(valueDef.getTitleList(), valueDefElement, doc);
            element.appendChild(valueDefElement);
        }
        parent.appendChild(element);
    }

    private void appendPortParameterList(IServiceProviderTypeDef serviceProviderTypeDef, Element parent, Document doc) throws EngineException {
        Enumeration portParameters = serviceProviderTypeDef.getPortParameters();
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:PortParameterList");
        while (portParameters.hasMoreElements()) {
            IPortParameterDef portParameterDef = (IPortParameterDef)portParameters.nextElement();
            Element portParameterElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:PortParameter");
            portParameterElement.setAttribute("name", portParameterDef.getName());
            portParameterElement.setAttribute("obligate", String.valueOf(portParameterDef.isObligate()));
            String type = this.getTypeAsString(portParameterDef.getType(), portParameterDef.getName());
            portParameterElement.setAttribute("type", type);
            this.appendTitleTextList(portParameterDef.getTitleList(), portParameterElement, doc);
            this.appendPortParameterValueDefinitions(portParameterDef.getParameterValueDefEnumeration(), portParameterElement, doc);
            this.appendUsageConstraints(portParameterDef.getUsageConstraints(), portParameterElement, doc);
            element.appendChild(portParameterElement);
        }
        parent.appendChild(element);
    }

    private String getTypeAsString(int type, String objectName) throws EngineException {
        String typeString = null;
        switch (type) {
            case 2: {
                typeString = "enumeration";
                break;
            }
            case 4: {
                typeString = "language";
                break;
            }
            case 3: {
                typeString = "numstring";
                break;
            }
            case 5: {
                typeString = "password";
                break;
            }
            case 1: {
                typeString = "string";
                break;
            }
            case 6: {
                typeString = "boolean";
                break;
            }
            default: {
                throw new EngineException("Invalid type specified in parameter element: " + objectName);
            }
        }
        return typeString;
    }

    private void appendUsageConstraints(Vector usageConstraints, Element parent, Document doc) throws EngineException {
        if (usageConstraints == null || usageConstraints.size() == 0) {
            return;
        }
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:UsageConstraints");
        Enumeration enumeration = usageConstraints.elements();
        while (enumeration.hasMoreElements()) {
            IUsageConstraintDef usageConstraint = (IUsageConstraintDef)enumeration.nextElement();
            Element usageConstraintElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:UsageConstraint");
            Enumeration usageConstraintValueEnum = usageConstraint.getUsageConstraintValueDefs();
            while (usageConstraintValueEnum.hasMoreElements()) {
                IUsageConstraintValueDef valueDef = (IUsageConstraintValueDef)usageConstraintValueEnum.nextElement();
                Element valueElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:UsageConstraintValue");
                valueElement.setAttribute("name", valueDef.getName());
                valueElement.setAttribute("value", valueDef.getValue());
                usageConstraintElement.appendChild(valueElement);
            }
            element.appendChild(usageConstraintElement);
        }
        parent.appendChild(element);
    }

    private void appendPortParameterValueDefinitions(IParameterValueDefEnumeration parameterValueDefEnum, Element parent, Document doc) throws EngineException {
        if (parameterValueDefEnum == null) {
            return;
        }
        Element element = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ParameterValueEnumeration");
        if (parameterValueDefEnum.getDefault() == null) {
            element.setAttribute("default", "NONE");
        } else {
            element.setAttribute("default", parameterValueDefEnum.getDefault().getName());
        }
        Enumeration enumeration = parameterValueDefEnum.elements();
        Object root = null;
        while (enumeration.hasMoreElements()) {
            IParameterValueDef valueDef = (IParameterValueDef)enumeration.nextElement();
            Element valueDefElement = doc.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:ParameterValue");
            valueDefElement.setAttribute("name", valueDef.getName());
            this.appendTitleTextList(valueDef.getTitleList(), valueDefElement, doc);
            element.appendChild(valueDefElement);
        }
        parent.appendChild(element);
    }

    private void appendTitleTextList(TitleTextList titles, Element parent, Document document) {
        Element titlesElement = document.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:TitleList");
        titlesElement.setAttribute("masterLanguage", titles.getMasterLanguage());
        Enumeration enumeration = titles.elements();
        while (enumeration.hasMoreElements()) {
            TitleText title = (TitleText)enumeration.nextElement();
            Element titleElement = document.createElementNS("http://www.sap.com/caf/mp/if/ServiceProviderTypeDefinitions_v1", "mp:Title");
            titleElement.setAttribute("language", title.getLanguage());
            titleElement.setAttribute("text", title.getText());
            titlesElement.appendChild(titleElement);
        }
        parent.appendChild(titlesElement);
    }

    private File createTempFile(String tempDir) throws IOException {
        File tempFile = File.createTempFile("ServiceProviderTypeDef", ".xml", new File(tempDir));
        return tempFile;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("c:\\temp\\service_provider_type_definitions.xml");
            ServiceProviderTypeDefs serviceProviderTypeDefs = new ServiceProviderTypeDefs(null, fis, "en");
        }
        catch (Exception ex) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs == null ? (class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs = ServiceProviderTypeDefs.class$("com.sap.caf.mp.core.data.service.registry.types.ServiceProviderTypeDefs")) : class$com$sap$caf$mp$core$data$service$registry$types$ServiceProviderTypeDefs), (Exception)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

