/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDef;
import com.sap.caf.mp.core.data.service.registry.types.OperationParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.PortParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.TitleListHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceProviderTypeDef
implements IServiceProviderTypeDef {
    private static final String ELEMENT_NAME_SERVICEPROVIDERTYPE = "ServiceProviderType";
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ATTRIBUTE_IMPLEMENTATION_CLASSNAME = "implementationClassName";
    private static final String ATTRIBUTE_CAN_CREATE = "canCreate";
    private static final String ATTRIBUTE_CAN_CHANGE = "canChange";
    private static final String ELEMENT_NAME_TITLELIST = "TitleList";
    private static final String ELEMENT_NAME_PORTPARAMETERLIST = "PortParameterList";
    private static final String ELEMENT_NAME_PORTPARAMETER = "PortParameter";
    private static final String ELEMENT_NAME_OPERATIONPARAMETERLIST = "OperationParameterList";
    private static final String ELEMENT_NAME_OPERATIONPARAMETER = "OperationParameter";
    private String m_name;
    private String m_implementationClassName;
    private TitleTextList m_titles;
    private Hashtable m_portParameterList;
    private Vector m_portParameters;
    private Hashtable m_operationParameterList;
    private Vector m_operationParameters;
    private boolean m_canChange;
    private boolean m_canCreate;

    protected ServiceProviderTypeDef(Element element, String fallbackLanguage) throws EngineException {
        String name = null;
        String implementationClassName = null;
        this.m_titles = null;
        this.m_portParameterList = new Hashtable();
        this.m_operationParameterList = new Hashtable();
        this.m_portParameters = new Vector();
        this.m_operationParameters = new Vector();
        this.m_canChange = true;
        this.m_canCreate = true;
        NamedNodeMap attribs = element.getAttributes();
        int count = attribs.getLength();
        for (int i = 0; i < count; ++i) {
            Attr attrib = (Attr)attribs.item(i);
            if (attrib.getLocalName().equals(ATTRIBUTE_NAME_NAME)) {
                name = attrib.getValue();
                continue;
            }
            if (attrib.getLocalName().equals(ATTRIBUTE_IMPLEMENTATION_CLASSNAME)) {
                implementationClassName = attrib.getValue();
                continue;
            }
            if (attrib.getLocalName().equals(ATTRIBUTE_CAN_CHANGE)) {
                this.m_canChange = attrib.getValue().equals("true");
                continue;
            }
            if (!attrib.getLocalName().equals(ATTRIBUTE_CAN_CREATE)) continue;
            this.m_canCreate = attrib.getValue().equals("true");
        }
        if (name == null) {
            throw new EngineException("Input file invalid: name attribute missing on ServiceProviderType element.");
        }
        if (implementationClassName == null) {
            throw new EngineException("Input file invalid: implementationClassName attribute missing on ServiceProviderType element.");
        }
        this.m_name = name;
        this.m_implementationClassName = implementationClassName;
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            String childLocalName;
            Node paramChild;
            int j;
            int childCount;
            NodeList childNodes;
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null) continue;
            if (localName.equals(ELEMENT_NAME_TITLELIST)) {
                this.m_titles = TitleListHelper.parseTitleTextList((Element)child, fallbackLanguage);
                continue;
            }
            if (localName.equals(ELEMENT_NAME_PORTPARAMETERLIST)) {
                childNodes = child.getChildNodes();
                childCount = childNodes.getLength();
                for (j = 0; j < childCount; ++j) {
                    paramChild = childNodes.item(j);
                    childLocalName = paramChild.getLocalName();
                    if (childLocalName == null || !childLocalName.equals(ELEMENT_NAME_PORTPARAMETER)) continue;
                    PortParameterDef paramDef = new PortParameterDef((Element)paramChild, fallbackLanguage);
                    this.m_portParameterList.put(paramDef.getName(), paramDef);
                    this.m_portParameters.add(paramDef);
                }
                continue;
            }
            if (!localName.equals(ELEMENT_NAME_OPERATIONPARAMETERLIST)) continue;
            childNodes = child.getChildNodes();
            childCount = childNodes.getLength();
            for (j = 0; j < childCount; ++j) {
                paramChild = childNodes.item(j);
                childLocalName = paramChild.getLocalName();
                if (childLocalName == null || !childLocalName.equals(ELEMENT_NAME_OPERATIONPARAMETER)) continue;
                OperationParameterDef operDef = new OperationParameterDef((Element)paramChild, fallbackLanguage);
                this.m_operationParameterList.put(operDef.getName(), operDef);
                this.m_operationParameters.add(operDef);
            }
        }
        if (this.m_titles == null) {
            throw new EngineException("Input file invalid: TitleList child element missing on ServiceProviderType element.");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public TitleTextList getTitleTextList() {
        return this.m_titles;
    }

    public Hashtable getPortParameterList() {
        return this.m_portParameterList;
    }

    public Hashtable getOperationParameterList() {
        return this.m_operationParameterList;
    }

    public boolean canChange() {
        return this.m_canChange;
    }

    public boolean canCreate() {
        return this.m_canCreate;
    }

    public Enumeration getOperationParameters() {
        return this.m_operationParameters.elements();
    }

    public Enumeration getPortParameters() {
        return this.m_portParameters.elements();
    }
}

