/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDefEnumeration;
import com.sap.caf.mp.core.data.service.registry.types.ParameterValueDef;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterValueDefEnumeration
implements IParameterValueDefEnumeration {
    private static final String ATTRIBUTE_NAME_DEFAULT = "default";
    private static final String ELEMENT_NAME_PARAMETERVALUE = "ParameterValue";
    private Hashtable m_enumeration = new Hashtable();
    private IParameterValueDef m_default;

    protected ParameterValueDefEnumeration(Element element, String fallbackLanguage) throws EngineException {
        String defaultName = null;
        NamedNodeMap map = element.getAttributes();
        int count = map.getLength();
        for (int i = 0; i < count; ++i) {
            Attr child = (Attr)map.item(i);
            if (!child.getLocalName().equals(ATTRIBUTE_NAME_DEFAULT)) continue;
            defaultName = child.getValue();
        }
        if (defaultName == null) {
            throw new EngineException("Invalid input file: default attribute missing on parameter value definition.");
        }
        this.m_enumeration = new Hashtable();
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null || !localName.equalsIgnoreCase(ELEMENT_NAME_PARAMETERVALUE)) continue;
            ParameterValueDef valueDef = new ParameterValueDef((Element)child, fallbackLanguage);
            this.m_enumeration.put(valueDef.getName(), valueDef);
        }
        this.m_default = (IParameterValueDef)this.m_enumeration.get(defaultName);
        if (this.m_default == null) {
            throw new EngineException("Invalid input file: Default parameter value missing for parameter list enumeration.");
        }
    }

    public int size() {
        return this.m_enumeration.size();
    }

    public Enumeration elements() {
        return this.m_enumeration.elements();
    }

    public IParameterValueDef getDefault() {
        return this.m_default;
    }
}

