/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.text.TitleText;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDef;
import com.sap.caf.mp.core.data.service.registry.types.TitleListHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterValueDef
implements IParameterValueDef {
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ELEMENT_NAME_TITLELIST = "TitleList";
    private String m_name = null;
    private TitleTextList m_list = null;

    protected ParameterValueDef(Element element, String fallbackLanguage) throws EngineException {
        NamedNodeMap map = element.getAttributes();
        int count = map.getLength();
        for (int i = 0; i < count; ++i) {
            Attr child = (Attr)map.item(i);
            if (!child.getLocalName().equals(ATTRIBUTE_NAME_NAME)) continue;
            this.m_name = child.getValue();
        }
        if (this.m_name == null) {
            throw new EngineException("Invalid input file: name attribute missing on parameter value definition.");
        }
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null || !localName.equalsIgnoreCase(ELEMENT_NAME_TITLELIST)) continue;
            this.m_list = TitleListHelper.parseTitleTextList((Element)child, fallbackLanguage);
        }
        if (this.m_list == null) {
            throw new EngineException("Invalid input file: TitleList element missing on parameter value definition.");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public TitleTextList getTitleList() {
        return this.m_list;
    }

    public String resolveText(String language) {
        TitleText text = this.m_list.resolveText(language);
        return text.getText();
    }
}

