/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.util.MessageUtils;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.manager.api.IServiceManager;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.service.registry.ServiceRegistryPersistenceImpl;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefs;
import com.sap.caf.mp.core.data.service.registry.types.ServiceProviderTypeDefs;
import com.sap.caf.mp.core.user.IUserContext;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ServiceRegistry
implements IServicesRegistry {
    private ServiceProviderTypeDefs m_typeDefs;
    private ICNConnectionPool m_connectionPool;
    private ServiceRegistryPersistenceImpl m_persistence;
    private String m_fallbackLanguage;
    private IDataServiceFactory m_dataServiceFactory;
    private ICoreFactory m_coreFactory;

    public ServiceRegistry(ICoreFactory coreFactory, InputStream providerTypeDefs, ICNConnectionPool connectionPool, String fallbackLanguage, IDataServiceFactory dataServiceFactory) throws EngineException {
        if (providerTypeDefs != null) {
            this.m_typeDefs = new ServiceProviderTypeDefs(coreFactory, providerTypeDefs, fallbackLanguage);
        }
        this.m_coreFactory = coreFactory;
        this.m_connectionPool = connectionPool;
        this.m_dataServiceFactory = dataServiceFactory;
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_persistence = new ServiceRegistryPersistenceImpl(connectionPool, dataServiceFactory, this.m_coreFactory.getCoreContext());
    }

    public IServiceProviderTypeDefs getServiceProviderTypeDefs() {
        return this.m_typeDefs;
    }

    public void deleteServiceDefinition(String id, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_persistence.deleteServiceDefinition(id);
    }

    public IServiceDefinition readServiceDefinition(String id) throws InvocationException, EngineException {
        return this.m_persistence.getServiceDefinition(id);
    }

    public void writeServiceDefinition(IServiceDefinition definition, IUserContext ctxt) throws InvocationException, EngineException {
        if (this.m_persistence.checkServiceDefExists(definition.getId())) {
            throw new InvocationException("There is already a service with this name registered.");
        }
        this.m_persistence.writeServiceDefinition(definition, ctxt);
    }

    protected void updateServiceDefinition(IServiceDefinition definition, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_persistence.writeServiceDefinition(definition, ctxt);
    }

    protected boolean checkServiceDefExists(String id) throws EngineException {
        return this.m_persistence.checkServiceDefExists(id);
    }

    public Vector importServiceDefinitions(String serviceTypeName, Properties properties) throws InvocationException, EngineException {
        IServiceProviderTypeDef def = this.m_typeDefs.getServiceProviderDef(serviceTypeName);
        if (def == null) {
            throw new InvocationException(MessageUtils.format((String)"There is no service provider type names {0} registered.", (String)serviceTypeName));
        }
        IServiceManager manager = null;
        try {
            manager = (IServiceManager)Class.forName(def.getImplementationClassName()).newInstance();
        }
        catch (InstantiationException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be instantiated.", (String)serviceTypeName), (Exception)e);
        }
        catch (IllegalAccessException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be instantiated due to permission settings.", (String)serviceTypeName), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            BaseLogManager.error(this.getClass(), (String)("Error instantiating class: " + def.getImplementationClassName()), (Exception)e);
            throw new InvocationException(MessageUtils.format((String)"The implementation class for the service type named {0} could not be found.", (String)serviceTypeName), (Exception)e);
        }
        Vector serviceDefs = manager.importServiceDefinition(def.getName(), properties, this.m_dataServiceFactory);
        return serviceDefs;
    }

    public Enumeration getServiceDefinitionInfos() throws EngineException {
        return this.m_persistence.getServiceDefinitionInfos().elements();
    }

    public Enumeration getServiceDefinitionInfos(String typeName) throws EngineException {
        return this.m_persistence.getServiceDefinitionInfos(typeName).elements();
    }
}

