/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.mapping;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.mapping.api.IMappingRuleEntry;
import com.sap.caf.mp.core.data.mapping.api.MappingRule;
import com.sap.caf.mp.core.data.mapping.api.MappingRuleEntry;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.caf.mp.core.user.IUserContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class MappingRulesPersistenceImpl {
    private static final String m_stmtRuleInsert = "INSERT INTO CAF_RT_MAPDEF(RULE_ID,MSG_ID_SRC,MSG_ID_TRG,CREATOR,CREATED,CHANGER,CHANGED) VALUES(?,?,?,?,?,?,?)";
    private static final String m_stmtRuleUpdate = "UPDATE CAF_RT_MAPDEF SET MSG_ID_SRC=?, MSG_ID_TRG=?, CHANGER=?, CHANGED=? WHERE RULE_ID=?";
    private static final String m_stmtRuleSelect = "SELECT * FROM CAF_RT_MAPDEF WHERE RULE_ID=?";
    private static final String m_stmtRuleSelectBySource = "SELECT * FROM CAF_RT_MAPDEF WHERE MSG_ID_SRC=?";
    private static final String m_stmtRuleSelectByTarget = "SELECT * FROM CAF_RT_MAPDEF WHERE MSG_ID_TRG=?";
    private static final String m_stmtRuleSelectAll = "SELECT RULE_ID FROM CAF_RT_MAPDEF";
    private static final String m_stmtRuleSelectSourceTarget = "SELECT * FROM CAF_RT_MAPDEF WHERE MSG_ID_SRC=? AND MSG_ID_TRG=?";
    private static final String m_stmtRuleDelete = "DELETE FROM CAF_RT_MAPDEF WHERE RULE_ID=?";
    private static final String m_stmtRuleEntryInsert = "INSERT INTO CAF_RT_MAPRLE(RULE_ID,RULE_SEQUENCE,SEMANTIC_TYPE,SOURCE_EXPR,TARGET_EXPR) VALUES(?,?,?,?,?);";
    private static final String m_stmtRuleEntrySelect = "SELECT * FROM CAF_RT_MAPRLE WHERE RULE_ID=? ORDER BY RULE_SEQUENCE";
    private static final String m_stmtRuleEntryDelete = "DELETE FROM CAF_RT_MAPRLE WHERE RULE_ID=?";
    private ICNConnectionPool m_pool;

    public MappingRulesPersistenceImpl(ICNConnectionPool pool) {
        this.m_pool = pool;
    }

    public MappingRule addMappingRule(String uuid, String msgIdSrc, String msgIdTrg, Vector entries, IUserContext ctxt) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            String uniqueId = ctxt.getUniqueId();
            Date now = GregorianCalendar.getInstance().getTime();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleInsert);
            stmt.setString(1, uuid);
            if (msgIdSrc == null) {
                msgIdSrc = "";
            }
            stmt.setString(2, "[" + msgIdSrc);
            if (msgIdTrg == null) {
                msgIdTrg = "";
            }
            stmt.setString(3, "[" + msgIdTrg);
            stmt.setString(4, uniqueId);
            stmt.setLong(5, now.getTime());
            stmt.setString(6, uniqueId);
            stmt.setLong(7, now.getTime());
            stmt.execute();
            stmt.close();
            Enumeration enumeration = entries.elements();
            int sequence = 1;
            stmt = conn.prepareStatement(m_stmtRuleEntryInsert);
            while (enumeration.hasMoreElements()) {
                IMappingRuleEntry entry = (IMappingRuleEntry)enumeration.nextElement();
                stmt.setString(1, uuid);
                stmt.setInt(2, sequence);
                ++sequence;
                stmt.setInt(3, entry.getType());
                if (entry.getSourceExpression() != null) {
                    stmt.setString(4, "[" + entry.getSourceExpression());
                } else {
                    stmt.setString(4, "[");
                }
                if (entry.getTargetExpression() != null) {
                    stmt.setString(5, "[" + entry.getTargetExpression());
                } else {
                    stmt.setString(5, "[");
                }
                stmt.execute();
            }
            stmt.close();
            MappingRule rule = new MappingRule(uuid, msgIdSrc, msgIdTrg, entries, uniqueId, now, uniqueId, now);
            conn.commit();
            conn.close();
            return rule;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public MappingRule addMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        return this.addMappingRule(mappingRule.getRuleId(), mappingRule.getSourceMessageId(), mappingRule.getTargetMessageId(), mappingRule.getMappingRuleEntries(), ctxt);
    }

    public MappingRule changeMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            String uniqueId = ctxt.getUniqueId();
            Date now = GregorianCalendar.getInstance().getTime();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleUpdate);
            if (mappingRule.getSourceMessageId() != null) {
                stmt.setString(1, "[" + mappingRule.getSourceMessageId());
            } else {
                stmt.setString(1, "[");
            }
            if (mappingRule.getTargetMessageId() != null) {
                stmt.setString(2, "[" + mappingRule.getTargetMessageId());
            } else {
                stmt.setString(2, "[");
            }
            stmt.setString(3, uniqueId);
            stmt.setLong(4, now.getTime());
            stmt.setString(5, mappingRule.getRuleId());
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(m_stmtRuleEntryDelete);
            stmt.setString(1, mappingRule.getRuleId());
            stmt.execute();
            stmt.close();
            Enumeration enumeration = mappingRule.getMappingRuleEntries().elements();
            int sequence = 1;
            stmt = conn.prepareStatement(m_stmtRuleEntryInsert);
            while (enumeration.hasMoreElements()) {
                IMappingRuleEntry entry = (IMappingRuleEntry)enumeration.nextElement();
                stmt.setString(1, mappingRule.getRuleId());
                stmt.setInt(2, sequence);
                ++sequence;
                stmt.setInt(3, entry.getType());
                if (entry.getSourceExpression() != null) {
                    stmt.setString(4, "[" + entry.getSourceExpression());
                } else {
                    stmt.setString(4, "[");
                }
                if (entry.getTargetExpression() != null) {
                    stmt.setString(5, "[" + entry.getTargetExpression());
                } else {
                    stmt.setString(5, "[");
                }
                stmt.execute();
            }
            stmt.close();
            MappingRule rule = new MappingRule(mappingRule.getRuleId(), mappingRule.getSourceMessageId(), mappingRule.getTargetMessageId(), mappingRule.getMappingRuleEntries(), uniqueId, now, uniqueId, now);
            conn.commit();
            conn.close();
            return rule;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public MappingRule getMappingRule(String ruleId) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleSelect);
            stmt.setString(1, ruleId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new InvocationException("The mapping rule with this id does not exist.");
            }
            String msgIdSrc = rs.getString("MSG_ID_SRC").substring(1);
            String msgIdTrg = rs.getString("MSG_ID_TRG").substring(1);
            String creator = rs.getString("CREATOR");
            Date created = new Date(rs.getLong("CREATED"));
            String changer = rs.getString("CHANGER");
            Date changed = new Date(rs.getLong("CHANGED"));
            rs.close();
            stmt.close();
            Vector<MappingRuleEntry> entries = new Vector<MappingRuleEntry>();
            stmt = conn.prepareStatement(m_stmtRuleEntrySelect);
            stmt.setString(1, ruleId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int semanticType = rs.getInt("SEMANTIC_TYPE");
                String sourceExpr = rs.getString("SOURCE_EXPR").substring(1);
                String targetExpr = rs.getString("TARGET_EXPR").substring(1);
                entries.add(new MappingRuleEntry(sourceExpr, targetExpr, semanticType));
            }
            MappingRule rule = new MappingRule(ruleId, msgIdSrc, msgIdTrg, entries, creator, created, changer, changed);
            rs.close();
            stmt.close();
            conn.close();
            return rule;
        }
        catch (InvocationException ex) {
            BaseLogManager.error(this.getClass(), (Exception)((Object)ex));
            PersistenceManagers.recoverAndClose(conn);
            throw ex;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getMappingRuleIds() throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            Vector<String> entries = new Vector<String>();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleSelectAll);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String ruleId = rs.getString("RULE_ID");
                entries.add(ruleId);
            }
            rs.close();
            stmt.close();
            conn.close();
            return entries;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getMappingRuleIds(String msgIdSrc, String msgIdTrg) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            Vector<String> entries = new Vector<String>();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleSelectSourceTarget);
            stmt.setString(1, "[" + msgIdSrc);
            stmt.setString(2, "[" + msgIdTrg);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String ruleId = rs.getString("RULE_ID");
                entries.add(ruleId);
            }
            rs.close();
            stmt.close();
            conn.close();
            return entries;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getMappingRuleIdsBySource(String msgIdSrc) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            Vector<String> entries = new Vector<String>();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleSelectBySource);
            stmt.setString(1, "[" + msgIdSrc);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String ruleId = rs.getString("RULE_ID");
                entries.add(ruleId);
            }
            rs.close();
            stmt.close();
            conn.close();
            return entries;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public Vector getMappingRuleIdsByTarget(String msgIdTrg) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            Vector<String> entries = new Vector<String>();
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleSelectByTarget);
            stmt.setString(1, "[" + msgIdTrg);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String ruleId = rs.getString("RULE_ID");
                entries.add(ruleId);
            }
            rs.close();
            stmt.close();
            conn.close();
            return entries;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    public void deleteMappingRule(String ruleId) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtRuleDelete);
            stmt.setString(1, ruleId);
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(m_stmtRuleEntryDelete);
            stmt.setString(1, ruleId);
            stmt.execute();
            stmt.close();
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }
}

