/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.interfce.base.Operation;
import com.sap.caf.mp.core.data.service.interfce.base.Operationpart;
import com.sap.caf.mp.core.data.service.interfce.base.Porttype;
import com.sap.caf.mp.core.data.service.manager.wsdl11.SOAPToMessageValueConverter;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Message;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl0.LoaderImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaAutoImportURIResolver;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLNamedNode;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;

public class WsdlToIMessageConverter {
    public static final String SOAP_ACTION = "soapAction";
    public static final String ADDRESS = "address";
    private static final String STYLE_ATTRIBUTE = "style";
    private static final String USE_ATTRIBUTE = "use";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String PARTS_ATTRIBUTE = "parts";
    private static final String SOAP_ADDRESS_TAG = "address";
    private static final String SOAP_BINDING_TAG = "binding";
    private static final String SOAP_OPERATION_TAG = "operation";
    private static final String SOAP_BODY_TAG = "body";
    private static final String SOAP_HEADER_TAG = "header";
    private static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String LITERAL = "literal";
    private static final String DOCUMENT = "document";
    private static final String XMLNS_PREFIX = "xmlns:";
    private String wsdlPath;
    private URL proxyUrl;
    private Reader wsdlText;
    private IDataServiceFactory dataServiceFactory;
    private Vector serviceDefinitions;
    private Map portTypes;
    private WSDLDOMLoader wsdlLoader;
    private WSDLDefinitions wsdlDefinitions;
    private ArrayList wsdlServices;
    private ArrayList wsdlBindings;
    private ArrayList wsdlPortTypes;
    private ArrayList wsdlMessages;
    private Map messages;
    private Map elements;
    private Map types;
    private Map namespaces;
    private Set topLevelTypes;
    private Set topLevelElements;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$manager$wsdl11$WsdlToIMessageConverter;

    public WsdlToIMessageConverter(String wsdlPath, URL proxyUrl, IDataServiceFactory dataServiceFactory) {
        this.wsdlPath = wsdlPath;
        this.proxyUrl = proxyUrl;
        this.wsdlText = null;
        this.dataServiceFactory = dataServiceFactory;
    }

    public WsdlToIMessageConverter(Reader wsdlText, IDataServiceFactory dataServiceFactory) {
        this.wsdlPath = null;
        this.proxyUrl = null;
        this.wsdlText = wsdlText;
        this.dataServiceFactory = dataServiceFactory;
    }

    public Vector getServiceDefinitions(String typeName) throws InvocationException {
        block13: {
            this.serviceDefinitions = new Vector();
            this.wsdlLoader = new WSDLDOMLoader();
            if (this.proxyUrl != null) {
                this.wsdlLoader.setHttpProxy(this.proxyUrl.getHost(), Integer.toString(this.proxyUrl.getPort()));
            }
            try {
                if (this.wsdlPath != null) {
                    this.wsdlDefinitions = this.wsdlLoader.loadWSDLDocument(this.wsdlPath);
                    break block13;
                }
                if (this.wsdlText != null) {
                    this.wsdlDefinitions = this.wsdlLoader.loadWSDLDocument((InputStream)new ReaderInputStream(this.wsdlText));
                    break block13;
                }
                throw new InvocationException("Invalid wsdl");
            }
            catch (WSDLException wsdle) {
                String errorMessage = null;
                if (wsdle.getCause() != null) {
                    errorMessage = wsdle.getCause().getLocalizedMessage();
                }
                BaseLogManager.error(this.getClass(), (Exception)((Object)wsdle));
                throw new InvocationException(errorMessage != null ? errorMessage : "Can not load wsdl file or invalid one", (Exception)((Object)wsdle));
            }
        }
        this.wsdlServices = this.wsdlDefinitions.getServices();
        this.wsdlBindings = this.getReferencedWsdlBindings(this.wsdlDefinitions.getBindings());
        this.wsdlPortTypes = this.getReferencedWsdlPorttypes(this.wsdlDefinitions.getPortTypes());
        this.wsdlMessages = this.getReferencedWsdlMessages(this.wsdlDefinitions.getMessages());
        this.portTypes = this.getPortTypes(this.wsdlDefinitions.getSchemaDefinitions());
        for (int i = 0; i < this.wsdlServices.size(); ++i) {
            WSDLService wsdlService = (WSDLService)this.wsdlServices.get(i);
            ArrayList wsdlPorts = wsdlService.getPorts();
            for (int j = 0; j < wsdlPorts.size(); ++j) {
                WSDLPort wsdlPort = (WSDLPort)wsdlPorts.get(j);
                WSDLExtension wsdlExtension = wsdlPort.getExtension();
                if (!wsdlExtension.getLocalName().equals("address") || !wsdlExtension.getURI().equals(SOAP_NAMESPACE)) continue;
                String location = wsdlExtension.getAttribute(LOCATION_ATTRIBUTE);
                if (location == null) {
                    throw new InvocationException("Invalid wsdl missing location attribute for port " + wsdlPort.getName());
                }
                ServiceDefinition serviceDefinition = new ServiceDefinition(typeName, BaseUUIDManager.getUUIDStringFromBytes((byte[])BaseUUIDManager.generateUUID(), (boolean)false), null, null, null, null, this.dataServiceFactory);
                serviceDefinition.setProperty("address", location);
                boolean found = false;
                for (int k = 0; k < this.wsdlBindings.size(); ++k) {
                    WSDLBinding wsdlBinding = (WSDLBinding)this.wsdlBindings.get(k);
                    QName wsdlBindingName = new QName(wsdlBinding.getName(), wsdlBinding.getNamespace());
                    if (!wsdlPort.getBinding().equals((Object)wsdlBindingName)) continue;
                    WsdlToIMessageConverter.processServiceDefinition(serviceDefinition, wsdlBinding);
                    if (!this.portTypes.containsKey(wsdlBinding.getType())) {
                        throw new InvocationException("Invalid wsdl missing porttype for binding " + wsdlBinding.getName());
                    }
                    IPorttype porttype = (IPorttype)this.portTypes.get(wsdlBinding.getType());
                    serviceDefinition.setPortType(porttype);
                    Iterator l = porttype.getNamespaces().entrySet().iterator();
                    while (l.hasNext()) {
                        Map.Entry namespace = l.next();
                        String prefix = (String)namespace.getKey();
                        String uri = (String)namespace.getValue();
                        serviceDefinition.setProperty(XMLNS_PREFIX + prefix, uri);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    throw new InvocationException("Invalid wsdl missing binding for port " + wsdlPort.getName());
                }
                this.serviceDefinitions.add(serviceDefinition);
            }
        }
        return this.serviceDefinitions;
    }

    private static void processServiceDefinition(ServiceDefinition serviceDefinition, WSDLBinding wsdlBinding) throws InvocationException {
        ArrayList wsdlBindingOperations = wsdlBinding.getOperations();
        WSDLExtension extension = WsdlToIMessageConverter.getWsdlExtension(wsdlBinding.getExtensions(), SOAP_BINDING_TAG, SOAP_NAMESPACE);
        if (extension == null) {
            throw new InvocationException("Invalid wsdl");
        }
        String attributeValue = extension.getAttribute(STYLE_ATTRIBUTE);
        if (attributeValue != null && !attributeValue.equals(DOCUMENT)) {
            throw new InvocationException("Invalid wsdl");
        }
        for (int j = 0; j < wsdlBindingOperations.size(); ++j) {
            WSDLBindingOperation wsdlBindingOperation = (WSDLBindingOperation)wsdlBindingOperations.get(j);
            extension = WsdlToIMessageConverter.getWsdlExtension(wsdlBindingOperation.getExtensions(), SOAP_OPERATION_TAG, SOAP_NAMESPACE);
            if (extension == null) {
                throw new InvocationException("Invalid wsdl");
            }
            attributeValue = extension.getAttribute(STYLE_ATTRIBUTE);
            if (attributeValue != null && !attributeValue.equals(DOCUMENT)) {
                throw new InvocationException("Invalid wsdl");
            }
            String soapAction = extension.getAttribute(SOAP_ACTION);
            if (soapAction == null) {
                throw new InvocationException("Invalid wsdl");
            }
            serviceDefinition.setProperty(wsdlBindingOperation.getName(), SOAP_ACTION, soapAction);
            extension = WsdlToIMessageConverter.getWsdlExtension(wsdlBindingOperation.getInput().getExtensions(), SOAP_BODY_TAG, SOAP_NAMESPACE);
            if (extension == null) {
                throw new InvocationException("Invalid wsdl");
            }
            attributeValue = extension.getAttribute(USE_ATTRIBUTE);
            if (attributeValue == null || !attributeValue.equals(LITERAL)) {
                throw new InvocationException("Invalid wsdl");
            }
            extension = WsdlToIMessageConverter.getWsdlExtension(wsdlBindingOperation.getOutput().getExtensions(), SOAP_BODY_TAG, SOAP_NAMESPACE);
            if (extension == null) {
                throw new InvocationException("Invalid wsdl");
            }
            attributeValue = extension.getAttribute(USE_ATTRIBUTE);
            if (attributeValue == null || !attributeValue.equals(LITERAL)) {
                throw new InvocationException("Invalid wsdl");
            }
            if (WsdlToIMessageConverter.getWsdlExtension(wsdlBindingOperation.getInput().getExtensions(), SOAP_HEADER_TAG, SOAP_NAMESPACE) == null && WsdlToIMessageConverter.getWsdlExtension(wsdlBindingOperation.getOutput().getExtensions(), SOAP_HEADER_TAG, SOAP_NAMESPACE) == null) continue;
            throw new InvocationException("Invalid wsdl soap header tag for binding operation " + wsdlBindingOperation.getName());
        }
    }

    private static WSDLExtension getWsdlExtension(ArrayList wsdlExtenstions, String localName, String uri) {
        for (int i = 0; i < wsdlExtenstions.size(); ++i) {
            WSDLExtension wsdlExtension = (WSDLExtension)wsdlExtenstions.get(i);
            if (!wsdlExtension.getLocalName().equals(localName) || !wsdlExtension.getURI().equals(uri)) continue;
            return wsdlExtension;
        }
        return null;
    }

    private ArrayList getReferencedWsdlBindings(ArrayList allWsdlBindings) {
        int i;
        HashSet<QName> referencedWsdlBindingNames = new HashSet<QName>();
        ArrayList<WSDLBinding> wsdlBindings = new ArrayList<WSDLBinding>();
        for (i = 0; i < this.wsdlServices.size(); ++i) {
            WSDLService wsdlService = (WSDLService)this.wsdlServices.get(i);
            ArrayList wsdlPorts = wsdlService.getPorts();
            for (int j = 0; j < wsdlPorts.size(); ++j) {
                WSDLPort wsdlPort = (WSDLPort)wsdlPorts.get(j);
                if (!wsdlPort.getExtension().getLocalName().equals("address") || !wsdlPort.getExtension().getURI().equals(SOAP_NAMESPACE)) continue;
                referencedWsdlBindingNames.add(wsdlPort.getBinding());
            }
        }
        for (i = 0; i < allWsdlBindings.size(); ++i) {
            WSDLBinding wsdlBinding = (WSDLBinding)allWsdlBindings.get(i);
            if (!referencedWsdlBindingNames.contains(wsdlBinding.getQName())) continue;
            wsdlBindings.add(wsdlBinding);
        }
        return wsdlBindings;
    }

    private ArrayList getReferencedWsdlPorttypes(ArrayList allWsdlPorttypes) {
        int i;
        HashSet<QName> referencedWsdlPorttypeNames = new HashSet<QName>();
        ArrayList<WSDLPortType> wsdlPorttypes = new ArrayList<WSDLPortType>();
        for (i = 0; i < this.wsdlBindings.size(); ++i) {
            WSDLBinding wsdlBinding = (WSDLBinding)this.wsdlBindings.get(i);
            referencedWsdlPorttypeNames.add(wsdlBinding.getType());
        }
        for (i = 0; i < allWsdlPorttypes.size(); ++i) {
            WSDLPortType wsdlPortType = (WSDLPortType)allWsdlPorttypes.get(i);
            if (!referencedWsdlPorttypeNames.contains(wsdlPortType.getQName())) continue;
            wsdlPorttypes.add(wsdlPortType);
        }
        return wsdlPorttypes;
    }

    private ArrayList getReferencedWsdlMessages(ArrayList allWsdlMessages) {
        int i;
        HashSet<QName> referencedWsdlMessageNames = new HashSet<QName>();
        ArrayList<WSDLMessage> wsdlMessages = new ArrayList<WSDLMessage>();
        for (i = 0; i < this.wsdlPortTypes.size(); ++i) {
            WSDLPortType wsdlPortType = (WSDLPortType)this.wsdlPortTypes.get(i);
            for (int j = 0; j < wsdlPortType.getOperationCount(); ++j) {
                WSDLOperation wsdlOperation = wsdlPortType.getOperation(j);
                referencedWsdlMessageNames.add(wsdlOperation.getInput().getMessage());
                referencedWsdlMessageNames.add(wsdlOperation.getOutput().getMessage());
                for (int k = 0; k < wsdlOperation.getFaultList().size(); ++k) {
                    referencedWsdlMessageNames.add(((WSDLFault)wsdlOperation.getFaultList().get(k)).getMessage());
                }
            }
        }
        for (i = 0; i < allWsdlMessages.size(); ++i) {
            WSDLMessage wsdlMessage = (WSDLMessage)allWsdlMessages.get(i);
            if (!referencedWsdlMessageNames.contains(wsdlMessage.getQName())) continue;
            wsdlMessages.add(wsdlMessage);
        }
        return wsdlMessages;
    }

    private Map getPortTypes(ArrayList wsdlSchemaDefinitions) throws InvocationException {
        HashMap<QName, Porttype> portTypes = new HashMap<QName, Porttype>();
        this.types = new HashMap();
        this.namespaces = new HashMap();
        this.elements = new HashMap();
        DOMSource[] wsdlSchemaDefinitionsAsArray = wsdlSchemaDefinitions.toArray(new DOMSource[0]);
        this.parseSchema(wsdlSchemaDefinitionsAsArray);
        this.messages = this.getIMessages();
        for (int i = 0; i < this.wsdlPortTypes.size(); ++i) {
            WSDLPortType wsdlPortType = (WSDLPortType)this.wsdlPortTypes.get(i);
            Porttype portType = new Porttype(wsdlPortType.getName());
            Iterator j = this.namespaces.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry currentNamespace = j.next();
                String currentPrefix = (String)currentNamespace.getKey();
                String currentUri = (String)currentNamespace.getValue();
                portType.addNamespace(currentPrefix, currentUri);
            }
            for (int k = 0; k < wsdlPortType.getOperationCount(); ++k) {
                WSDLOperation wsdlOperation = wsdlPortType.getOperation(k);
                IOperation operation = this.getIOperation(wsdlOperation);
                if (operation == null) {
                    throw new InvocationException("Invalid wsdl missing operation " + wsdlOperation.getName());
                }
                if (portType.getOperation(operation.getName()) != null) {
                    throw new InvocationException("Invalid wsdl more than one operation with one and the same name: " + operation.getName());
                }
                portType.addOperation(operation);
            }
            portTypes.put(new QName(wsdlPortType.getName(), wsdlPortType.getNamespace()), portType);
        }
        return portTypes;
    }

    private String constructName(String namespaceUri, String localName) {
        if (namespaceUri != null && !namespaceUri.equals("")) {
            String prefix = null;
            Iterator i = this.namespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry currentNamespace = i.next();
                String currentPrefix = (String)currentNamespace.getKey();
                String currentUri = (String)currentNamespace.getValue();
                if (!namespaceUri.equals(currentUri)) continue;
                prefix = currentPrefix;
                break;
            }
            if (prefix == null) {
                prefix = "ns" + Integer.toString(this.namespaces.size() + 1);
                this.namespaces.put(prefix, namespaceUri);
            }
            return prefix + ':' + localName;
        }
        return localName;
    }

    public static DeconstructedName deconstructName(String name, Properties operationConfig) {
        int separatorPos = name.lastIndexOf(58);
        if (separatorPos == -1) {
            return new DeconstructedName(null, null, name);
        }
        String prefix = name.substring(0, separatorPos);
        return new DeconstructedName(prefix, operationConfig.getProperty(XMLNS_PREFIX + prefix.toString()), name.substring(separatorPos + 1));
    }

    public static DeconstructedName deconstructName(String namespaceUri, String localName, Properties operationConfig) {
        if (namespaceUri == null || namespaceUri.equals("")) {
            return new DeconstructedName(null, null, localName);
        }
        Iterator<Map.Entry<Object, Object>> i = operationConfig.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> currentNamespace = i.next();
            if (!((String)currentNamespace.getKey()).startsWith(XMLNS_PREFIX) || !currentNamespace.getValue().equals(namespaceUri)) continue;
            return new DeconstructedName(((String)currentNamespace.getKey()).substring(XMLNS_PREFIX.length()), namespaceUri, localName);
        }
        return new DeconstructedName(null, namespaceUri, localName);
    }

    private IOperation getIOperation(WSDLOperation wsdlOperation) throws InvocationException {
        Operation operation = new Operation(wsdlOperation.getName());
        WSDLChannel wsdlInputChannel = wsdlOperation.getInput();
        WSDLChannel wsdlOutputChannel = wsdlOperation.getOutput();
        ArrayList wsdlFaultChannels = wsdlOperation.getFaultList();
        if (wsdlInputChannel == null || wsdlOutputChannel == null) {
            throw new InvocationException("Invalid wsdl only request\response is supported");
        }
        operation.setInputOperationpart(this.getIOperationpart((WSDLNamedNode)wsdlInputChannel));
        operation.setOutputOperationpart(this.getIOperationpart((WSDLNamedNode)wsdlOutputChannel));
        for (int i = 0; i < wsdlFaultChannels.size(); ++i) {
            WSDLFault wsdlFault = (WSDLFault)wsdlFaultChannels.get(i);
            IOperationpart operationPart = this.getIOperationpart((WSDLNamedNode)wsdlFault);
            operation.addFaultOperationpart(operationPart);
        }
        return operation;
    }

    private IOperationpart getIOperationpart(WSDLNamedNode wsdlChannel) throws InvocationException {
        QName message = null;
        if (wsdlChannel instanceof WSDLChannel) {
            message = ((WSDLChannel)wsdlChannel).getMessage();
        }
        if (wsdlChannel instanceof WSDLFault) {
            message = ((WSDLFault)wsdlChannel).getMessage();
        }
        if (!this.messages.containsKey(message)) {
            throw new InvocationException("Invalid wsdl missing message " + message.getName());
        }
        Operationpart operationPart = new Operationpart(message.getName());
        operationPart.setMessage((IMessage)this.messages.get(message));
        return operationPart;
    }

    /*
     * WARNING - void declaration
     */
    private Map getIMessages() throws InvocationException {
        HashMap<QName, Message> messages = new HashMap<QName, Message>();
        for (int i = 0; i < this.wsdlMessages.size(); ++i) {
            WSDLMessage wsdlMessage = (WSDLMessage)this.wsdlMessages.get(i);
            Message message = new Message(this.constructName(wsdlMessage.getQName().getURI(), wsdlMessage.getQName().getLocalName()));
            for (int j = 0; j < wsdlMessage.getPartCount(); ++j) {
                void var8_8;
                WSDLPart wsdlPart = wsdlMessage.getPart(j);
                if (wsdlPart.getType() == null) {
                    throw new InvocationException("Invalid wsdl missing message element ");
                }
                switch (wsdlPart.getStyle()) {
                    case 2: {
                        IType structure = (IType)this.types.get(wsdlPart.getType());
                        if (structure != null) break;
                        if (wsdlPart.getType().getURI().equals(SCHEMA_NAMESPACE)) {
                            String schemaPrimitiveTypeName = wsdlPart.getType().getName();
                            int simpleTypeBase = WsdlToIMessageConverter.getSimpleTypeBase(schemaPrimitiveTypeName);
                            if (simpleTypeBase == -1) {
                                throw new InvocationException("Invalid wsdl such primitive type is not handled: " + schemaPrimitiveTypeName);
                            }
                            structure = new SimpleType(simpleTypeBase);
                            break;
                        }
                        throw new InvocationException("Invalid wsdl");
                    }
                    case 1: {
                        IType structure = (IStructure)this.elements.get(wsdlPart.getType());
                        break;
                    }
                    default: {
                        throw new InvocationException("Invalid wsdl");
                    }
                }
                Messagepart messagePart = new Messagepart(this.constructName(wsdlPart.getQName().getURI(), wsdlPart.getQName().getLocalName()));
                messagePart.setStructure((IStructure)var8_8);
                message.addMessagepart((IMessagepart)messagePart);
            }
            messages.put(wsdlMessage.getQName(), message);
        }
        return messages;
    }

    private void parseSchema(DOMSource[] schemaSources) throws InvocationException {
        int i;
        Schema schema;
        LoaderImpl schemaLoader = new LoaderImpl();
        this.topLevelTypes = new HashSet();
        this.topLevelElements = new HashSet();
        try {
            schemaLoader.setUriResolver((URIResolver)new SchemaAutoImportURIResolver());
            schema = schemaLoader.load((Source[])schemaSources);
        }
        catch (SchemaComponentException sce) {
            BaseLogManager.error((Class)(class$com$sap$caf$mp$core$data$service$manager$wsdl11$WsdlToIMessageConverter == null ? (class$com$sap$caf$mp$core$data$service$manager$wsdl11$WsdlToIMessageConverter = WsdlToIMessageConverter.class$("com.sap.caf.mp.core.data.service.manager.wsdl11.WsdlToIMessageConverter")) : class$com$sap$caf$mp$core$data$service$manager$wsdl11$WsdlToIMessageConverter), (Exception)((Object)sce));
            throw new InvocationException("Can not load schema from the wsdl file", (Exception)((Object)sce));
        }
        TypeDefinitionBase[] typeDefinitionBases = schema.getTopLevelTypeDefinitionsArray();
        for (i = 0; i < typeDefinitionBases.length; ++i) {
            if (typeDefinitionBases[i].isBuiltIn()) continue;
            QName typeName = new QName(typeDefinitionBases[i].getName(), typeDefinitionBases[i].getTargetNamespace());
            if (this.topLevelTypes.contains(typeName)) {
                throw new InvocationException("Invalid wsdl schema two top level types with one and the same name: " + typeName);
            }
            this.topLevelTypes.add(typeName);
        }
        for (i = 0; i < typeDefinitionBases.length; ++i) {
            QName typeName;
            TypeDefinitionBase typeDefinitionBase = typeDefinitionBases[i];
            if (typeDefinitionBase.isBuiltIn() || this.types.containsKey(typeName = new QName(typeDefinitionBase.getName(), typeDefinitionBase.getTargetNamespace()))) continue;
            IType type = this.getIType(typeDefinitionBase);
            this.types.put(typeName, type);
        }
        ElementDeclaration[] schemaElementDeclarations = schema.getTopLevelElementDeclarationsArray();
        for (i = 0; i < schemaElementDeclarations.length; ++i) {
            QName elementName = new QName(schemaElementDeclarations[i].getName(), schemaElementDeclarations[i].getTargetNamespace());
            if (this.topLevelElements.contains(elementName)) {
                throw new InvocationException("Invalid wsdl schema two top level elements with one and the same name: " + elementName);
            }
            this.topLevelElements.add(elementName);
        }
        for (i = 0; i < schemaElementDeclarations.length; ++i) {
            ElementDeclaration schemaElementDeclaration = schemaElementDeclarations[i];
            IElement element = this.getIElement(schemaElementDeclaration, null);
            this.elements.put(new QName(schemaElementDeclaration.getName(), schemaElementDeclaration.getTargetNamespace()), element);
        }
    }

    private IType getIType(TypeDefinitionBase typeDefinitionBase) throws InvocationException {
        if (typeDefinitionBase instanceof ComplexTypeDefinition) {
            return this.getIComplexType((ComplexTypeDefinition)typeDefinitionBase);
        }
        if (typeDefinitionBase instanceof SimpleTypeDefinition) {
            return this.getISimpleType((SimpleTypeDefinition)typeDefinitionBase);
        }
        throw new InvocationException("Invalid wsdl schema");
    }

    private IElement getIElement(ElementDeclaration schemaElementDeclaration, Particle schemaParticle) throws InvocationException {
        if (schemaElementDeclaration.isAbstract()) {
            throw new InvocationException("Invalid wsdl schema there is abstract element ");
        }
        Element element = new Element(this.constructName(schemaElementDeclaration.getTargetNamespace(), schemaElementDeclaration.getName()));
        if (schemaParticle != null) {
            element.setMinOccurs(schemaParticle.getMinOccurs());
            element.setMaxOccurs(schemaParticle.isMaxOccursUnbounded() ? 0 : schemaParticle.getMaxOccurs());
        }
        element.setType(this.getIType(schemaElementDeclaration.getTypeDefinition()));
        return element;
    }

    private static int getSimpleTypeBase(String schemaPrimitiveTypeName) {
        if (schemaPrimitiveTypeName.equals("base64Binary")) {
            return 1;
        }
        if (schemaPrimitiveTypeName.equals("boolean")) {
            return 2;
        }
        if (schemaPrimitiveTypeName.equals("byte")) {
            return 3;
        }
        if (schemaPrimitiveTypeName.equals("date")) {
            return 4;
        }
        if (schemaPrimitiveTypeName.equals("decimal")) {
            return 5;
        }
        if (schemaPrimitiveTypeName.equals("double")) {
            return 6;
        }
        if (schemaPrimitiveTypeName.equals("float")) {
            return 7;
        }
        if (schemaPrimitiveTypeName.equals("int")) {
            return 8;
        }
        if (schemaPrimitiveTypeName.equals("integer")) {
            return 9;
        }
        if (schemaPrimitiveTypeName.equals("long")) {
            return 10;
        }
        if (schemaPrimitiveTypeName.equals("short")) {
            return 11;
        }
        if (schemaPrimitiveTypeName.equals("string")) {
            return 12;
        }
        if (schemaPrimitiveTypeName.equals("time")) {
            return 13;
        }
        if (schemaPrimitiveTypeName.equals("dateTime")) {
            return 14;
        }
        if (schemaPrimitiveTypeName.equals("unsignedByte")) {
            return 15;
        }
        if (schemaPrimitiveTypeName.equals("unsignedInt")) {
            return 16;
        }
        if (schemaPrimitiveTypeName.equals("unsignedLong")) {
            return 17;
        }
        if (schemaPrimitiveTypeName.equals("unsignedShort")) {
            return 18;
        }
        return -1;
    }

    private ISimpleType getISimpleType(SimpleTypeDefinition schemaSimpleType) throws InvocationException {
        QName simpleTypeName = new QName(schemaSimpleType.getName(), schemaSimpleType.getTargetNamespace());
        if (this.types.containsKey(simpleTypeName)) {
            return (ISimpleType)this.types.get(simpleTypeName);
        }
        if (schemaSimpleType.getPrimitiveTypeDefinition() == null) {
            throw new InvocationException("Invalid wsdl schema missing primitive type for simple type " + simpleTypeName);
        }
        int simpleTypeBase = WsdlToIMessageConverter.getSimpleTypeBase(schemaSimpleType.getName());
        if (simpleTypeBase == -1 && schemaSimpleType.getBaseTypeDefinition() != null) {
            simpleTypeBase = WsdlToIMessageConverter.getSimpleTypeBase(schemaSimpleType.getBaseTypeDefinition().getName());
        }
        if (simpleTypeBase == -1) {
            simpleTypeBase = WsdlToIMessageConverter.getSimpleTypeBase(schemaSimpleType.getPrimitiveTypeDefinition().getName());
        }
        if (simpleTypeBase == -1) {
            throw new InvocationException("Invalid wsdl schema such primitive type is not handled: " + schemaSimpleType.getPrimitiveTypeDefinition().getName());
        }
        SimpleType simpleType = new SimpleType(simpleTypeBase);
        if (this.topLevelTypes.contains(simpleTypeName)) {
            this.types.put(simpleTypeName, simpleType);
        }
        Facet[] facets = schemaSimpleType.getFacetsArray();
        for (int i = 0; i < facets.length; ++i) {
            String facetName = facets[i].getName();
            String facetValue = facets[i].getValue();
            if (facetName.equals("pattern") && simpleTypeBase == 12) {
                simpleType.addPattern(facetValue);
                continue;
            }
            if (facetName.equals("totalDigits")) {
                simpleType.setTotalDigits(Integer.parseInt(facetValue));
                continue;
            }
            if (facetName.equals("fractionDigits")) {
                simpleType.setFractionDigits(Integer.parseInt(facetValue));
                continue;
            }
            if (facetName.equals("maxLength")) {
                simpleType.setMaxLength(Integer.parseInt(facetValue));
                continue;
            }
            if (facetName.equals("minLength")) {
                simpleType.setMinLength(Integer.parseInt(facetValue));
                continue;
            }
            if (facetName.equals("enumeration")) {
                simpleType.addConstant(SOAPToMessageValueConverter.generateSimpleTypeValue(facetValue, (ISimpleType)simpleType));
                continue;
            }
            throw new InvocationException("Invalid wsdl schema such facet is not handled: " + facetName);
        }
        return simpleType;
    }

    private IComplexType getIComplexType(ComplexTypeDefinition schemaComplexType) throws InvocationException {
        Particle schemaParticle;
        ComplexType complexType = new ComplexType();
        if (schemaComplexType.isAbstract()) {
            throw new InvocationException("Invalid wsdl schema complex type is abstract");
        }
        if (schemaComplexType.getAttributeUsesArray().length > 0) {
            throw new InvocationException("Invalid wsdl schema no attributes are allowed");
        }
        QName complexTypeName = new QName(schemaComplexType.getName(), schemaComplexType.getTargetNamespace());
        if (this.types.containsKey(complexTypeName)) {
            return (IComplexType)this.types.get(complexTypeName);
        }
        if (this.topLevelTypes.contains(complexTypeName)) {
            this.types.put(complexTypeName, complexType);
        }
        if ((schemaParticle = schemaComplexType.getContentTypeContentModel()) == null) {
            return new ComplexType();
        }
        if (!(schemaParticle.getTerm() instanceof ModelGroup)) {
            throw new InvocationException("Invalid wsdl schema structure for a complex type is not handled");
        }
        ModelGroup schemaModelGroup = (ModelGroup)schemaParticle.getTerm();
        Particle[] schemaElementParticles = schemaModelGroup.getParticlesArray();
        if (schemaModelGroup.isCompositorAll()) {
            complexType.setMode(1);
        }
        if (schemaModelGroup.isCompositorChoice()) {
            complexType.setMode(2);
        }
        if (schemaModelGroup.isCompositorSequence()) {
            complexType.setMode(3);
        }
        for (int i = 0; i < schemaElementParticles.length; ++i) {
            ArrayList elements = new ArrayList();
            WsdlToIMessageConverter.processParticle(elements, schemaElementParticles[i]);
            for (int j = 0; j < elements.size(); ++j) {
                IElement element = this.getIElement((ElementDeclaration)elements.get(j), schemaElementParticles[i]);
                if (complexType.addElement(element) == null) continue;
                throw new InvocationException("Invalid wsdl schema");
            }
        }
        return complexType;
    }

    private static void processParticle(ArrayList elements, Particle particle) throws InvocationException {
        Base base = particle.getTerm();
        if (base instanceof ElementDeclaration) {
            ElementDeclaration schemaElementDeclaration = (ElementDeclaration)base;
            elements.add(schemaElementDeclaration);
        } else if (base instanceof ModelGroup) {
            ModelGroup subModelGroup = (ModelGroup)base;
            if (!subModelGroup.isCompositorSequence()) {
                throw new InvocationException("Invalid wsdl schema unhandled complex type structure");
            }
            Particle[] particles = subModelGroup.getParticlesArray();
            for (int j = 0; j < particles.length; ++j) {
                WsdlToIMessageConverter.processParticle(elements, particles[j]);
            }
        } else {
            throw new InvocationException("Invalid wsdl schema unhandled complex type structure (probably any)");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DeconstructedName {
        private String prefix;
        private String uri;
        private String localName;

        DeconstructedName(String prefix, String uri, String localName) {
            this.prefix = prefix;
            this.uri = uri;
            this.localName = localName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isQualified() {
            return this.prefix != null && !this.prefix.equals("") && this.uri != null && !this.uri.equals("");
        }

        public String getName() {
            if (this.prefix == null) {
                return this.localName;
            }
            return this.prefix + ':' + this.localName;
        }
    }
}

