/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.bag.IBagFactory;
import com.sap.caf.mp.core.data.service.BaseServiceResponse;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.IServiceResponse;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.manager.api.IServiceManager;
import com.sap.caf.mp.core.data.service.manager.wsdl11.MessageValueToSOAPConverter;
import com.sap.caf.mp.core.data.service.manager.wsdl11.SOAPToMessageValueConverter;
import com.sap.caf.mp.core.data.service.manager.wsdl11.WsdlToIMessageConverter;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.meta.api.ITypeFactory;
import com.sap.caf.mp.core.data.types.meta.api.ITypeRejection;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueFactory;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueRejection;
import com.sap.engine.services.webservices.jaxm.soap.SOAPConnectionImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;

public class WSDL11ServiceManager
implements IServiceManager {
    private static final String SOAP_ACTION_HTTP_HEADER_KEY = "SOAPAction";
    private static final String ENDPOINT_URL = "endpoint.url";
    private static final String ENDPOINT_AUTHORIZATION = "endpoint.authorization";
    private static final String ENDPOINT_USERNAME = "endpoint.username";
    private static final String ENDPOINT_PASSWORD = "endpoint.password";
    private static final String PROXY_USE = "proxy.use";
    private static final String PROXY_SERVER = "proxy.server";
    private static final String PROXY_HTTP_PROTOCOL = "http";
    private static final String BASIC_AUTHENTICATION = "BASIC";
    private IBagFactory bagFactory;
    private ITypeFactory typeFactory;
    private ITypeValueFactory typeValueFactory;
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$service$manager$wsdl11$WSDL11ServiceManager;

    public WSDL11ServiceManager() throws InvocationException {
        ICoreFactory coreFactory;
        try {
            InitialContext ctxt = new InitialContext();
            coreFactory = (ICoreFactory)ctxt.lookup("/sap.com/com.sap.caf/CoreFactory");
        }
        catch (NamingException e) {
            throw new InvocationException("Internal error", (Exception)e);
        }
        this.bagFactory = coreFactory.getBagFactory();
        this.typeFactory = coreFactory.getTypeFactory();
        this.typeValueFactory = coreFactory.getTypeValueFactory();
    }

    public Vector importServiceDefinition(String typeName, Properties properties, IDataServiceFactory factory) throws InvocationException, EngineException {
        if (BASIC_AUTHENTICATION.equals(properties.getProperty(ENDPOINT_AUTHORIZATION))) {
            throw new InvocationException("It is now possible to use authentication when loading the wsdl");
        }
        String wsdlPath = properties.getProperty(ENDPOINT_URL);
        if (wsdlPath == null) {
            throw new InvocationException("Invalid address");
        }
        URL proxyUrl = WSDL11ServiceManager.getProxy(properties);
        WsdlToIMessageConverter converter = new WsdlToIMessageConverter(wsdlPath, proxyUrl, factory);
        if (!wsdlPath.startsWith("http://") && !wsdlPath.startsWith("https://")) {
            throw new InvocationException("Invalid wsdl address, try using \"http://\" prefix");
        }
        Vector definitions = converter.getServiceDefinitions(typeName);
        Iterator iter = definitions.iterator();
        while (iter.hasNext()) {
            IServiceDefinition serviceDefinition = (IServiceDefinition)iter.next();
            if (this.isStructureWithCircles(serviceDefinition.getPortType())) {
                throw new InvocationException("It is now possible to load the wsdl because it has circular structures");
            }
            Enumeration enumeration = serviceDefinition.getOperationProperties().elements();
            while (enumeration.hasMoreElements()) {
                Properties prop = (Properties)enumeration.nextElement();
                prop.putAll((Map<?, ?>)serviceDefinition.getPortTypeProperties());
                prop.putAll((Map<?, ?>)properties);
                prop.put(ENDPOINT_URL, serviceDefinition.getPortTypeProperties().getProperty("address"));
            }
            serviceDefinition.getPortTypeProperties().putAll((Map<?, ?>)properties);
        }
        return definitions;
    }

    private void processTypeRejection(ITypeRejection typeRejection) throws InvocationException {
    }

    private void processTypeValueRejection(ITypeValueRejection typeValueRejection) throws InvocationException {
    }

    public IServiceResponse executeOperation(IMessageValue input, IOperation target, Properties operationConfig, Locale userLocal) throws InvocationException, EngineException {
        SOAPBody soapResponseBody;
        SOAPMessage soapResponse;
        Object result = null;
        String soapAction = operationConfig.getProperty("soapAction");
        if (soapAction == null) {
            throw new InvocationException("Invalid parameters");
        }
        String endpointUrl = operationConfig.getProperty(ENDPOINT_URL);
        if (endpointUrl == null) {
            throw new InvocationException("Invalid address");
        }
        SOAPConnection conn = this.getSOAPConnection(operationConfig);
        IOperationpart operationPart = target.getInputOperationpart();
        IMessage message = operationPart.getMessage();
        SOAPMessage soapRequest = MessageValueToSOAPConverter.getSoapMessage(input, operationConfig);
        if (soapAction.equals("")) {
            soapAction = "\"\"";
        }
        soapRequest.getMimeHeaders().addHeader(SOAP_ACTION_HTTP_HEADER_KEY, soapAction);
        try {
            soapRequest.getSOAPPart().getEnvelope().getHeader().detachNode();
            soapResponse = conn.call(soapRequest, (Object)new URLEndpoint(endpointUrl));
            soapResponseBody = soapResponse.getSOAPPart().getEnvelope().getBody();
        }
        catch (SOAPException soape) {
            String errorMessage = null;
            if (soape.getCause() != null) {
                errorMessage = soape.getCause().getLocalizedMessage();
            }
            BaseLogManager.error(this.getClass(), (Exception)((Object)soape));
            throw new EngineException(errorMessage != null ? errorMessage : "Web service error", (Exception)((Object)soape));
        }
        if (soapResponseBody.hasFault()) {
            SOAPFault soapFault = soapResponseBody.getFault();
            return new BaseServiceResponse((Exception)((Object)new EngineException(soapFault.getFaultString())));
        }
        IMessage responseMessage = target.getOutputOperationpart().getMessage();
        SOAPToMessageValueConverter converter = new SOAPToMessageValueConverter(operationConfig);
        IMessageValue value = converter.getMessageValue(soapResponse, responseMessage);
        return new BaseServiceResponse(value);
    }

    protected SOAPConnection getSOAPConnection(Properties operationConfig) throws InvocationException {
        URL proxyUrl;
        SOAPConnectionImpl conn = new SOAPConnectionImpl();
        boolean authorization = BASIC_AUTHENTICATION.equals(operationConfig.getProperty(ENDPOINT_AUTHORIZATION));
        if (authorization) {
            String authorizationUserName = operationConfig.getProperty(ENDPOINT_USERNAME);
            String authorizationPassword = operationConfig.getProperty(ENDPOINT_PASSWORD);
            if (authorizationUserName == null || authorizationPassword == null) {
                throw new InvocationException("Invalid username or password");
            }
            conn.setUserName(authorizationUserName);
            conn.setUserPassword(authorizationPassword);
        }
        if ((proxyUrl = WSDL11ServiceManager.getProxy(operationConfig)) != null) {
            conn.setProxy(proxyUrl.getHost(), proxyUrl.getPort());
        }
        return conn;
    }

    private static URL getProxy(Properties operationConfig) throws InvocationException {
        URL proxyUrl = null;
        boolean useProxy = Boolean.valueOf(operationConfig.getProperty(PROXY_USE));
        if (useProxy) {
            String proxyServer = operationConfig.getProperty(PROXY_SERVER);
            if (proxyServer == null) {
                throw new InvocationException("Invalid proxy address");
            }
            try {
                proxyUrl = new URL(proxyServer);
                if (!proxyUrl.getProtocol().equals(PROXY_HTTP_PROTOCOL)) {
                    throw new InvocationException("Invalid proxy address, try \"http://\" prefix");
                }
            }
            catch (MalformedURLException mue) {
                BaseLogManager.error((Class)(class$com$sap$caf$mp$core$data$service$manager$wsdl11$WSDL11ServiceManager == null ? (class$com$sap$caf$mp$core$data$service$manager$wsdl11$WSDL11ServiceManager = WSDL11ServiceManager.class$("com.sap.caf.mp.core.data.service.manager.wsdl11.WSDL11ServiceManager")) : class$com$sap$caf$mp$core$data$service$manager$wsdl11$WSDL11ServiceManager), (Exception)mue);
                throw new InvocationException("Invalid proxy address " + mue.getMessage(), (Exception)mue);
            }
        }
        return proxyUrl;
    }

    private boolean isStructureWithCircles(IPorttype porttype) {
        for (int i = 0; i < porttype.getOperationCount(); ++i) {
            IOperation operation = porttype.getOperation(i);
            if (this.isStructureWithCircles(operation.getInputOperationpart())) {
                return true;
            }
            if (this.isStructureWithCircles(operation.getOutputOperationpart())) {
                return true;
            }
            for (int j = 0; j < operation.getFaultOperationpartCount(); ++j) {
                if (!this.isStructureWithCircles(operation.getFaultOperationpart(j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStructureWithCircles(IOperationpart operationPart) {
        IMessage message = operationPart.getMessage();
        for (int i = 0; i < message.getMessagepartCount(); ++i) {
            IMessagepart messagePart = message.getMessagepart(i);
            if (!this.isStructureWithCircles(messagePart.getStructure(), new HashSet())) continue;
            return true;
        }
        return false;
    }

    private boolean isStructureWithCircles(IStructure structure, HashSet set) {
        IType type = null;
        switch (structure.getStructureCast()) {
            case 1: {
                type = ((IElement)structure).getType();
                if (type == null) break;
                return this.isStructureWithCircles((IStructure)type, set);
            }
            case 2: {
                type = (IType)structure;
                switch (type.getTypeCast()) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        IComplexType complexType = (IComplexType)structure;
                        if (set.contains(complexType)) {
                            return true;
                        }
                        set.add(complexType);
                        for (int i = 0; i < complexType.getElementCount(); ++i) {
                            if (!this.isStructureWithCircles((IStructure)complexType.getElement(i), set)) continue;
                            return true;
                        }
                        set.remove(complexType);
                    }
                }
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

