/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import java.util.Enumeration;

public class TraceMessageValue {
    public static String traceMessageValue(IMessageValue messageValue) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(messageValue.getMessage().getName());
        buffer.append(" message parts : ");
        for (int i = 0; i < messageValue.getMessagepartValueCount(); ++i) {
            IMessagepartValue messagePartValue = messageValue.getMessagepartValue(i);
            buffer.append("  ");
            buffer.append(messagePartValue.getMessagepart().getName());
            buffer.append(" :");
            if (messagePartValue.getStructureValue() == null) continue;
            TraceMessageValue.traceStructureValue(buffer, 1, messagePartValue.getStructureValue());
        }
        return buffer.toString();
    }

    private static void traceStructureValue(StringBuffer buffer, int depth, IStructureValue structureValue) {
        IStructure structure = structureValue.getStructure();
        switch (structure.getStructureCast()) {
            case 1: {
                IElementValue elementValue = (IElementValue)structureValue;
                TraceMessageValue.traceElementValue(buffer, depth + 1, elementValue);
                break;
            }
        }
    }

    private static void traceElementValue(StringBuffer buffer, int depth, IElementValue elementValue) {
        TraceMessageValue.writeDepth(buffer, depth);
        buffer.append("Element name: ");
        buffer.append(elementValue.getElement().getName());
        buffer.append(", Values : ");
        buffer.append(elementValue.getTypeValueCount() + "\n");
        Enumeration enumeration = elementValue.getTypeValueEnumeration();
        while (enumeration.hasMoreElements()) {
            ITypeValue value = (ITypeValue)enumeration.nextElement();
            TraceMessageValue.traceITypeValue(buffer, depth + 1, value);
        }
    }

    private static void traceITypeValue(StringBuffer buffer, int depth, ITypeValue value) {
        IType type = value.getType();
        switch (type.getTypeCast()) {
            case 2: {
                TraceMessageValue.traceSimpleTypeValue(buffer, depth + 1, (ISimpleTypeValue)value);
                break;
            }
            case 1: {
                TraceMessageValue.traceComplexTypeValue(buffer, depth + 1, (IComplexTypeValue)value);
            }
        }
    }

    private static void traceSimpleTypeValue(StringBuffer buffer, int depth, ISimpleTypeValue value) {
        TraceMessageValue.writeDepth(buffer, depth);
        buffer.append("Simple type " + (value.getValue() != null ? value.getValue() : "null") + "\n");
    }

    private static void traceComplexTypeValue(StringBuffer buffer, int depth, IComplexTypeValue value) {
        TraceMessageValue.writeDepth(buffer, depth);
        buffer.append("Complex type, element count: ");
        buffer.append(value.getComplexType().getElementCount() + "\n");
        for (int i = 0; i < value.getElementValueCount(); ++i) {
            IElementValue elementValue = value.getElementValue(i);
            TraceMessageValue.traceElementValue(buffer, depth + 1, elementValue);
        }
    }

    private static void writeDepth(StringBuffer buffer, int depth) {
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
    }
}

