/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.manager.wsdl11;

import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class TraceIStructures {
    private static Hashtable sTypes;

    public static String traceIStructuresFromHashtables(Hashtable elements, Hashtable types) {
        StringBuffer buffer = new StringBuffer();
        sTypes = types;
        buffer.append(TraceIStructures.traceIStructures(elements.values()));
        buffer.append(TraceIStructures.traceIStructures(types.values()));
        return buffer.toString();
    }

    public static String traceIStructures(Collection structures) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = structures.iterator();
        while (iter.hasNext()) {
            IStructure structure = (IStructure)iter.next();
            if (structure instanceof IElement) {
                TraceIStructures.traceIElement(structures, 0, buffer, (IElement)structure);
            }
            if (structure instanceof IComplexType) {
                TraceIStructures.traceIComplexType(structures, 0, buffer, (IComplexType)structure);
            }
            if (structure instanceof ISimpleType) {
                TraceIStructures.traceISimpleType(0, buffer, (ISimpleType)structure);
            }
            buffer.append("\n");
            TraceIStructures.insert(buffer, "-", 20);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static void traceIElement(Collection structures, int depth, StringBuffer buffer, IElement element) {
        TraceIStructures.insert(buffer, " ", depth * 2);
        buffer.append("IElement " + element.getName() + " - minOccurs : " + element.getMinOccurs() + ", maxOccurs : " + element.getMaxOccurs() + "\n");
        IType type = element.getType();
        if (type instanceof IComplexType) {
            TraceIStructures.traceIComplexType(structures, depth + 1, buffer, (IComplexType)type);
        }
        if (type instanceof ISimpleType) {
            TraceIStructures.traceISimpleType(depth + 1, buffer, (ISimpleType)type);
        }
    }

    private static void traceIComplexType(Collection structures, int depth, StringBuffer buffer, IComplexType complexType) {
        TraceIStructures.insert(buffer, " ", depth * 2);
        buffer.append("IComplexType ");
        switch (complexType.getMode()) {
            case 1: {
                buffer.append("MODE_ALL");
                break;
            }
            case 2: {
                buffer.append("MODE_CHOICE");
                break;
            }
            case 3: {
                buffer.append("MODE_SEQUENCE");
            }
        }
        buffer.append("\n");
        for (int i = 0; i < complexType.getElementCount(); ++i) {
            IElement element = complexType.getElement(i);
            if (!(element.getType() instanceof ISimpleType) && sTypes.containsValue(element.getType())) {
                TraceIStructures.insert(buffer, " ", (depth + 1) * 2);
                buffer.append(element.getName() + ", minOccurs : " + element.getMinOccurs() + ", maxOccurs : " + (element.getMaxOccurs() == 0 ? "unbounded" : Integer.toString(element.getMaxOccurs())) + "\n");
                continue;
            }
            TraceIStructures.traceIElement(structures, depth + 1, buffer, element);
        }
    }

    private static void traceISimpleType(int depth, StringBuffer buffer, ISimpleType simpleType) {
        TraceIStructures.insert(buffer, " ", depth * 2);
        buffer.append("Simple type - base: " + simpleType.getBase() + ", totalDigits:" + simpleType.getTotalDigits() + ", fractionDigits:" + simpleType.getFractionDigits() + ", maxLength:" + simpleType.getMaxLength());
        if (simpleType.getConstantCount() > 0) {
            buffer.append("\n  ");
            TraceIStructures.insert(buffer, " ", depth * 2);
            buffer.append("Constants: ");
        }
        Enumeration enumeration = simpleType.getConstantEnumeration();
        while (enumeration.hasMoreElements()) {
            buffer.append(((ISimpleTypeValue)enumeration.nextElement()).getValue() + ", ");
        }
        if (simpleType.getPatternCount() > 0) {
            buffer.append("\n  ");
            TraceIStructures.insert(buffer, " ", depth * 2);
            buffer.append("Patterns: ");
        }
        enumeration = simpleType.getPatternEnumeration();
        while (enumeration.hasMoreElements()) {
            buffer.append(enumeration.nextElement().toString() + ", ");
        }
        buffer.append("\n");
    }

    private static void insert(StringBuffer buffer, String str, int size) {
        for (int i = 0; i < size; ++i) {
            buffer.append(str);
        }
    }
}

