/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.endpoint.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDef;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDefConstants;
import com.sap.caf.mp.core.data.service.endpoint.types.PropertyParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefConstants;
import com.sap.caf.mp.core.data.service.registry.types.TitleListHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndpointTypeDef
implements IServiceProviderTypeDefConstants,
IEndpointTypeDefConstants,
IEndpointTypeDef {
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ATTRIBUTE_IMPLEMENTATION_CLASSNAME = "implementationClassName";
    private static final String ATTRIBUTE_CAN_CREATE = "canCreate";
    private static final String ATTRIBUTE_CAN_CHANGE = "canChange";
    private String m_name;
    private String m_implementationClassName;
    private TitleTextList m_titles;
    private Hashtable m_propParameterList;
    private Vector m_propParameters;
    private boolean m_canChange;
    private boolean m_canCreate;

    protected EndpointTypeDef(Element element, String fallbackLanguage, Locale locale) throws EngineException {
        String name = null;
        String implementationClassName = null;
        this.m_titles = null;
        this.m_propParameterList = new Hashtable();
        this.m_propParameters = new Vector();
        this.m_canChange = true;
        this.m_canCreate = true;
        NamedNodeMap attribs = element.getAttributes();
        int count = attribs.getLength();
        for (int i = 0; i < count; ++i) {
            Attr attrib = (Attr)attribs.item(i);
            if (attrib.getLocalName().equals(ATTRIBUTE_NAME_NAME)) {
                name = attrib.getValue();
                continue;
            }
            if (attrib.getLocalName().equals(ATTRIBUTE_IMPLEMENTATION_CLASSNAME)) {
                implementationClassName = attrib.getValue();
                continue;
            }
            if (attrib.getLocalName().equals(ATTRIBUTE_CAN_CHANGE)) {
                this.m_canChange = attrib.getValue().equals("true");
                continue;
            }
            if (!attrib.getLocalName().equals(ATTRIBUTE_CAN_CREATE)) continue;
            this.m_canCreate = attrib.getValue().equals("true");
        }
        if (name == null) {
            throw new EngineException("Input file invalid: name attribute missing on EndpointType element.");
        }
        if (implementationClassName == null) {
            throw new EngineException("Input file invalid: implementationClassName attribute missing on EndpointType element.");
        }
        this.m_name = name;
        this.m_implementationClassName = implementationClassName;
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null) continue;
            if (localName.equals("TitleList")) {
                this.m_titles = TitleListHelper.parseTitleTextList((Element)child, fallbackLanguage);
                continue;
            }
            if (!localName.equals("PropertyParameterList")) continue;
            NodeList childNodes = child.getChildNodes();
            int childCount = childNodes.getLength();
            for (int j = 0; j < childCount; ++j) {
                Node paramChild = childNodes.item(j);
                String childLocalName = paramChild.getLocalName();
                if (childLocalName == null || !childLocalName.equals("PropertyParameter")) continue;
                PropertyParameterDef propDef = new PropertyParameterDef((Element)paramChild, fallbackLanguage);
                this.m_propParameterList.put(propDef.getName(), propDef);
                this.m_propParameters.add(propDef);
            }
        }
        if (this.m_titles == null) {
            throw new EngineException("Input file invalid: TitleList child element missing on EndpointType element.");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public TitleTextList getTitleTextList() {
        return this.m_titles;
    }

    public Hashtable getPropertyParameterList() {
        return this.m_propParameterList;
    }

    public boolean canChange() {
        return this.m_canChange;
    }

    public boolean canCreate() {
        return this.m_canCreate;
    }

    public Enumeration getPropertyParameters() {
        return this.m_propParameters.elements();
    }
}

