/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.endpoint;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.ICoreContext;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.endpoint.Endpoint;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpoint;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.caf.mp.core.user.IUserContext;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Vector;

public class EndpointRegistryPersistenceImpl {
    private static final String m_stmtEndpointSelectAll = "SELECT * FROM CAF_RT_EPT";
    private static final String m_stmtEndpointSelect = "SELECT * FROM CAF_RT_EPT WHERE EPT_NAME=? AND EPT_TYPE_NAME=?";
    private static final String m_stmtEndpointInsert = "INSERT INTO CAF_RT_EPT(EPT_NAME,EPT_TYPE_NAME,CREATOR,CREATED,CHANGER,CHANGED) VALUES(?,?,?,?,?,?)";
    private static final String m_stmtEndpointUpdate = "UPDATE CAF_RT_EPT SET CHANGER=?, CHANGED=? WHERE EPT_NAME=?";
    private static final String m_stmtEndpointDelete = "DELETE FROM CAF_RT_EPT WHERE EPT_NAME=? AND EPT_TYPE_NAME=?";
    private static final String m_stmtEndpointSearch = "SELECT * FROM CAF_RT_EPT WHERE EPT_NAME LIKE ? AND EPT_TYPE_NAME LIKE ?";
    private static final String m_stmtUsedEndpointByService = "SELECT  SVC_ID FROM CAF_RT_SVCCFG WHERE PARAM_VALUE=?";
    private static final String m_stmtReadPortIdOfService = "SELECT PORT_TYPE_ID FROM CAF_RT_SVCDEF WHERE SVC_ID=? ";
    private static final String SLASH = "/";
    private ICNConnectionPool m_connectionPool;
    private IDataServiceFactory m_dataServiceFactory;
    private ICoreContext m_coreContext;

    protected EndpointRegistryPersistenceImpl(ICNConnectionPool connectionPool, IDataServiceFactory dataServiceFactory, ICoreContext coreContext) {
        this.m_connectionPool = connectionPool;
        this.m_dataServiceFactory = dataServiceFactory;
        this.m_coreContext = coreContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration getEndpoints(IUserContext ctxt) throws EngineException, InvocationException {
        Enumeration enumeration2;
        Connection conn = null;
        try {
            try {
                conn = this.m_connectionPool.getConnection();
                if (conn == null) {
                    throw new EngineException("Currently there are not any avaiable connection to the database.");
                }
                conn.setAutoCommit(false);
                Vector<Endpoint> result = new Vector<Endpoint>();
                PreparedStatement stmt = conn.prepareStatement(m_stmtEndpointSelectAll);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String eptName = rs.getString("EPT_NAME");
                    String eptTypeName = rs.getString("EPT_TYPE_NAME");
                    String creator = rs.getString("CREATOR");
                    long createdSeconds = rs.getLong("CREATED");
                    Date created = new Date(createdSeconds);
                    String changer = rs.getString("CHANGER");
                    long changedSeconds = rs.getLong("CHANGED");
                    Date changed = new Date(changedSeconds);
                    Endpoint endpoint = new Endpoint(eptName, eptTypeName, creator, created, changer, changed);
                    result.addElement(endpoint);
                }
                rs.close();
                stmt.close();
                Enumeration enumeration = result.elements();
                while (enumeration.hasMoreElements()) {
                    Endpoint endpoint = (Endpoint)enumeration.nextElement();
                    Properties props = (Properties)this.m_coreContext.getFromSecureStore(endpoint.getName() + SLASH + endpoint.getTypeName());
                    BaseLogManager.info(this.getClass(), (String)("retrieved props from secure store for " + endpoint.getName() + SLASH + endpoint.getTypeName()));
                    if (props == null) continue;
                    endpoint.addInternalProperties(props);
                    BaseLogManager.info(this.getClass(), (String)("added props from secure store to " + endpoint.getName() + SLASH + endpoint.getTypeName()));
                }
                conn.close();
                enumeration2 = result.elements();
                Object var18_16 = null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                PersistenceManagers.recoverAndClose(conn);
                throw throwable;
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            return enumeration2;
        }
        if (conn == null) return enumeration2;
        if (conn.isClosed()) return enumeration2;
        PersistenceManagers.recoverAndClose(conn);
        return enumeration2;
    }

    /*
     * Loose catch block
     */
    protected IEndpoint readEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            conn = null;
            conn = this.m_connectionPool.getConnection();
            if (conn == null) {
                throw new EngineException("Currently there are not any avaiable connection to the database.");
            }
            conn.setAutoCommit(false);
            BaseLogManager.info(this.getClass(), (String)("The given endpoint name while reading is: " + name));
            BaseLogManager.info(this.getClass(), (String)("The given endpoint type while reading is: " + typeName));
            stmt = conn.prepareStatement(m_stmtEndpointSelect);
            stmt.setString(1, name);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (rs.next()) break block14;
            IEndpoint iEndpoint = null;
            Object var21_10 = null;
            try {
                if (conn != null && !conn.isClosed()) {
                    PersistenceManagers.recoverAndClose(conn);
                }
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            }
            return iEndpoint;
        }
        String eptName = rs.getString("EPT_NAME");
        String eptTypeName = rs.getString("EPT_TYPE_NAME");
        String creator = rs.getString("CREATOR");
        long createdSeconds = rs.getLong("CREATED");
        Date created = new Date(createdSeconds);
        String changer = rs.getString("CHANGER");
        long changedSeconds = rs.getLong("CHANGED");
        Date changed = new Date(changedSeconds);
        Endpoint endpoint = new Endpoint(eptName, eptTypeName, creator, created, changer, changed);
        rs.close();
        stmt.close();
        Properties props = (Properties)this.m_coreContext.getFromSecureStore(endpoint.getName() + SLASH + endpoint.getTypeName());
        BaseLogManager.info(this.getClass(), (String)("retrieved props from secure store for " + endpoint.getName() + SLASH + endpoint.getTypeName()));
        if (props != null) {
            endpoint.addInternalProperties(props);
            BaseLogManager.info(this.getClass(), (String)("added props from secure store to " + endpoint.getName() + SLASH + endpoint.getTypeName()));
        }
        conn.close();
        Endpoint endpoint2 = endpoint;
        Object var21_11 = null;
        try {
            if (conn != null && !conn.isClosed()) {
                PersistenceManagers.recoverAndClose(conn);
            }
        }
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
        }
        return endpoint2;
        catch (Exception ex) {
            try {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
            catch (Throwable throwable) {
                Object var21_12 = null;
                try {
                    if (conn != null && !conn.isClosed()) {
                        PersistenceManagers.recoverAndClose(conn);
                    }
                }
                catch (Exception ex2) {
                    BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration searchEndpoints(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        Enumeration enumeration2;
        Connection conn = null;
        Vector<Endpoint> result = null;
        BaseLogManager.info(this.getClass(), (String)("The endpoint name for searching is: " + name));
        BaseLogManager.info(this.getClass(), (String)("The endpoint type name for searching is: " + typeName));
        try {
            try {
                conn = this.m_connectionPool.getConnection();
                if (conn == null) {
                    throw new EngineException("Currently there are not any avaiable connection to the database.");
                }
                conn.setAutoCommit(false);
                PreparedStatement stmt = conn.prepareStatement(m_stmtEndpointSearch);
                stmt.setString(1, name);
                stmt.setString(2, typeName);
                ResultSet rs = stmt.executeQuery();
                result = new Vector<Endpoint>();
                while (rs.next()) {
                    String eptName = rs.getString("EPT_NAME");
                    String eptTypeName = rs.getString("EPT_TYPE_NAME");
                    String creator = rs.getString("CREATOR");
                    long createdSeconds = rs.getLong("CREATED");
                    Date created = new Date(createdSeconds);
                    String changer = rs.getString("CHANGER");
                    long changedSeconds = rs.getLong("CHANGED");
                    Date changed = new Date(changedSeconds);
                    Endpoint endpoint = new Endpoint(eptName, eptTypeName, creator, created, changer, changed);
                    result.addElement(endpoint);
                    BaseLogManager.info(this.getClass(), (String)("Add the current endpoint: " + endpoint.getName() + endpoint.getTypeName()));
                }
                rs.close();
                stmt.close();
                Enumeration enumeration = result.elements();
                while (enumeration.hasMoreElements()) {
                    Endpoint endpoint = (Endpoint)enumeration.nextElement();
                    Properties props = (Properties)this.m_coreContext.getFromSecureStore(endpoint.getName() + SLASH + endpoint.getTypeName());
                    BaseLogManager.info(this.getClass(), (String)("retrieved props from secure store for " + endpoint.getName() + SLASH + endpoint.getTypeName()));
                    if (props == null) continue;
                    endpoint.addInternalProperties(props);
                    BaseLogManager.info(this.getClass(), (String)("added props from secure store to " + endpoint.getName() + SLASH + endpoint.getTypeName()));
                }
                conn.close();
                enumeration2 = result.elements();
                Object var20_18 = null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                PersistenceManagers.recoverAndClose(conn);
                throw throwable;
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            return enumeration2;
        }
        if (conn == null) return enumeration2;
        if (conn.isClosed()) return enumeration2;
        PersistenceManagers.recoverAndClose(conn);
        return enumeration2;
    }

    /*
     * Loose catch block
     */
    protected void deleteEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        block10: {
            Connection conn = null;
            conn = this.m_connectionPool.getConnection();
            if (conn == null) {
                throw new EngineException("Currently there are not any avaiable connection to the database.");
            }
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(m_stmtEndpointDelete);
            stmt.setString(1, name);
            stmt.setString(2, typeName);
            stmt.execute();
            stmt.close();
            this.m_coreContext.deleteFromSecureStore(name + SLASH + typeName);
            BaseLogManager.info(this.getClass(), (String)("deleted props from secure store for " + name + SLASH + typeName));
            conn.commit();
            conn.close();
            Object var7_7 = null;
            try {
                if (conn != null && !conn.isClosed()) {
                    PersistenceManagers.recoverAndClose(conn);
                }
                break block10;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex);
            }
            break block10;
            {
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    PersistenceManagers.recoverAndClose(conn);
                    throw new EngineException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (conn != null && !conn.isClosed()) {
                        PersistenceManagers.recoverAndClose(conn);
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void writeEndpoint(String name, String typeName, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        block20: {
            Connection conn = null;
            if (name != null) {
                if (name.length() > 32) {
                    throw new InvocationException("The length of the endpoint name can only be 32 characters");
                }
                if (name.equals(" ")) {
                    throw new InvocationException("Enter a valid endpoint name");
                }
                if (name.equals("")) {
                    throw new InvocationException("Enter a valid endpoint name");
                }
            }
            if (typeName != null) {
                if (typeName.length() > 64) {
                    throw new InvocationException("The length of the endpoint type name can only be 64 characters");
                }
                if (typeName.equals(" ")) {
                    throw new InvocationException("Enter a valid endpoint type name");
                }
                if (typeName.equals("")) {
                    throw new InvocationException("Enter a valid endpoint type name");
                }
            }
            conn = this.m_connectionPool.getConnection();
            if (conn == null) {
                throw new EngineException("Currently there are not any avaiable connection to the database.");
            }
            conn.setAutoCommit(false);
            long now = GregorianCalendar.getInstance().getTime().getTime();
            String uniqueId = ctxt.getUniqueId();
            PreparedStatement stmt = null;
            stmt = conn.prepareStatement(m_stmtEndpointUpdate);
            stmt.setString(1, uniqueId);
            stmt.setLong(2, now);
            stmt.setString(3, name);
            stmt.execute();
            stmt.close();
            this.m_coreContext.setToSecureStore(name + SLASH + typeName, (Serializable)props);
            BaseLogManager.info(this.getClass(), (String)("saved props to secure store for " + name + SLASH + typeName));
            conn.commit();
            conn.close();
            Object var11_10 = null;
            try {
                if (conn != null && !conn.isClosed()) {
                    PersistenceManagers.recoverAndClose(conn);
                }
                break block20;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex);
            }
            break block20;
            {
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    PersistenceManagers.recoverAndClose(conn);
                    try {
                        this.m_coreContext.deleteFromSecureStore(name + SLASH + typeName);
                    }
                    catch (Exception e) {
                        BaseLogManager.error(this.getClass(), (Exception)ex);
                    }
                    throw new EngineException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    if (conn != null && !conn.isClosed()) {
                        PersistenceManagers.recoverAndClose(conn);
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected boolean checkEndpointExists(String name, String typeName) throws EngineException, InvocationException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block13: {
            conn = null;
            conn = this.m_connectionPool.getConnection();
            if (conn == null) {
                throw new EngineException("Currently there are not any avaiable connection to the database.");
            }
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(m_stmtEndpointSelect);
            stmt.setString(1, name);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (!rs.next()) break block13;
            stmt.close();
            rs.close();
            boolean bl = true;
            Object var8_9 = null;
            try {
                if (conn != null && !conn.isClosed()) {
                    PersistenceManagers.recoverAndClose(conn);
                }
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            }
            return bl;
        }
        stmt.close();
        rs.close();
        boolean bl = false;
        Object var8_10 = null;
        try {
            if (conn != null && !conn.isClosed()) {
                PersistenceManagers.recoverAndClose(conn);
            }
        }
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
        }
        return bl;
        catch (Exception ex) {
            try {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (conn != null && !conn.isClosed()) {
                        PersistenceManagers.recoverAndClose(conn);
                    }
                }
                catch (Exception ex2) {
                    BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IEndpoint createEndpoint(String name, String typeName, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        Endpoint endpoint;
        Connection conn = null;
        if (name != null) {
            if (name.length() > 32) {
                throw new InvocationException("The length of the endpoint name can only be 32 characters");
            }
            if (name.equals(" ")) {
                throw new InvocationException("Enter a valid endpoint name");
            }
            if (name.equals("")) {
                throw new InvocationException("Enter a valid endpoint name");
            }
        }
        if (typeName != null) {
            if (typeName.length() > 64) {
                throw new InvocationException("The length of the endpoint type name can only be 64 characters");
            }
            if (typeName.equals(" ")) {
                throw new InvocationException("Enter a valid endpoint type name");
            }
            if (typeName.equals("")) {
                throw new InvocationException("Enter a valid endpoint type name");
            }
        }
        try {
            try {
                conn = this.m_connectionPool.getConnection();
                if (conn == null) {
                    throw new EngineException("Currently there are not any avaiable connection to the database.");
                }
                conn.setAutoCommit(false);
                long now = GregorianCalendar.getInstance().getTime().getTime();
                String uniqueId = ctxt.getUniqueId();
                PreparedStatement stmt = conn.prepareStatement(m_stmtEndpointInsert);
                stmt.setString(1, name);
                stmt.setString(2, typeName);
                stmt.setString(3, uniqueId);
                stmt.setLong(4, now);
                stmt.setString(5, uniqueId);
                stmt.setLong(6, now);
                stmt.execute();
                stmt.close();
                this.m_coreContext.setToSecureStore(name + SLASH + typeName, (Serializable)props);
                BaseLogManager.info(this.getClass(), (String)("saved props to secure store for " + name + SLASH + typeName));
                conn.commit();
                conn.close();
                Date nowDate = new Date(now);
                endpoint = new Endpoint(name, typeName, uniqueId, nowDate, uniqueId, nowDate, props);
                Object var13_12 = null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                try {
                    this.m_coreContext.deleteFromSecureStore(name + SLASH + typeName);
                    throw new EngineException(ex);
                }
                catch (Exception e) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                PersistenceManagers.recoverAndClose(conn);
                throw throwable;
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            return endpoint;
        }
        if (conn == null) return endpoint;
        if (conn.isClosed()) return endpoint;
        PersistenceManagers.recoverAndClose(conn);
        return endpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector checkEndpointUsedByService(String endpointName, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        Vector<String> vector;
        Connection conn = null;
        try {
            try {
                conn = this.m_connectionPool.getConnection();
                if (conn == null) {
                    throw new EngineException("Currently there are not any avaiable connection to the database.");
                }
                conn.setAutoCommit(false);
                Vector<String> portIds = new Vector<String>();
                Vector<String> svcIdNames = new Vector<String>();
                PreparedStatement stmt = conn.prepareStatement(m_stmtUsedEndpointByService);
                stmt.setString(1, endpointName);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String svcIdName = rs.getString("SVC_ID");
                    svcIdNames.addElement(svcIdName);
                }
                rs.close();
                stmt.close();
                Enumeration result = svcIdNames.elements();
                while (result.hasMoreElements()) {
                    String svcIdName = (String)result.nextElement();
                    stmt = conn.prepareStatement(m_stmtUsedEndpointByService);
                    stmt.setString(1, typeName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String svcIdType = rs.getString("SVC_ID");
                        if (!svcIdName.equals(svcIdType)) continue;
                        String portTypeId = this.readPortTypeOfService(svcIdName);
                        portIds.addElement(portTypeId);
                    }
                }
                rs.close();
                stmt.close();
                vector = portIds;
                Object var14_14 = null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                PersistenceManagers.recoverAndClose(conn);
                throw throwable;
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            return vector;
        }
        if (conn == null) return vector;
        if (conn.isClosed()) return vector;
        PersistenceManagers.recoverAndClose(conn);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPortTypeOfService(String svcId) throws EngineException, InvocationException {
        String string;
        Connection conn = null;
        try {
            try {
                conn = this.m_connectionPool.getConnection();
                if (conn == null) {
                    throw new EngineException("Currently there are not any avaiable connection to the database.");
                }
                conn.setAutoCommit(false);
                PreparedStatement stmt = conn.prepareStatement(m_stmtReadPortIdOfService);
                stmt.setString(1, svcId);
                ResultSet rs = stmt.executeQuery();
                stmt.close();
                String porttypeId = rs.getString("PORT_TYPE_ID");
                rs.close();
                stmt.close();
                string = porttypeId;
                Object var8_8 = null;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                PersistenceManagers.recoverAndClose(conn);
                throw new EngineException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                PersistenceManagers.recoverAndClose(conn);
                throw throwable;
            }
            catch (Exception ex2) {
                BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            BaseLogManager.error(this.getClass(), (String)"Error while closing connection", (Exception)ex2);
            return string;
        }
        if (conn == null) return string;
        if (conn.isClosed()) return string;
        PersistenceManagers.recoverAndClose(conn);
        return string;
    }

    protected void lockEndpoint(IUserContext ctxt) {
    }

    protected boolean isEndpointLocked() {
        return false;
    }

    protected void unlock() {
    }
}

