/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.endpoint;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.endpoint.EndpointRegistryPersistenceImpl;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpoint;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpointRegistry;
import com.sap.caf.mp.core.data.service.endpoint.types.EndpointTypeDefs;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDefs;
import com.sap.caf.mp.core.data.types.meta.api.ITypeLayout;
import com.sap.caf.mp.core.user.IUserContext;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class EndpointRegistry
implements IEndpointRegistry {
    private EndpointTypeDefs m_typeDefs;
    private ICNConnectionPool m_connectionPool;
    private EndpointRegistryPersistenceImpl m_persistence;
    private IDataServiceFactory m_dataServiceFactory;
    private IServiceDescriptionPersistence m_serviceDescPersistence;

    public EndpointRegistry(ICoreFactory coreFactory, InputStream endpointTypeDefs, ICNConnectionPool connectionPool, IDataServiceFactory dataServiceFactory, String fallbackLanguage, Locale locale, IServiceDescriptionPersistence serviceDescPersistence) throws EngineException {
        if (endpointTypeDefs != null) {
            this.m_typeDefs = new EndpointTypeDefs(coreFactory, endpointTypeDefs, fallbackLanguage, locale);
        }
        this.m_persistence = new EndpointRegistryPersistenceImpl(connectionPool, dataServiceFactory, coreFactory.getCoreContext());
        this.m_serviceDescPersistence = serviceDescPersistence;
    }

    public Enumeration getEndpoints(IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_persistence.getEndpoints(ctxt);
    }

    public IEndpoint readEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_persistence.readEndpoint(name, typeName, ctxt);
    }

    public void deleteEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        Vector result = this.m_persistence.checkEndpointUsedByService(name, typeName, ctxt);
        if (!result.isEmpty()) {
            try {
                StringBuffer portNames = new StringBuffer();
                for (int i = 0; i < result.size(); ++i) {
                    String portId = (String)result.elementAt(i);
                    ITypeLayout portLayout = this.m_serviceDescPersistence.readPorttypeLayout(portId, 0);
                    portNames.append(portLayout.getName());
                    if (result.size() <= 1 && i != result.size() - 2) continue;
                    portNames.append(" ,");
                }
                throw new InvocationException(MessageFormat.format("The endpoint is used by the following service(s): {0}. Please remove the relatonship(s) before deleting", portNames.toString()));
            }
            catch (Exception ex) {
                throw new InvocationException("The endpoint is used by at least one services. Please remove the relatonship before deleting", ex);
            }
        }
        this.m_persistence.deleteEndpoint(name, typeName, ctxt);
    }

    public void writeEndpoint(String name, String typename, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        this.m_persistence.writeEndpoint(name, typename, props, ctxt);
    }

    public boolean checkEndpointExists(String name, String typeName) throws EngineException, InvocationException {
        return this.m_persistence.checkEndpointExists(name, typeName);
    }

    public IEndpoint createEndpoint(String name, String typeName, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        if (this.checkEndpointExists(name, typeName)) {
            throw new InvocationException(MessageFormat.format("The endpoint {0} already exists", name));
        }
        return this.m_persistence.createEndpoint(name, typeName, props, ctxt);
    }

    public IEndpointTypeDefs getEndpointTypeDefs() {
        return this.m_typeDefs;
    }

    public Enumeration searchEndpoints(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_persistence.searchEndpoints(name, typeName, ctxt);
    }
}

