/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.mapping.api.ISimpleMappingService;
import com.sap.caf.mp.core.data.mmr.IDataServiceFactoryInit;
import com.sap.caf.mp.core.data.mmr.MMRAdapterNotInstalledException;
import com.sap.caf.mp.core.data.mmr.MMServiceRetrievalAdapterLoader;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpoint;
import com.sap.caf.mp.core.data.service.endpoint.api.IEndpointRegistry;
import com.sap.caf.mp.core.data.service.endpoint.types.IEndpointTypeDefs;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinitionInfo;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinitionInfo;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDefs;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.meta.api.ITypeFactory;
import com.sap.caf.mp.core.data.types.meta.api.ITypeLayout;
import com.sap.caf.mp.core.data.types.meta.base.TypeFactory;
import com.sap.caf.mp.core.user.IUserContext;
import com.sap.engine.frame.ApplicationServiceContext;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DataServiceBridge
implements IServicesRegistry,
IEndpointRegistry,
IServiceDescriptionPersistence,
IMappingService,
IDataServiceFactoryInit {
    private IServicesRegistry m_servicesRegistry;
    private IEndpointRegistry m_endpointRegistry;
    private IServiceDescriptionPersistence m_descriptionPersistence;
    private IMappingService m_mappingService;
    private IDataServiceFactory m_dataServiceFactory;
    private ITypeFactory m_typeFactory;
    private MMServiceRetrievalAdapterLoader m_loader;

    public DataServiceBridge(IServicesRegistry servicesRegistry, IServiceDescriptionPersistence persistence, IMappingService mappingService, ApplicationServiceContext serviceContext, IEndpointRegistry endpointRegitry) throws EngineException {
        this.m_servicesRegistry = servicesRegistry;
        this.m_endpointRegistry = endpointRegitry;
        this.m_descriptionPersistence = persistence;
        this.m_mappingService = mappingService;
        this.m_typeFactory = new TypeFactory();
        this.m_loader = new MMServiceRetrievalAdapterLoader(serviceContext);
    }

    public IServiceProviderTypeDefs getServiceProviderTypeDefs() {
        return this.m_servicesRegistry.getServiceProviderTypeDefs();
    }

    public Enumeration getServiceDefinitionInfos() throws EngineException {
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        Vector<IServiceDefinitionInfo> completeList = new Vector<IServiceDefinitionInfo>();
        Enumeration infos = this.m_servicesRegistry.getServiceDefinitionInfos();
        while (infos.hasMoreElements()) {
            IServiceDefinitionInfo info = (IServiceDefinitionInfo)infos.nextElement();
            completeList.add(info);
            lookup.put(info.getId(), info.getId());
        }
        try {
            ISimpleServicesRegistry registry = this.m_loader.loadSimpleServicesRegistry();
            infos = registry.getServiceDefinitionIds();
            while (infos.hasMoreElements()) {
                String id = (String)infos.nextElement();
                if (lookup.containsKey(id)) continue;
                IServiceDefinition def = registry.readServiceDefinition(id);
                ServiceDefinitionInfo newinfo = new ServiceDefinitionInfo(def.getId(), def.getPortTypeId(), def.getPortType().getName());
                completeList.add(newinfo);
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
        }
        return completeList.elements();
    }

    public Enumeration getServiceDefinitionInfos(String typeName) throws EngineException {
        Vector<IServiceDefinitionInfo> completeList = new Vector<IServiceDefinitionInfo>();
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        Enumeration infos = this.m_servicesRegistry.getServiceDefinitionInfos(typeName);
        while (infos.hasMoreElements()) {
            IServiceDefinitionInfo info = (IServiceDefinitionInfo)infos.nextElement();
            completeList.add(info);
            lookup.put(info.getId(), info.getId());
        }
        try {
            ISimpleServicesRegistry registry = this.m_loader.loadSimpleServicesRegistry();
            infos = registry.getServiceDefinitionIds();
            while (infos.hasMoreElements()) {
                IServiceDefinition def;
                String id = (String)infos.nextElement();
                if (lookup.containsKey(id) || !(def = registry.readServiceDefinition(id)).getTypeName().equals(typeName)) continue;
                ServiceDefinitionInfo newinfo = new ServiceDefinitionInfo(def.getId(), def.getPortTypeId(), def.getPortType().getName());
                completeList.add(newinfo);
            }
        }
        catch (Exception ex) {
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
        }
        return completeList.elements();
    }

    public void writeServiceDefinition(IServiceDefinition definition, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_servicesRegistry.writeServiceDefinition(definition, ctxt);
    }

    public IServiceDefinition readServiceDefinition(String id) throws InvocationException, EngineException {
        IServiceDefinition def;
        try {
            def = this.m_servicesRegistry.readServiceDefinition(id);
        }
        catch (InvocationException ex) {
            def = null;
        }
        if (def != null) {
            return def;
        }
        try {
            def = this.m_loader.loadSimpleServicesRegistry().readServiceDefinition(id);
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            def = null;
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            def = null;
        }
        if (def != null) {
            return def;
        }
        throw new InvocationException(MessageFormat.format("Unable to find service with id {0}", id));
    }

    public void deleteServiceDefinition(String id, IUserContext ctxt) throws InvocationException, EngineException {
        if (this.checkServiceDefinitionExists(id)) {
            this.m_servicesRegistry.deleteServiceDefinition(id, ctxt);
        }
    }

    public Vector importServiceDefinitions(String serviceTypeName, Properties properties) throws InvocationException, EngineException {
        return this.m_servicesRegistry.importServiceDefinitions(serviceTypeName, properties);
    }

    public void deleteMessage(String uuid) throws InvocationException, EngineException {
        if (this.checkMessageExists(uuid)) {
            this.m_descriptionPersistence.deleteMessage(uuid);
        }
    }

    public void deletePorttype(String uuid) throws InvocationException, EngineException {
        if (this.checkPorttypeExists(uuid)) {
            this.m_descriptionPersistence.deletePorttype(uuid);
        }
    }

    public IMessage readMessage(String uuid) throws InvocationException, EngineException {
        IMessage message;
        try {
            message = this.m_descriptionPersistence.readMessage(uuid);
        }
        catch (InvocationException ex) {
            message = null;
        }
        if (message != null) {
            return message;
        }
        try {
            message = this.m_loader.loadSimpleServiceDescriptionPersistence().readMessage(uuid);
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            message = null;
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            message = null;
        }
        if (message != null) {
            return message;
        }
        throw new InvocationException(MessageFormat.format("Unable to find message with id {0}", uuid));
    }

    public ITypeLayout readMessageLayout(String uuid, int depth) throws InvocationException, EngineException {
        try {
            ITypeLayout result = this.m_descriptionPersistence.readMessageLayout(uuid, depth);
            if (result != null) {
                return result;
            }
        }
        catch (InvocationException ex) {
            // empty catch block
        }
        try {
            IMessage message = this.m_loader.loadSimpleServiceDescriptionPersistence().readMessage(uuid);
            if (message != null) {
                return this.m_typeFactory.extractTypeLayout(message);
            }
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
        }
        throw new InvocationException(MessageFormat.format("Unable to find message with id {0}", uuid));
    }

    public IPorttype readPorttype(String uuid) throws InvocationException, EngineException {
        IPorttype porttype;
        try {
            porttype = this.m_descriptionPersistence.readPorttype(uuid);
        }
        catch (InvocationException ex) {
            porttype = null;
        }
        if (porttype != null) {
            return porttype;
        }
        try {
            porttype = this.m_loader.loadSimpleServiceDescriptionPersistence().readPorttype(uuid);
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            porttype = null;
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            porttype = null;
        }
        if (porttype != null) {
            return porttype;
        }
        throw new InvocationException(MessageFormat.format("Unable to find port type with id {0}", uuid));
    }

    public ITypeLayout readPorttypeLayout(String uuid, int depth) throws InvocationException, EngineException {
        try {
            ITypeLayout result = this.m_descriptionPersistence.readPorttypeLayout(uuid, depth);
            if (result != null) {
                return result;
            }
        }
        catch (InvocationException ex) {
            // empty catch block
        }
        try {
            IPorttype porttype = this.m_loader.loadSimpleServiceDescriptionPersistence().readPorttype(uuid);
            if (porttype != null) {
                return this.m_typeFactory.extractTypeLayout(porttype);
            }
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
        }
        throw new InvocationException(MessageFormat.format("Unable to find port type with id {0}", uuid));
    }

    public void writeMessage(IMessage message) throws InvocationException, EngineException {
        this.m_descriptionPersistence.writeMessage(message);
    }

    public void writePorttype(IPorttype porttype) throws InvocationException, EngineException {
        this.m_descriptionPersistence.writePorttype(porttype);
    }

    public IMappingRule getMappingRule(String ruleId) throws InvocationException, EngineException {
        IMappingRule mappingrule;
        try {
            mappingrule = this.m_mappingService.getMappingRule(ruleId);
        }
        catch (InvocationException ex) {
            mappingrule = null;
        }
        if (mappingrule != null) {
            return mappingrule;
        }
        try {
            mappingrule = this.m_loader.loadSimpleMappingService().readMappingRule(ruleId);
        }
        catch (MMRAdapterNotInstalledException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            mappingrule = null;
        }
        catch (EngineException ex) {
            BaseLogManager.warn(this.getClass(), (String)("Error accessing mmr: " + ex.getMessage()));
            mappingrule = null;
        }
        if (mappingrule != null) {
            return mappingrule;
        }
        throw new InvocationException(MessageFormat.format("Unable to find mapping rule with id {0}", ruleId));
    }

    public Vector getMappingRuleIds(String sourceMessageId, String targetMessageId) throws InvocationException, EngineException {
        String id;
        ISimpleMappingService svc;
        try {
            svc = this.m_loader.loadSimpleMappingService();
        }
        catch (Exception ex) {
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
            svc = null;
        }
        Vector<String> result = new Vector<String>();
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        result.addAll(this.m_mappingService.getMappingRuleIds(sourceMessageId, targetMessageId));
        Enumeration enumeration = result.elements();
        while (enumeration.hasMoreElements()) {
            id = (String)enumeration.nextElement();
            lookup.put(id, id);
        }
        if (svc == null) {
            return result;
        }
        enumeration = svc.readMappingRuleIds();
        while (enumeration.hasMoreElements()) {
            IMappingRule rule;
            id = (String)enumeration.nextElement();
            if (lookup.containsKey(id) || !(rule = svc.readMappingRule(id)).getSourceMessageId().equals(sourceMessageId) || !rule.getTargetMessageId().equals(targetMessageId)) continue;
            result.add(id);
        }
        return result;
    }

    public IMappingRule createMappingRule(String sourceMessageId, String targetMessageId, Vector mappingRuleEntries, IUserContext ctxt) throws InvocationException, EngineException {
        return this.m_mappingService.createMappingRule(sourceMessageId, targetMessageId, mappingRuleEntries, ctxt);
    }

    public IMappingRule changeMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        if (!this.checkMappingRuleExists(mappingRule.getRuleId())) {
            this.m_mappingService.addMappingRule(mappingRule, ctxt);
            return mappingRule;
        }
        return this.m_mappingService.changeMappingRule(mappingRule, ctxt);
    }

    public IMappingRule addMappingRule(String ruleId, String sourceMessageId, String targetMessageId, Vector mappingRuleEntries, IUserContext ctxt) throws InvocationException, EngineException {
        return this.m_mappingService.addMappingRule(ruleId, sourceMessageId, targetMessageId, mappingRuleEntries, ctxt);
    }

    public void addMappingRule(IMappingRule mappingRule, IUserContext ctxt) throws InvocationException, EngineException {
        this.m_mappingService.addMappingRule(mappingRule, ctxt);
    }

    public void deleteMappingRule(String ruleId, IUserContext ctxt) throws InvocationException, EngineException {
        if (this.checkMappingRuleExists(ruleId)) {
            this.m_mappingService.deleteMappingRule(ruleId, ctxt);
        }
    }

    public Vector getMappingRuleIds() throws EngineException {
        String id;
        Vector<String> result = new Vector<String>();
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        result.addAll(this.m_mappingService.getMappingRuleIds());
        Enumeration enumeration = result.elements();
        while (enumeration.hasMoreElements()) {
            id = (String)enumeration.nextElement();
            lookup.put(id, id);
        }
        try {
            enumeration = this.m_loader.loadSimpleMappingService().readMappingRuleIds();
            while (enumeration.hasMoreElements()) {
                id = (String)enumeration.nextElement();
                if (lookup.containsKey(id)) continue;
                result.add(id);
            }
        }
        catch (Exception ex) {
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
        }
        return result;
    }

    public Vector getMappingRuleIdsByTarget(String messageId) throws EngineException {
        String id;
        ISimpleMappingService svc;
        try {
            svc = this.m_loader.loadSimpleMappingService();
        }
        catch (Exception ex) {
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
            svc = null;
        }
        Vector<String> result = new Vector<String>();
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        result.addAll(this.m_mappingService.getMappingRuleIdsByTarget(messageId));
        Enumeration enumeration = result.elements();
        while (enumeration.hasMoreElements()) {
            id = (String)enumeration.nextElement();
            lookup.put(id, id);
        }
        if (svc == null) {
            return result;
        }
        enumeration = svc.readMappingRuleIds();
        while (enumeration.hasMoreElements()) {
            IMappingRule rule;
            id = (String)enumeration.nextElement();
            if (lookup.containsKey(id)) continue;
            try {
                rule = svc.readMappingRule(id);
            }
            catch (InvocationException e) {
                throw new EngineException((Exception)((Object)e));
            }
            if (!rule.getTargetMessageId().equals(messageId)) continue;
            result.add(id);
        }
        return result;
    }

    public Vector getMappingRuleIdsBySource(String messageId) throws EngineException {
        String id;
        ISimpleMappingService svc;
        try {
            svc = this.m_loader.loadSimpleMappingService();
        }
        catch (Exception ex) {
            BaseLogManager.warn(this.getClass(), (String)"Unable to access mmr services.");
            svc = null;
        }
        Vector<String> result = new Vector<String>();
        Hashtable<String, String> lookup = new Hashtable<String, String>();
        result.addAll(this.m_mappingService.getMappingRuleIdsBySource(messageId));
        Enumeration enumeration = result.elements();
        while (enumeration.hasMoreElements()) {
            id = (String)enumeration.nextElement();
            lookup.put(id, id);
        }
        if (svc == null) {
            return result;
        }
        enumeration = svc.readMappingRuleIds();
        while (enumeration.hasMoreElements()) {
            IMappingRule rule;
            id = (String)enumeration.nextElement();
            if (lookup.containsKey(id)) continue;
            try {
                rule = svc.readMappingRule(id);
            }
            catch (InvocationException e) {
                throw new EngineException((Exception)((Object)e));
            }
            if (!rule.getSourceMessageId().equals(messageId)) continue;
            result.add(id);
        }
        return result;
    }

    public boolean checkPorttypeExists(String id) throws EngineException {
        IPorttype pt;
        try {
            pt = this.m_descriptionPersistence.readPorttype(id);
        }
        catch (InvocationException ex) {
            pt = null;
        }
        return pt != null;
    }

    public boolean checkMessageExists(String id) throws EngineException {
        IMessage msg;
        try {
            msg = this.m_descriptionPersistence.readMessage(id);
        }
        catch (InvocationException ex) {
            msg = null;
        }
        return msg != null;
    }

    public boolean checkServiceDefinitionExists(String id) throws EngineException {
        IServiceDefinition def;
        try {
            def = this.m_servicesRegistry.readServiceDefinition(id);
        }
        catch (InvocationException ex) {
            def = null;
        }
        return def != null;
    }

    public boolean checkMappingRuleExists(String id) throws EngineException {
        IMappingRule def;
        try {
            def = this.m_mappingService.getMappingRule(id);
        }
        catch (InvocationException ex) {
            def = null;
        }
        return def != null;
    }

    public IDataServiceFactory getDataServiceFactory() {
        return this.m_dataServiceFactory;
    }

    public void setDataServiceFactory(IDataServiceFactory aFactory) {
        this.m_dataServiceFactory = aFactory;
    }

    public Enumeration getEndpoints(IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_endpointRegistry.getEndpoints(ctxt);
    }

    public IEndpoint readEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_endpointRegistry.readEndpoint(name, typeName, ctxt);
    }

    public void deleteEndpoint(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        this.m_endpointRegistry.deleteEndpoint(name, typeName, ctxt);
    }

    public void writeEndpoint(String name, String typename, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        this.m_endpointRegistry.writeEndpoint(name, typename, props, ctxt);
    }

    public IEndpoint createEndpoint(String name, String typeName, Properties props, IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_endpointRegistry.createEndpoint(name, typeName, props, ctxt);
    }

    public IEndpointTypeDefs getEndpointTypeDefs() {
        return this.m_endpointRegistry.getEndpointTypeDefs();
    }

    public Enumeration searchEndpoints(String name, String typeName, IUserContext ctxt) throws EngineException, InvocationException {
        return this.m_endpointRegistry.searchEndpoints(name, typeName, ctxt);
    }
}

