/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.persistence;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.meta.api.ITypeLayout;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimpleServiceDescriptionPersistence
implements IServiceDescriptionPersistence {
    private Hashtable m_portTypes;
    private Hashtable m_types;
    private ICoreFactory m_coreFactory;

    public SimpleServiceDescriptionPersistence(ICoreFactory coreFactory) throws InvocationException {
        this.m_coreFactory = coreFactory;
        this.m_portTypes = new Hashtable();
        this.m_types = new Hashtable();
    }

    public IPorttype readPorttype(String id) throws InvocationException, EngineException {
        IPorttype type = (IPorttype)this.m_portTypes.get(id);
        if (type == null) {
            throw new InvocationException("Port type not found.");
        }
        return type;
    }

    public void writePorttype(IPorttype portType) throws InvocationException, EngineException {
        this.m_portTypes.put(portType.getUuid(), portType);
        Enumeration enumeration = portType.getOperationEnumeration();
        while (enumeration.hasMoreElements()) {
            IOperation oper = (IOperation)enumeration.nextElement();
            Enumeration partEnum = oper.getFaultOperationpartEnumeration();
            while (partEnum.hasMoreElements()) {
                IOperationpart part = (IOperationpart)partEnum.nextElement();
                IMessage msg = part.getMessage();
                this.m_types.put(msg.getUuid(), msg);
            }
        }
    }

    public void deletePorttype(String id) throws InvocationException, EngineException {
        if (!this.m_portTypes.containsKey(id)) {
            throw new InvocationException("Port type not found.");
        }
        this.m_portTypes.remove(id);
    }

    public IMessage readMessage(String id) throws InvocationException, EngineException {
        IMessage msg = (IMessage)this.m_types.get(id);
        if (msg == null) {
            throw new InvocationException("Message not found.");
        }
        return msg;
    }

    public void deleteMessage(String id) throws InvocationException, EngineException {
        this.m_types.remove(id);
    }

    public void writeMessage(IMessage message) throws InvocationException, EngineException {
        this.m_types.put(message.getUuid(), message);
    }

    public ITypeLayout readMessageLayout(String uuid, int depth) throws InvocationException, EngineException {
        return null;
    }

    public ITypeLayout readPorttypeLayout(String uuid, int depth) throws InvocationException, EngineException {
        return null;
    }
}

