/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.mmr;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.mapping.api.ISimpleMappingService;
import com.sap.caf.mp.core.data.mmr.IDataServiceFactoryInit;
import com.sap.caf.mp.core.data.mmr.MMRAdapterNotInstalledException;
import com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry;
import com.sap.engine.frame.ApplicationServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MMServiceRetrievalAdapterLoader {
    private ApplicationServiceContext m_appContext;
    private Object m_remoteImpl;
    private InitialContext m_initialCtx;

    public MMServiceRetrievalAdapterLoader(ApplicationServiceContext appContext) throws EngineException {
        this.m_appContext = appContext;
        try {
            this.m_initialCtx = new InitialContext();
        }
        catch (NamingException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            BaseLogManager.info(this.getClass(), (String)"Naming exception while trying to instantiate Initital Context.");
            throw new EngineException("Class loading error: Naming exception while trying to instantiate Initital Context.", (Exception)ex);
        }
    }

    private Object lookupAdapter() throws MMRAdapterNotInstalledException, EngineException {
        try {
            Object bean = this.m_initialCtx.lookup("localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            Method createMethod = bean.getClass().getDeclaredMethod("create", null);
            this.m_remoteImpl = createMethod.invoke(bean, null);
        }
        catch (NamingException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (this.m_remoteImpl != null) {
                BaseLogManager.info(this.getClass(), (String)("Naming exception while making lookup for class " + this.m_remoteImpl.toString()));
            } else {
                BaseLogManager.info(this.getClass(), (String)"Naming exception while making lookup for class localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            }
            throw new MMRAdapterNotInstalledException();
        }
        catch (InvocationTargetException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (this.m_remoteImpl != null) {
                BaseLogManager.info(this.getClass(), (String)("Invocation exception while making lookup for class " + this.m_remoteImpl.toString()));
            } else {
                BaseLogManager.info(this.getClass(), (String)"Invocation exception while making lookup for class localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            }
            throw new EngineException("Class loading error: Invocation exception while making lookup for class " + this.m_remoteImpl.getClass(), (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (this.m_remoteImpl != null) {
                BaseLogManager.info(this.getClass(), (String)("Illegal access exception while making lookup for class " + this.m_remoteImpl.toString()));
            } else {
                BaseLogManager.info(this.getClass(), (String)"Illegal access exception while making lookup for class localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            }
            throw new EngineException("Class loading error: Illegal access exception while making lookup for class " + this.m_remoteImpl.getClass(), (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (this.m_remoteImpl != null) {
                BaseLogManager.info(this.getClass(), (String)("No such method exception while making lookup for class " + this.m_remoteImpl.toString()));
            } else {
                BaseLogManager.info(this.getClass(), (String)"No such method exception while making lookup for class localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            }
            throw new EngineException("Class loading error: No such method  exception while making lookup for class " + this.m_remoteImpl.getClass(), (Exception)ex);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (this.m_remoteImpl != null) {
                BaseLogManager.info(this.getClass(), (String)("Unknow exception while making lookup for class " + this.m_remoteImpl.toString()));
            } else {
                BaseLogManager.info(this.getClass(), (String)"Unknown exception while making lookup for class localejbs/sap.com/caf~mp~mmr~adapter~ear/MMServiceRetrievalAdapterCallerBean");
            }
            throw new EngineException(ex);
        }
        return this.m_remoteImpl;
    }

    private Object loadAdapterImplementation() throws MMRAdapterNotInstalledException, EngineException {
        if (this.m_remoteImpl == null) {
            this.m_remoteImpl = this.lookupAdapter();
        } else {
            try {
                this.m_remoteImpl.toString();
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
                this.m_remoteImpl = this.lookupAdapter();
            }
        }
        return this.m_remoteImpl;
    }

    public ISimpleServicesRegistry loadSimpleServicesRegistry() throws MMRAdapterNotInstalledException, EngineException {
        ISimpleServicesRegistry registry = (ISimpleServicesRegistry)this.loadAdapterImplementation();
        return registry;
    }

    public ISimpleServiceDescriptionPersistence loadSimpleServiceDescriptionPersistence() throws MMRAdapterNotInstalledException, EngineException {
        ISimpleServiceDescriptionPersistence persistence = (ISimpleServiceDescriptionPersistence)this.loadAdapterImplementation();
        return persistence;
    }

    public ISimpleMappingService loadSimpleMappingService() throws MMRAdapterNotInstalledException, EngineException {
        ISimpleMappingService mappingService = (ISimpleMappingService)this.loadAdapterImplementation();
        return mappingService;
    }

    public IDataServiceFactoryInit initDataServiceFactory() throws MMRAdapterNotInstalledException, EngineException {
        IDataServiceFactoryInit service = (IDataServiceFactoryInit)this.loadAdapterImplementation();
        return service;
    }
}

