/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.SourceDOMParser;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.schema.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ConvertSchemaToHTML
extends Task {
    private SourceDOMParser parser = new SourceDOMParser();
    private SchemaTransformer transformer = new SchemaTransformer();
    private String manifest;
    private String destination;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.validateDestination()) {
            return;
        }
        IPluginModelBase model = this.readManifestFile();
        if (model == null) {
            return;
        }
        IPluginExtensionPoint[] extPoints = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            String schemaLocation = extPoints[i].getSchema();
            FileInputStream is = null;
            PrintWriter out = null;
            if (schemaLocation != null && !schemaLocation.equals("")) {
                Object var12_13;
                block22: {
                    block21: {
                        try {
                            try {
                                File directory;
                                File schemaFile = new File(String.valueOf(model.getInstallLocation()) + '/' + schemaLocation);
                                is = new FileInputStream(schemaFile);
                                this.parser.parse(new InputSource(is));
                                URL url = null;
                                try {
                                    url = new URL("file:" + schemaFile.getAbsolutePath());
                                }
                                catch (MalformedURLException malformedURLException) {}
                                Schema schema = new Schema(null, url);
                                schema.traverseDocumentTree((Node)this.parser.getDocument().getDocumentElement(), this.parser.getLineTable());
                                File file = directory = new Path(this.destination).isAbsolute() ? new File(this.destination) : new File(this.getProject().getBaseDir(), this.destination);
                                if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                                    var12_13 = null;
                                    break block21;
                                }
                                File file2 = new File(directory, String.valueOf(extPoints[i].getFullId().replace('.', '_')) + ".html");
                                out = new PrintWriter((Writer)new FileWriter(file2), true);
                                this.transformer.transform(out, (ISchema)schema);
                            }
                            catch (Exception e) {
                                if (e.getMessage() != null) {
                                    System.out.println(e.getMessage());
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            var12_13 = null;
                            try {
                                if (out != null) {
                                    out.close();
                                }
                                if (is == null) throw throwable;
                                is.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    if (out != null) {
                        out.close();
                    }
                    if (is == null) return;
                    is.close();
                    return;
                }
                var12_13 = null;
                try {}
                catch (IOException iOException) {}
                if (out != null) {
                    out.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            ++i;
        }
        return;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    private IPluginModelBase readManifestFile() {
        ExternalFragmentModel model;
        block12: {
            if (this.manifest == null) {
                System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.missingAttribute", (String)"manifest"));
                return null;
            }
            File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                }
                return null;
            }
            model = null;
            try {
                try {
                    if (file.getName().toLowerCase().equals("fragment.xml")) {
                        model = new ExternalFragmentModel();
                    } else {
                        if (!file.getName().toLowerCase().equals("plugin.xml")) {
                            System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.illegalValue", (String)"manifest"));
                            break block12;
                        }
                        model = new ExternalPluginModel();
                    }
                    String parentPath = file.getParentFile().getAbsolutePath();
                    model.setInstallLocation(parentPath);
                    model.load((InputStream)stream, false);
                    ((InputStream)stream).close();
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        System.out.println(e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return model;
    }

    private boolean validateDestination() {
        boolean valid = true;
        if (this.destination == null) {
            System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.missingAttribute", (String)"destination"));
            valid = false;
        } else if (!new Path(this.destination).isValidPath(this.destination)) {
            System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.illegalValue", (String)"destination"));
            valid = false;
        }
        return valid;
    }
}

