/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrISubRecordCert;
import com.sap.jdsr.writer.DsrSubRecordCert;

public class DsrPassport
extends DsrSubRecordCert
implements DsrIPassport {
    private String transId = null;
    public static final byte[] eyeCatcher = new byte[]{42, 84, 72, 42};
    public static final int eyeCatcher1Len = 4;
    public static final int versionLen = 1;
    public static final int lenLen = 2;
    public static final int traceFlagLen = 2;
    public static final int systemIdLen = 32;
    public static final int serviceLen = 2;
    public static final int userIdLen = 32;
    public static final int actionLen = 40;
    public static final int actionTypeLen = 2;
    public static final int prevSystemIdLen = 32;
    public static final int guidLen = 32;
    public static final int unusedLen = 7;
    public static final int eyeCatcher2Len = 4;
    public static final int thClientInfoExtVersion = 2;
    public static final int thClientInfoActVersion = 1;
    public static final int netExtPassportLen = 185;
    public static final int netActPassportLen = 160;
    public static final String stringEncoding = new String("UTF-8");

    public static int arrayCmp(byte[] a1, int startPositionA, byte[] a2, int startPositionB, int numberOfBytesToCompare) {
        int i = 0;
        while (i < numberOfBytesToCompare) {
            if (a1[startPositionA + i] != a2[startPositionB + i]) {
                return a1[startPositionA + i] - a2[startPositionB + i];
            }
            ++i;
        }
        return 0;
    }

    public void clear() {
        super.clear();
        this.transId = null;
    }

    public boolean isValid() {
        if (null == this.transId) {
            return false;
        }
        if (32 != this.transId.getBytes().length) {
            return false;
        }
        return super.isValid();
    }

    public boolean setByNetPassport(byte[] netPassport) {
        int position = 0;
        if (!super.setByNetPassport(netPassport)) {
            return false;
        }
        this.transId = null;
        if (1 == netPassport[position += 4]) {
            return true;
        }
        if (2 == netPassport[position]) {
            this.transId = new String(netPassport, netPassport.length - 4 - 32, 32);
            if (32 != this.transId.getBytes().length) {
                this.transId = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getNetPassport() {
        int i = 0;
        int position = 0;
        if (!super.isValid()) {
            return null;
        }
        byte[] b = new byte[185];
        i = 0;
        while (i < 185) {
            b[i] = 0;
            ++i;
        }
        System.arraycopy(eyeCatcher, 0, b, position, 4);
        b[position += 4] = 2;
        b[++position] = 0;
        b[position + 1] = -71;
        b[position += 2] = (byte)(super.getTraceFlag() & 0xFF);
        b[position + 1] = (byte)((super.getTraceFlag() & 0xFF00) >> 8);
        position += 2;
        try {
            byte[] t = super.getCompName().getBytes(stringEncoding);
            if (32 < t.length) {
                System.arraycopy(t, 0, b, position, 32);
            } else {
                System.arraycopy(t, 0, b, position, t.length);
            }
            b[position += 32] = (byte)((super.getService() & 0xFF00) >> 8);
            b[position + 1] = (byte)(super.getService() & 0xFF);
            position += 2;
            String s = super.getUserId();
            if (null == s) {
                position += 32;
            } else {
                t = s.getBytes(stringEncoding);
                if (32 < t.length) {
                    System.arraycopy(t, 0, b, position, 32);
                } else {
                    System.arraycopy(t, 0, b, position, t.length);
                }
                position += 32;
            }
            t = super.getAction().getBytes(stringEncoding);
            if (40 < t.length) {
                System.arraycopy(t, 0, b, position, 40);
                position += 40;
            } else {
                System.arraycopy(t, 0, b, position, t.length);
                position += 40;
            }
            b[position] = (byte)((super.getActionType() & 0xFF00) >> 8);
            b[position + 1] = (byte)(super.getActionType() & 0xFF);
            position += 2;
            s = super.getPrevCompName();
            if (null == s) {
                position += 32;
            } else {
                t = s.getBytes(stringEncoding);
                if (32 < t.length) {
                    System.arraycopy(t, 0, b, position, 32);
                } else {
                    System.arraycopy(t, 0, b, position, t.length);
                }
                position += 32;
            }
            t = new String(this.transId).getBytes(stringEncoding);
            if (32 < t.length) {
                System.arraycopy(t, 0, b, position, 32);
            } else {
                System.arraycopy(t, 0, b, position, t.length);
            }
        }
        catch (Exception e) {
            return null;
        }
        System.arraycopy(eyeCatcher, 0, b, position += 32, 4);
        return b;
    }

    public void setByPassport(DsrIPassport passport) {
        if (null == passport) {
            return;
        }
        if (null == passport.getTransId()) {
            return;
        }
        this.clear();
        super.setBySubRecordCert(passport.getSubRecordCert());
        this.transId = passport.getTransId();
    }

    public void setByCert(DsrISubRecordCert cert) {
        super.setBySubRecordCert(cert);
    }

    public DsrISubRecordCert getSubRecordCert() {
        return this;
    }

    public boolean setTransId(String transid) {
        if (null == transid) {
            return false;
        }
        this.transId = transid;
        return 32 == this.transId.getBytes().length;
    }

    public String getTransId() {
        return this.transId;
    }
}

