/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrComponentStaticData;
import com.sap.jdsr.writer.DsrIComponentStaticData;
import com.sap.jdsr.writer.DsrScrTypeAbstract;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class DsrListener
extends Thread {
    public static final String getToken = "get";
    public static final String setToken = "set";
    public static final String tracefileToken = "tracefile";
    public static final String traceflagToken = "traceflag";
    public static final String maxmessagecountToken = "maxmessagecount";
    public static final String flushToken = "flush";
    public static final String componentstaticToken = "componentstatic";
    public static final String activeToken = "active";
    public static final String lastchangeToken = "lastchange";
    public static final String versionToken = "version";
    public static final String activecomponentsStartToken = "<activecomponents>";
    public static final String activecomponentsEndToken = "</activecomponents>";
    public static final String componentstaticdataStartToken = "<componentstaticdata>";
    public static final String componentstaticdataEndToken = "</componentstaticdata>";
    public static final String componentStartToken = "<component>";
    public static final String componentEndToken = "</component>";
    public static final String typeStartToken = "<type>";
    public static final String typeEndToken = "</type>";
    public static final String versionStartToken = "<version>";
    public static final String versionEndToken = "</version>";
    public static final String linkedsystemsStartToken = "<linkedsystems>";
    public static final String linkedsystemsEndToken = "</linkedsystems>";
    public static final String tracefilenamesStartToken = "<tracefilenames>";
    public static final String tracefilenamesEndToken = "</tracefilenames>";
    public static final String tracefilepatternsStartToken = "<tracefilepatterns>";
    public static final String tracefilepatternsEndToken = "</tracefilepatterns>";
    public static final String tracepathsStartToken = "<tracepaths>";
    public static final String tracepathsEndToken = "</tracepaths>";
    public static final String actiontypesStartToken = "<actiontypes>";
    public static final String actiontypesEndToken = "</actiontypes>";
    public static final String actionStartToken = "<action>";
    public static final String actionEndToken = "</action>";
    public static final String servicetypesStartToken = "<servicetypes>";
    public static final String servicetypesEndToken = "</servicetypes>";
    public static final String idStartToken = "<id>";
    public static final String idEndToken = "</id>";
    public static final String shortdescriptionStartToken = "<shortdescription>";
    public static final String shortdescriptionEndToken = "</shortdescription>";
    public static final String longdescriptionStartToken = "<longdescription>";
    public static final String longdescriptionEndToken = "</longdescription>";
    public static final String serviceStartToken = "<service>";
    public static final String serviceEndToken = "</service>";
    public static final String netStringEncoding = "UTF-8";
    private ServerSocket sock = null;
    private int port = 0;

    DsrListener() {
        try {
            this.sock = new ServerSocket(0);
            this.port = this.sock.getLocalPort();
        }
        catch (Exception e) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrListener: DsrListener(): caught exception: " + e.getMessage());
            }
            this.sock = null;
            this.port = 0;
        }
    }

    private void sendResult(String r, OutputStream os) {
        if (0 != DsrAdmin.traceFlag) {
            DsrAdmin.trace(null, "DsrListener: sendResult(): about to send result: " + r);
        }
        try {
            os.write(r.getBytes(netStringEncoding));
        }
        catch (Exception e) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrListener: sendResult(): caught exception: " + e.getMessage());
            }
            return;
        }
    }

    private void flush(String component, OutputStream os) {
        DsrComponentAdmin ca = null;
        String result = null;
        String validCompName = DsrAdmin.convertToValidComponentName(component);
        if (null == validCompName) {
            return;
        }
        ca = DsrAdmin.getComponentAdmin(validCompName);
        if (null == ca) {
            result = "flush failed \"no such component\"";
        } else if (!ca.getBufferAdmin().flush()) {
            result = "flush failed \"failed to flush buffer\"";
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = "flush ok";
        }
        this.sendResult(result, os);
    }

    private void getComponentStatic(String component, OutputStream os) {
        DsrComponentAdmin ca = null;
        DsrIComponentStaticData sd = null;
        StringBuffer r = new StringBuffer(1024);
        Enumeration e = null;
        DsrScrTypeAbstract t = null;
        String validCompName = DsrAdmin.convertToValidComponentName(component);
        if (null == validCompName) {
            return;
        }
        ca = DsrAdmin.getComponentAdmin(validCompName);
        if (null == ca) {
            this.sendResult("get componentstatic failed \"no such component\"", os);
            return;
        }
        sd = ca.getComponentStaticData();
        if (null == sd) {
            this.sendResult(new String(componentstaticdataStartToken + " " + componentstaticdataEndToken), os);
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrListener: getComponentStatic(): empty static data for component " + validCompName);
            }
            return;
        }
        r.append(componentstaticdataStartToken + " ");
        r.append(componentStartToken + " " + ca.getComponentName() + " " + componentEndToken + " ");
        if (null != ((DsrComponentStaticData)sd).componentType) {
            r.append(typeStartToken + " " + ((DsrComponentStaticData)sd).componentType + " " + typeEndToken + " ");
        }
        if (null != ((DsrComponentStaticData)sd).componentVersion) {
            r.append(versionStartToken + " " + ((DsrComponentStaticData)sd).componentVersion + " " + versionEndToken + " ");
        }
        if ((e = ((DsrComponentStaticData)sd).linkedSystems.elements()).hasMoreElements()) {
            r.append(linkedsystemsStartToken + " ");
            while (e.hasMoreElements()) {
                r.append("\"" + (String)e.nextElement() + "\" ");
            }
            r.append(linkedsystemsEndToken + " ");
        }
        if ((e = ((DsrComponentStaticData)sd).tracePaths.elements()).hasMoreElements()) {
            r.append(tracepathsStartToken + " ");
            while (e.hasMoreElements()) {
                r.append("\"" + (String)e.nextElement() + "\" ");
            }
            r.append(tracepathsEndToken + " ");
        }
        if ((e = ((DsrComponentStaticData)sd).actionTypes.elements()).hasMoreElements()) {
            r.append(actiontypesStartToken + " ");
            while (e.hasMoreElements()) {
                t = (DsrScrTypeAbstract)e.nextElement();
                r.append(actionStartToken + " ");
                r.append(idStartToken + " " + Integer.toString(t.getNumericValue()) + " " + idEndToken + " ");
                if (null != t.getShortDesc()) {
                    r.append(shortdescriptionStartToken + " " + t.getShortDesc() + " " + shortdescriptionEndToken + " ");
                }
                if (null != t.getLongDesc()) {
                    r.append(longdescriptionStartToken + " " + t.getLongDesc() + " " + longdescriptionEndToken + " ");
                }
                r.append(actionEndToken + " ");
            }
            r.append(actiontypesEndToken + " ");
        }
        if ((e = ((DsrComponentStaticData)sd).serviceTypes.elements()).hasMoreElements()) {
            r.append(servicetypesStartToken + " ");
            while (e.hasMoreElements()) {
                t = (DsrScrTypeAbstract)e.nextElement();
                r.append(serviceStartToken + " ");
                r.append(idStartToken + " " + Integer.toString(t.getNumericValue()) + " " + idEndToken + " ");
                if (null != t.getShortDesc()) {
                    r.append(shortdescriptionStartToken + " " + t.getShortDesc() + " " + shortdescriptionEndToken + " ");
                }
                if (null != t.getLongDesc()) {
                    r.append(longdescriptionStartToken + " " + t.getLongDesc() + " " + longdescriptionEndToken + " ");
                }
                r.append(serviceEndToken + " ");
            }
            r.append(servicetypesEndToken + " ");
        }
        r.append(componentstaticdataEndToken + " ");
        if (0 != DsrAdmin.traceFlag) {
            DsrAdmin.trace(null, "DsrListener: getComponentStatic(): sending data for component " + validCompName + r.toString());
        }
        this.sendResult(r.toString(), os);
    }

    private void getActive(OutputStream os) {
        String r = DsrAdmin.getActive();
        this.sendResult(new String(activecomponentsStartToken + " " + (null == r ? " " : r) + " " + activecomponentsEndToken), os);
    }

    private void getLastChange(OutputStream os) {
        this.sendResult(Long.toString(DsrAdmin.getLastChangeTime() / 1000L), os);
    }

    public void parseRequest(String s, Socket sock) {
        StringTokenizer st = new StringTokenizer(s);
        String nt = null;
        OutputStream os = null;
        try {
            os = sock.getOutputStream();
        }
        catch (Exception e) {
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        nt = st.nextToken();
        if (0 == nt.compareTo(flushToken)) {
            if (!st.hasMoreTokens()) {
                this.sendResult("flush failed \"no component specified\"", os);
                return;
            }
            nt = st.nextToken();
            this.flush(nt, os);
            return;
        }
        if (0 == nt.compareTo(setToken)) {
            if (!st.hasMoreTokens()) {
                this.sendResult("set failed \"no target (traceflag,tracefile,maxmessagecount) specified\"", os);
                return;
            }
            nt = st.nextToken();
            if (0 == nt.compareTo(tracefileToken)) {
                if (!st.hasMoreTokens()) {
                    this.sendResult("set tracefile failed \"no component specified\"", os);
                    return;
                }
                nt = st.nextToken();
                DsrAdmin.setTraceFileName(nt);
                this.sendResult("set tracefile to ", os);
                this.sendResult(nt, os);
                return;
            }
            if (0 == nt.compareTo(traceflagToken)) {
                if (!st.hasMoreTokens()) {
                    this.sendResult("set traceflag failed \"no flag value specified\"", os);
                    return;
                }
                nt = st.nextToken();
                int f = Integer.parseInt(nt);
                String flag = nt;
                if (0 > f) {
                    this.sendResult("set traceflag failed \"invalid flag value specified\"", os);
                    return;
                }
                if (!st.hasMoreTokens()) {
                    this.sendResult("set traceflag failed \"no component specified\"", os);
                    return;
                }
                nt = st.nextToken();
                if (0 == nt.compareTo("*")) {
                    Enumeration n = DsrAdmin.getAllComponentAdmin();
                    if (null != n) {
                        while (n.hasMoreElements()) {
                            ((DsrComponentAdmin)n.nextElement()).traceFlag = f;
                        }
                    }
                    DsrAdmin.traceFlag = f;
                    this.sendResult("set traceflag to ", os);
                    this.sendResult(flag, os);
                    this.sendResult(" for component ", os);
                    this.sendResult(nt, os);
                    return;
                }
                DsrComponentAdmin ca = DsrAdmin.getComponentAdmin(nt);
                if (null == ca) {
                    this.sendResult("set traceflag failed \"no such component\"", os);
                    return;
                }
                ca.traceFlag = f;
                if (0 == f) {
                    Enumeration n = DsrAdmin.getAllComponentAdmin();
                    boolean someComponentTraces = false;
                    if (null != n) {
                        while (n.hasMoreElements()) {
                            if (0 == ((DsrComponentAdmin)n.nextElement()).traceFlag) continue;
                            someComponentTraces = true;
                            break;
                        }
                    }
                    if (!someComponentTraces) {
                        DsrAdmin.traceFlag = 0;
                    }
                } else {
                    DsrAdmin.traceFlag = f;
                }
                this.sendResult("set traceflag to ", os);
                this.sendResult(flag, os);
                this.sendResult(" for component ", os);
                this.sendResult(nt, os);
                return;
            }
            if (0 == nt.compareTo(maxmessagecountToken)) {
                if (!st.hasMoreTokens()) {
                    this.sendResult("set maxmessagecount failed \"no count specified\"", os);
                    return;
                }
                nt = st.nextToken();
                int f = Integer.parseInt(nt);
                if (0 >= f) {
                    this.sendResult("set maxmessagecount failed \"no valid count specified\"", os);
                    return;
                }
                DsrAdmin.setTraceMessageMaxCount(f);
                this.sendResult("set maxmessagecount to ", os);
                this.sendResult(nt, os);
                return;
            }
            this.sendResult("set failed \"invalid target specified\"", os);
            return;
        }
        if (0 == nt.compareTo(getToken)) {
            if (!st.hasMoreTokens()) {
                this.sendResult("get failed \"no target (componentstatic,active,lastchange,version) specified\"", os);
                return;
            }
            nt = st.nextToken();
            if (0 == nt.compareTo(componentstaticToken)) {
                if (!st.hasMoreTokens()) {
                    this.sendResult("get componentstatic failed \"no component specified\"", os);
                    return;
                }
                nt = st.nextToken();
                this.getComponentStatic(nt, os);
                return;
            }
            if (0 == nt.compareTo(activeToken)) {
                this.getActive(os);
                return;
            }
            if (0 == nt.compareTo(lastchangeToken)) {
                this.getLastChange(os);
                return;
            }
            if (0 == nt.compareTo(versionToken)) {
                if (st.hasMoreTokens()) {
                    this.sendResult("get version failed \"unexpected token found: ", os);
                    this.sendResult(st.nextToken(), os);
                    this.sendResult("\"", os);
                    return;
                }
                this.sendResult("2.1", os);
                return;
            }
            this.sendResult("get failed \"invalid target specified\"", os);
        }
    }

    public void run() {
        Socket s = null;
        InputStream is = null;
        byte[] b = new byte[1024];
        int countB = 0;
        String str = null;
        if (null == this.sock) {
            return;
        }
        while (true) {
            if (null != s) {
                try {
                    s.close();
                    s = null;
                }
                catch (Exception e) {
                    s = null;
                    continue;
                }
            }
            try {
                s = this.sock.accept();
            }
            catch (Exception e) {
                continue;
            }
            if (!s.getInetAddress().equals(s.getLocalAddress())) continue;
            try {
                is = s.getInputStream();
                countB = is.read(b, 0, b.length);
                if (0 > countB) continue;
                str = new String(b, 0, countB, netStringEncoding);
            }
            catch (Exception e) {
                continue;
            }
            this.parseRequest(str, s);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void finalize() {
        DsrAdmin.eraseFromPortfile(this.port);
    }
}

