/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrComponentStaticData;
import com.sap.jdsr.writer.DsrIComponentStaticData;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrIRecordSet;
import com.sap.jdsr.writer.DsrITrace;
import com.sap.jdsr.writer.DsrMainRecord;
import com.sap.jdsr.writer.DsrPassport;
import com.sap.jdsr.writer.DsrRecordSet;
import com.sap.jdsr.writer.DsrTrace;

public class DsrFactory {
    public static DsrIRecordSet makeDsrRecordSet(String componentName) {
        String convertedName;
        if (null == componentName) {
            componentName = DsrAdmin.fallbackComponentName;
        }
        if (32 < componentName.length()) {
            componentName = componentName.substring(0, 32);
        }
        if (null == (convertedName = DsrAdmin.convertToValidComponentName(componentName))) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrFactory: makeDsrRecordSet(): DsrAdmin.convertToValidComponentName(" + componentName + ") failed.");
            }
            return null;
        }
        return new DsrRecordSet(componentName, convertedName);
    }

    public static DsrIComponentStaticData makeDsrComponentStaticData() {
        return new DsrComponentStaticData();
    }

    public static boolean setComponentStaticData(String componentName, DsrIComponentStaticData statData) {
        String convertedName;
        if (32 < componentName.length()) {
            componentName = componentName.substring(0, 32);
        }
        if (null == (convertedName = DsrAdmin.convertToValidComponentName(componentName))) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrFactory: setComponentStaticData(): DsrAdmin.convertToValidComponentName(" + componentName + ") failed.");
            }
            return false;
        }
        return DsrAdmin.setComponentStaticData(componentName, convertedName, statData);
    }

    public static DsrIPassport makeDsrPassport() {
        return new DsrPassport();
    }

    public static void dsrTraceHi(DsrITrace traceInfo) {
        if (null == traceInfo) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrFactory: dsrTraceHi(): traceInfo is null.");
            }
            return;
        }
        if (traceInfo.getTraceLevel() != 255) {
            return;
        }
        DsrTrace.trace(traceInfo, 255);
    }

    public static void dsrTraceMed(DsrITrace traceInfo) {
        if (null == traceInfo) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrFactory: dsrTraceMed(): traceInfo is null.");
            }
            return;
        }
        if (traceInfo.getTraceLevel() < 15) {
            return;
        }
        DsrTrace.trace(traceInfo, 15);
    }

    public static void dsrTraceLow(DsrITrace traceInfo) {
        if (null == traceInfo) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrFactory: dsrTraceLow(): traceInfo is null.");
            }
            return;
        }
        if (traceInfo.getTraceLevel() == 0) {
            return;
        }
        DsrTrace.trace(traceInfo, 1);
    }

    public static String makeGuid() {
        DsrMainRecord m = new DsrMainRecord();
        m.setNewTransId();
        if (0 != DsrAdmin.traceFlag) {
            DsrAdmin.trace(null, "DsrFactory: makeGuid(): returning: " + m.getTransId());
        }
        return m.getTransId();
    }
}

