/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrIComponentStaticData;
import com.sap.jdsr.writer.DsrScrAction;
import com.sap.jdsr.writer.DsrScrService;
import java.util.Vector;

public class DsrComponentStaticData
implements DsrIComponentStaticData {
    public String componentVersion = null;
    public String componentType = null;
    public Vector serviceTypes = new Vector(10);
    public Vector actionTypes = new Vector(10);
    public Vector linkedSystems = new Vector(10);
    public Vector tracePaths = new Vector(10);
    public Vector traceFileNames = new Vector(10);
    public Vector traceFilePatterns = new Vector(10);

    private boolean addString(String s, int l, Vector v) {
        if (10 <= v.size()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addString(): max count reached: 10");
            }
            return false;
        }
        if (l < s.length()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addString(): adding substring: " + s + " " + s.substring(0, l));
            }
            v.add(s.substring(0, l));
        } else {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addString(): adding string: " + s);
            }
            v.add(s);
        }
        return true;
    }

    public void addComponentVersion(String cVersion) {
        if (32 < cVersion.length()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addComponentVersion(): adding substring: " + cVersion.substring(0, 32));
            }
            this.componentVersion = cVersion.substring(0, 32);
        } else {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addComponentVersion(): adding string: " + cVersion);
            }
            this.componentVersion = cVersion;
        }
    }

    public void addComponentType(String cType) {
        if (10 < cType.length()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addComponentType(): adding substring: " + cType.substring(0, 10));
            }
            this.componentType = cType.substring(0, 10);
        } else {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addComponentType(): adding string: " + cType);
            }
            this.componentType = cType;
        }
    }

    public boolean addActionType(int numericValue, String shortDescription, String longDescription) {
        if (numericValue <= 0) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addActionType(): invalid numeric value: " + numericValue);
            }
            return false;
        }
        if (10 <= this.actionTypes.size() + this.serviceTypes.size()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addActionType(): to many action & service types: " + this.actionTypes.size() + " " + this.serviceTypes.size() + " " + 10);
            }
            return false;
        }
        this.actionTypes.add(new DsrScrAction(numericValue, shortDescription, longDescription));
        return true;
    }

    public boolean addServiceType(int numericValue, String shortDescription, String longDescription) {
        if (numericValue <= 0) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addServiceType(): invalid numeric value: " + numericValue);
            }
            return false;
        }
        if (10 <= this.actionTypes.size() + this.serviceTypes.size()) {
            if (0 != DsrAdmin.traceFlag) {
                DsrAdmin.trace(null, "DsrComponentStaticData: addServiceType(): to many action & service types: " + this.actionTypes.size() + " " + this.serviceTypes.size() + " " + 10);
            }
            return false;
        }
        this.serviceTypes.add(new DsrScrService(numericValue, shortDescription, longDescription));
        return true;
    }

    public boolean addLinkedSystem(String lSystem) {
        return this.addString(lSystem, 32, this.linkedSystems);
    }

    public boolean addTracePath(String tPath) {
        return this.addString(tPath, 512, this.tracePaths);
    }

    public boolean addTraceFileName(String tFileName) {
        return this.addString(tFileName, 512, this.traceFileNames);
    }

    public boolean addTraceFilePattern(String tFilePattern) {
        return this.addString(tFilePattern, 512, this.traceFilePatterns);
    }
}

