/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrBuffer;
import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrRecordSet;

public class DsrBufferAdmin
implements Runnable {
    private String componentName = null;
    private DsrBuffer[] bufferArray = new DsrBuffer[2];
    private DsrBuffer bufferToFlush = null;
    private Thread flushThread = new Thread(this);
    private int activeBuffer = 0;
    private int passiveBuffer = 1;
    private long timestamp = 0L;
    private DsrComponentAdmin ca = null;
    private boolean isWriteLocked = false;
    private int requiredSpace;
    private boolean writeToActive = false;
    private boolean swapBuffer = false;
    private boolean bufferJustSwaped = false;
    private String bufferSizePropertyString = null;

    protected DsrBufferAdmin(String componentname, DsrComponentAdmin c) {
        try {
            this.componentName = componentname;
            this.ca = c;
            this.bufferSizePropertyString = new String("dsr." + componentname + ".buffersize");
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): component: " + componentname);
            }
            this.bufferArray[0] = new DsrBuffer(componentname, c, this.bufferSizePropertyString);
            this.bufferArray[1] = new DsrBuffer(componentname, c, this.bufferSizePropertyString);
            this.activeBuffer = 0;
            this.passiveBuffer = (this.activeBuffer + 1) % 2;
            this.timestamp = System.currentTimeMillis();
            this.bufferArray[this.activeBuffer].refreshHour(this.timestamp);
            if (!DsrAdmin.createComponentDirectory(componentname)) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): DsrAdmin.createComponentDirectory() failed.");
                }
                this.componentName = null;
            }
            this.flushThread.start();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): caught exception: " + e.getMessage());
            }
            this.componentName = null;
        }
    }

    private synchronized void holdOn() {
        block2: {
            try {
                this.wait();
            }
            catch (Exception e) {
                if (0 == this.ca.traceFlag) break block2;
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): this.wait() failed: " + e.getMessage());
            }
        }
    }

    private synchronized void goAhead() {
        block2: {
            try {
                this.notifyAll();
            }
            catch (Exception e) {
                if (0 == this.ca.traceFlag) break block2;
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): this.notifyAll() failed: " + e.getMessage());
            }
        }
    }

    public void run() {
        while (true) {
            this.holdOn();
            this.isWriteLocked = true;
            if (null == this.bufferToFlush) {
                if (0 == this.ca.traceFlag) continue;
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): this.bufferToFlush is null");
                continue;
            }
            this.bufferToFlush.writeToFile();
            this.isWriteLocked = false;
        }
    }

    private boolean isOk() {
        if (null == this.componentName) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: isOk(): invalid self.");
            }
            return false;
        }
        return true;
    }

    private boolean switchBuffer() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: switchBuffer(): entered.");
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: switchBuffer(): writing to active...");
        }
        this.bufferToFlush = this.bufferArray[this.activeBuffer];
        this.goAhead();
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: switchBuffer(): switching buffer. act: " + this.activeBuffer + " pass: " + this.passiveBuffer);
        }
        if (this.bufferArray[this.passiveBuffer].hasBufferSizeChanged(this.bufferSizePropertyString)) {
            this.bufferArray[this.passiveBuffer] = new DsrBuffer(this.componentName, this.ca, this.bufferSizePropertyString);
        }
        this.activeBuffer = this.passiveBuffer;
        this.passiveBuffer = (this.activeBuffer + 1) % 2;
        this.bufferArray[this.activeBuffer].refreshHour(this.timestamp);
        return true;
    }

    protected synchronized boolean write(DsrRecordSet s) {
        int recordLen;
        this.bufferJustSwaped = false;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): entered.");
        }
        if (null == s) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): no record set.");
            }
            return false;
        }
        if (!this.isOk()) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): invalid self.");
            }
            return false;
        }
        this.timestamp = System.currentTimeMillis();
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): end time is " + this.timestamp);
        }
        if (this.bufferArray[this.activeBuffer].hasCurrentHourChanged(this.timestamp)) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): hour has changed.");
            }
            if (this.isWriteLocked) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): can't swap buffer. flush still in progress.");
                }
                return false;
            }
            if (!this.switchBuffer()) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): switchBuffer() failed.");
                }
                return false;
            }
            this.bufferJustSwaped = true;
        }
        if (0 >= (recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition()))) {
            if (this.bufferJustSwaped) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: record probably too long:");
                }
                return false;
            }
            if (this.isWriteLocked) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): can't swap buffer. flush still in progress.");
                }
                return false;
            }
            if (!this.switchBuffer()) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): switchBuffer() failed.");
                }
                return false;
            }
            recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition());
            if (0 >= recordLen) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: record probably too long:");
                }
                return false;
            }
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): writing data to position: " + this.bufferArray[this.activeBuffer].getCurrentWritePosition());
        }
        this.bufferArray[this.activeBuffer].writeTimestamp(this.timestamp);
        this.bufferArray[this.activeBuffer].updateSecondIndexBuffer(this.timestamp);
        this.bufferArray[this.activeBuffer].setCurrentWritePositionByIncrement(recordLen);
        this.bufferArray[this.activeBuffer].updateLastRecordTimestamp(this.timestamp / 1000L);
        return true;
    }

    protected synchronized boolean flush() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: flush(): entered.");
        }
        if (!this.isOk()) {
            return false;
        }
        this.timestamp = System.currentTimeMillis();
        if (this.isWriteLocked) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: flush(): active buffer write locked.");
            }
            return false;
        }
        return this.switchBuffer();
    }
}

