/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrStatFileFilter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DsrBuffer {
    public static final int fileNameLen = 512;
    private static final String secondIndexStartToken = "<secondindex>";
    private static final String secondIndexEndToken = "</secondindex>";
    private static final String lastRecFileNameString = "dsrlastrec.txt";
    private static final char[] colon = new char[]{':'};
    private static final char[] semicolon = new char[]{';'};
    private static final int arrayMaxSize = 512;
    private static final int readIntBadReturnCode = -4711;
    private static final long readLongBadReturnCode = -4711L;
    private static final int fallbackBufferSize = 5000000;
    private static final int minBufferSize = 100000;
    private int bufferLen = 0;
    private String component = null;
    private byte[] buffer = null;
    private int bufferPosition = 0;
    private long currentHour = -1L;
    private String statFileName = null;
    private String sixFileName = null;
    private String lastRecFileName = null;
    private BufferedReader bufferedSixFileReader = null;
    private long[] secondIndex = new long[3600];
    private long[] secondIndexBuffer = new long[3600];
    private long secondIndexOffset;
    private long lastRecordTimestamp;
    private StringBuffer strBuffer = new StringBuffer(512);
    private StringBuffer sixStrBuffer = new StringBuffer(2000);
    private DsrComponentAdmin ca = null;
    private StringBuffer readStringBuffer = new StringBuffer(128);
    private Calendar calendar = Calendar.getInstance(DsrAdmin.timezone);
    private Date date = new Date();
    private static final int l1 = 6;
    private static final int l2 = 14;

    protected DsrBuffer(String componentname, DsrComponentAdmin c, String bufferSizePropertyString) {
        this.ca = c;
        this.component = componentname;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: created for component " + componentname);
        }
        int i = 0;
        while (i < 3600) {
            this.secondIndexBuffer[i] = -1L;
            ++i;
        }
        Integer bufferSizeInteger = Integer.getInteger(bufferSizePropertyString);
        if (null == bufferSizeInteger) {
            this.bufferLen = 5000000;
        } else {
            this.bufferLen = bufferSizeInteger;
            if (100000 > this.bufferLen) {
                this.bufferLen = 100000;
            }
        }
        this.buffer = new byte[this.bufferLen];
    }

    protected boolean hasBufferSizeChanged(String bufferSizePropertyString) {
        int b;
        Integer bufferSizeInteger = Integer.getInteger(bufferSizePropertyString);
        if (null == bufferSizeInteger) {
            b = 5000000;
        } else {
            b = bufferSizeInteger;
            if (100000 > b) {
                b = 100000;
            }
        }
        return b != this.bufferLen;
    }

    protected void updateLastRecordTimestamp(long t) {
        this.lastRecordTimestamp = t;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: updateLastRecordTimestamp(): old timestamp was " + this.lastRecordTimestamp + " new is " + t);
        }
    }

    protected void writeLastRecordTimestamp() {
        try {
            File oldFile = new File(this.lastRecFileName);
            oldFile.delete();
            RandomAccessFile outputFile = new RandomAccessFile(this.lastRecFileName, "rw");
            outputFile.write(new Long(this.lastRecordTimestamp).toString().getBytes());
            outputFile.close();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeLastRecordTimestamp(): catched exception " + e.getMessage());
            }
            return;
        }
    }

    protected void writeTimestamp(long t) {
        DsrAdmin.long2EightByte(t / 1000L, this.buffer, this.bufferPosition + 6);
        DsrAdmin.int2TwoByte((int)(t % 1000L), this.buffer, this.bufferPosition + 14);
    }

    protected void clearSecondIndex() {
        int i = 0;
        while (i < 3600) {
            this.secondIndex[i] = -1L;
            ++i;
        }
    }

    private void closeSixFileReader() {
        block2: {
            try {
                this.bufferedSixFileReader.close();
            }
            catch (Exception e) {
                if (0 == this.ca.traceFlag) break block2;
                DsrAdmin.trace(this.component, "DsrBuffer: closeSixFileReader(): catched exception " + e.getMessage());
            }
        }
    }

    private int readNext() {
        try {
            return this.bufferedSixFileReader.read();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readNext(): catched exception " + e.getMessage());
            }
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int skipLeadingBlanks() {
        int c;
        while (-1 != (c = this.readNext())) {
            void var1_1;
            if (!Character.isWhitespace((char)var1_1)) break;
        }
        if (-1 == c) {
            return -1;
        }
        return c;
    }

    private void mergeSecondIndex(long offset) {
        int i = 0;
        while (i < 3600) {
            if (-1L < this.secondIndexBuffer[i] && -1L == this.secondIndex[i]) {
                this.secondIndex[i] = this.secondIndexBuffer[i] + offset;
            }
            ++i;
        }
    }

    private void getSecondIndex() {
        File sixFile = null;
        this.clearSecondIndex();
        sixFile = new File(this.sixFileName);
        if (!sixFile.exists()) {
            return;
        }
        if (!sixFile.canRead()) {
            return;
        }
        try {
            this.bufferedSixFileReader = new BufferedReader(new FileReader(sixFile));
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: getSecondIndex(): catched exception " + e.getMessage());
            }
            return;
        }
        if (!this.readToken(secondIndexStartToken.toCharArray())) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: getSecondIndex(): this.readToken() failed on: " + secondIndexStartToken);
            }
            this.closeSixFileReader();
            return;
        }
        int i = 0;
        while (i < 3600) {
            if (!this.readSecondIndexEntry(i)) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: getSecondIndex(): this.readSecondIndexEntry() failed on index: " + i);
                }
                this.clearSecondIndex();
                return;
            }
            ++i;
        }
        if (!this.readToken(secondIndexEndToken.toCharArray())) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: getSecondIndex(): this.readToken() failed on: " + secondIndexEndToken);
            }
            this.clearSecondIndex();
            return;
        }
        this.closeSixFileReader();
    }

    private boolean readToken(char[] t) {
        int pos = 0;
        char[] s = new char[t.length];
        int c = 0;
        while (c < s.length) {
            s[c] = '\u0000';
            ++c;
        }
        c = this.skipLeadingBlanks();
        if (-1 == c) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readToken(): this.skipLeadingBlanks() failed : " + new String(t));
            }
            return false;
        }
        while (!Character.isWhitespace((char)c)) {
            if (pos >= s.length) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readToken(): pos >= s.length : " + pos + " " + s.length + " " + new String(s));
                }
                return false;
            }
            s[pos] = (char)c;
            ++pos;
            c = this.readNext();
            if (-1 != c) continue;
        }
        if (pos != s.length) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readToken(): pos != s.length : " + pos + " " + s.length + " " + new String(s));
            }
            return false;
        }
        c = 0;
        while (c < t.length) {
            if (s[c] != t[c]) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readToken(): s[c] != t[c] : " + c + " " + s[c] + " " + t[c] + " " + new String(s));
                }
                return false;
            }
            ++c;
        }
        return true;
    }

    private boolean readSecondIndexEntry(int entryNumber) {
        int index = this.readInt();
        if (-4711 == index) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): this.readInt() failed at: " + entryNumber);
            }
            return false;
        }
        if (entryNumber != index) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): entryNumber != index: " + entryNumber + " " + index);
            }
            return false;
        }
        if (!this.readToken(colon)) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): readToken(:) failed.");
            }
            return false;
        }
        long offset = this.readLong();
        if (-4711L == offset) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): readLong() failed.");
            }
            return false;
        }
        if (-1L > offset) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): -1 > offset." + offset);
            }
            return false;
        }
        if (!this.readToken(semicolon)) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): readToken(;) failed.");
            }
            return false;
        }
        this.secondIndex[index] = offset;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: readSecondIndexEntry(): offset for " + index + " is " + offset);
        }
        return true;
    }

    private int readInt() {
        int c;
        int pos = 0;
        StringBuffer r = this.readStringBuffer;
        int ret = 0;
        if (0 < r.length()) {
            r.delete(0, r.length());
        }
        if (-1 == (c = this.skipLeadingBlanks())) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readInt(): this.skipLeadingBlanks() failed.");
            }
            return -4711;
        }
        while (!Character.isWhitespace((char)c)) {
            if (pos >= r.capacity()) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readInt(): pos >= r.capacity(): " + pos + " " + r.capacity() + " " + r.toString());
                }
                return -4711;
            }
            if (!Character.isDigit((char)c)) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readInt(): non digit char found: " + c);
                }
                return -4711;
            }
            r.append((char)c);
            ++pos;
            c = this.readNext();
            if (-1 != c) continue;
        }
        try {
            ret = Integer.parseInt(new String(r));
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readInt(): exception caught: " + e.getMessage());
            }
            return -4711;
        }
        return ret;
    }

    private long readLong() {
        int c;
        int pos = 0;
        StringBuffer r = this.readStringBuffer;
        long ret = 0L;
        if (0 < r.length()) {
            r.delete(0, r.length());
        }
        if (-1 == (c = this.skipLeadingBlanks())) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readLong(): this.skipLeadingBlanks() failed.");
            }
            return -4711L;
        }
        while (!Character.isWhitespace((char)c)) {
            if (pos >= r.capacity()) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readLong(): pos >= r.capacity(): " + pos + " " + r.capacity() + " " + r.toString());
                }
                return -4711L;
            }
            if (!Character.isDigit((char)c) && '-' != (char)c) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: readLong(): non digit char found: " + c);
                }
                return -4711L;
            }
            r.append((char)c);
            ++pos;
            c = this.readNext();
            if (-1 != c) continue;
        }
        try {
            ret = Long.parseLong(new String(r));
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: readLong(): exception caught: " + e.getMessage());
            }
            return -4711L;
        }
        return ret;
    }

    private boolean writeSecondIndex() {
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(this.sixFileName, "rw");
            f.setLength(0L);
            if (0 < this.sixStrBuffer.length()) {
                this.sixStrBuffer.delete(0, this.sixStrBuffer.length());
            }
            this.sixStrBuffer.append(secondIndexStartToken);
            this.sixStrBuffer.append("\n");
            int i = 0;
            while (i < 3600) {
                this.sixStrBuffer.append(i);
                this.sixStrBuffer.append(" : ");
                this.sixStrBuffer.append(this.secondIndex[i]);
                this.sixStrBuffer.append(" ;\n");
                ++i;
            }
            this.sixStrBuffer.append(secondIndexEndToken);
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeSecondIndex(): writing: \n" + this.sixStrBuffer.toString());
            }
            f.write(this.sixStrBuffer.toString().getBytes());
            f.close();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeSecondIndex(): exception caught: " + e.getMessage());
            }
            return false;
        }
        return true;
    }

    protected void updateSecondIndexBuffer(long time) {
        block4: {
            int index = (int)(time - this.currentHour) / 1000;
            try {
                if (-1L == this.secondIndexBuffer[index]) {
                    this.secondIndexBuffer[index] = this.bufferPosition;
                    if (0 != this.ca.traceFlag) {
                        DsrAdmin.trace(this.component, "DsrBuffer: updateSecondIndexBuffer(): updating: " + index + " " + this.bufferPosition);
                    }
                }
            }
            catch (Exception e) {
                if (0 == this.ca.traceFlag) break block4;
                DsrAdmin.trace(this.component, "DsrBuffer: updateSecondIndexBuffer(): caught Exception at index " + index + " " + e.getMessage());
            }
        }
    }

    protected void writeToFile() {
        boolean i = false;
        this.secondIndexOffset = 0L;
        BufferedOutputStream os = null;
        File outputFile = null;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: writeToFile() entered.");
        }
        if (0 == this.bufferPosition) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): nothing to flush.");
            }
            return;
        }
        try {
            outputFile = new File(this.statFileName);
            os = new BufferedOutputStream(new FileOutputStream(this.statFileName, true), this.bufferLen);
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): caught exception: " + e.getMessage());
            }
            return;
        }
        this.getSecondIndex();
        this.deleteOldStatFiles();
        try {
            this.secondIndexOffset = outputFile.length();
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): about to flush.");
            }
            os.write(this.buffer, 0, this.bufferPosition);
            os.flush();
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): flush done: " + this.bufferPosition + " bytes.");
            }
            os.close();
            this.mergeSecondIndex(this.secondIndexOffset);
            this.writeLastRecordTimestamp();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): caught exception: " + e.getMessage());
            }
            try {
                os.close();
            }
            catch (Exception e3) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): caught exception: " + e3.getMessage());
                }
                return;
            }
            return;
        }
        this.writeSecondIndex();
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: writeToFile(): flush thread ends here.");
        }
    }

    protected void clear() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: clear(): clearing buffer.");
        }
        this.bufferPosition = 0;
    }

    protected int getFreeBufferSize() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: getFreeBufferSize(): returning: " + (this.bufferLen - this.bufferPosition));
        }
        return this.bufferLen - this.bufferPosition;
    }

    protected int getCurrentWritePosition() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: getCurrentWritePosition(): returning: " + this.bufferPosition);
        }
        return this.bufferPosition;
    }

    protected boolean setCurrentWritePositionByIncrement(int p) {
        if (this.bufferLen < p + this.bufferPosition) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: setCurrentWritePositionByIncrement(): cannot increment position: " + p + this.bufferPosition + this.bufferLen);
            }
            return false;
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: setCurrentWritePositionByIncrement(): increment position: " + p + this.bufferPosition + this.bufferLen);
        }
        this.bufferPosition += p;
        return true;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    protected void refreshHour(long time) {
        this.date.setTime(time);
        this.calendar.setTime(this.date);
        int d = this.calendar.get(5);
        int m = this.calendar.get(2) + 1;
        int y = this.calendar.get(1);
        int h = this.calendar.get(11);
        boolean sepThere = false;
        String s = System.getProperty("dsr.root");
        if (File.separatorChar == s.charAt(s.length() - 1)) {
            sepThere = true;
        }
        if (0 < this.strBuffer.length()) {
            this.strBuffer.delete(0, this.strBuffer.length());
        }
        this.strBuffer.append(s);
        this.strBuffer.append(sepThere ? "" : File.separator);
        this.strBuffer.append(this.component);
        this.strBuffer.append("_java");
        this.strBuffer.append(File.separatorChar);
        this.strBuffer.append(this.component);
        this.strBuffer.append("_java");
        this.strBuffer.append(9 < d ? "" : "0");
        this.strBuffer.append(d);
        this.strBuffer.append(9 < m ? "" : "0");
        this.strBuffer.append(m);
        this.strBuffer.append(y);
        this.strBuffer.append(9 < h ? "" : "0");
        this.strBuffer.append(h);
        this.strBuffer.append(".txt");
        this.statFileName = new String(this.strBuffer);
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: refreshHour(): new statfile name is: " + this.statFileName);
        }
        if (0 < this.strBuffer.length()) {
            this.strBuffer.delete(0, this.strBuffer.length());
        }
        this.strBuffer.append(this.statFileName.substring(0, this.statFileName.length() - ".txt".length()));
        this.strBuffer.append(".six");
        this.sixFileName = new String(this.strBuffer);
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: refreshHour(): new sixfile name is: " + this.sixFileName);
        }
        if (null == this.lastRecFileName) {
            if (0 < this.strBuffer.length()) {
                this.strBuffer.delete(0, this.strBuffer.length());
            }
            this.strBuffer.append(s);
            this.strBuffer.append(sepThere ? "" : File.separator);
            this.strBuffer.append(this.component);
            this.strBuffer.append("_java");
            this.strBuffer.append(File.separatorChar);
            this.strBuffer.append(lastRecFileNameString);
            this.lastRecFileName = new String(this.strBuffer);
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: refreshHour(): new lastRecFileName name is: " + this.lastRecFileName);
        }
        this.currentHour = time - (long)this.calendar.get(14) - (long)this.calendar.get(13) * 1000L - (long)this.calendar.get(12) * 60000L;
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: refreshHour(): new currentHour is: " + this.currentHour);
        }
        this.bufferPosition = 0;
        int i = 0;
        while (i < 3600) {
            this.secondIndexBuffer[i] = -1L;
            ++i;
        }
    }

    protected boolean hasCurrentHourChanged(long time) {
        return time - this.currentHour >= 3600000L;
    }

    private void deleteOldStatFiles() {
        String componentDir = null;
        File compDirFile = null;
        File[] statFiles = null;
        int maxCount = 0;
        DsrStatFileFilter f = null;
        if (null == this.component) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): no component name.");
            }
            return;
        }
        componentDir = DsrAdmin.getComponentDirectory(this.component);
        if (null == componentDir) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): DsrAdmin.getComponentDirectory on: " + this.component + " failed.");
            }
            return;
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): component dir is: " + componentDir);
        }
        if (-1 == (maxCount = DsrAdmin.getStatFileMaxCount(this.component))) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): DsrAdmin.getStatFileMaxCount() failed.");
            }
            return;
        }
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): max stat file count for component " + this.component + " is " + maxCount);
        }
        f = new DsrStatFileFilter(this.component);
        try {
            compDirFile = new File(componentDir);
            statFiles = compDirFile.listFiles(f);
            if (statFiles.length <= maxCount) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): nothing to delete.");
                }
                return;
            }
            Arrays.sort(statFiles, f);
            int deleteCount = statFiles.length - 2 * maxCount;
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): " + deleteCount + " files to delete.");
            }
            int i = 0;
            while (i < deleteCount) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): deleting: " + statFiles[i].getName());
                }
                statFiles[i].delete();
                ++i;
            }
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.component, "DsrBuffer: deleteOldStatFiles(): caught exception: " + e.getMessage());
            }
            return;
        }
    }
}

