/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

public class VersionString
implements Comparator {
    protected Vector m_components;

    public VersionString(String version) {
        StringTokenizer tokenizer = new StringTokenizer(version, ".", false);
        this.m_components = new Vector();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Integer component = new Integer(Integer.parseInt(token));
            this.m_components.add(component);
        }
    }

    public VersionString() {
        this.m_components = new Vector();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VersionString)) {
            return false;
        }
        VersionString ob = (VersionString)obj;
        return ob.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.m_components.size(); ++i) {
            if (i > 0) {
                result.append(".");
            }
            result.append(this.m_components.get(i).toString());
        }
        return result.toString();
    }

    public int compareTo(Object o2) {
        return this.compare(this, o2);
    }

    public int compare(Object o1, Object o2) {
        VersionString v1 = (VersionString)o1;
        VersionString v2 = (VersionString)o2;
        for (int i = 0; i < v1.m_components.size(); ++i) {
            Integer value1 = (Integer)v1.m_components.get(i);
            Integer value2 = null;
            if (v2.m_components.size() > i) {
                value2 = (Integer)v2.m_components.get(i);
            }
            if (value2 == null) {
                return 1;
            }
            int value = value1.compareTo(value2);
            if (value == 0) continue;
            return value;
        }
        if (v2.m_components.size() > v1.m_components.size()) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        VersionString string1 = new VersionString("1.1");
        VersionString string2 = new VersionString("1.1.3");
        System.out.println(string1.compareTo(string2));
    }
}

