/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import com.sap.caf.mp.base.logging.BaseLogManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class UUIDGen {
    static long count = 1L;
    static String node = "localhost/127.0.0.1";
    static byte[] nodeBytes;
    static byte[] providerBytes;
    static /* synthetic */ Class class$com$sap$caf$mp$base$util$UUIDGen;

    static void main(String[] args) {
        byte[] uuid = UUIDGen.generateUUID();
        String uuidString = UUIDGen.getUUIDStringFromBytes(uuid, false, true);
        if (args.length > 0) {
            UUIDGen.isUuid(args[0], true);
        }
    }

    public static byte[] generateUUID() {
        ++count;
        long time = 122192928000000000L + System.currentTimeMillis() * 10000L;
        byte[] timeBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            timeBytes[i] = (byte)(time & 0xFFL);
            time >>= 8;
        }
        long countTmp = count;
        byte[] countBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            countBytes[i] = (byte)(countTmp & 0xFFL);
            countTmp >>= 8;
        }
        byte[] digestBytes = new byte[]{0};
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(timeBytes);
            md5.update(countBytes);
            md5.update(nodeBytes);
            md5.update(providerBytes);
            digestBytes = md5.digest();
            digestBytes[6] = (byte)(digestBytes[6] & 0xF | 0x30);
            digestBytes[8] = (byte)(digestBytes[8] & 0x3F | 0x80);
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        return digestBytes;
    }

    public static String getUUIDStringFromBytes(byte[] uuidBytes, boolean prefix, boolean compact) {
        StringBuffer uuid = new StringBuffer(prefix ? "uuid:" : "");
        if (uuidBytes.length == 16) {
            for (int i = 0; i < 16; ++i) {
                byte nibble = (byte)((uuidBytes[i] & 0xF0) >> 4);
                uuid.append((char)(nibble > 9 ? 65 + nibble - 10 : 48 + nibble));
                nibble = (byte)(uuidBytes[i] & 0xF);
                uuid.append((char)(nibble > 9 ? 65 + nibble - 10 : 48 + nibble));
            }
            if (!compact) {
                if (prefix) {
                    uuid.insert(25, '-');
                    uuid.insert(21, '-');
                    uuid.insert(17, '-');
                    uuid.insert(13, '-');
                } else {
                    uuid.insert(20, '-');
                    uuid.insert(16, '-');
                    uuid.insert(12, '-');
                    uuid.insert(8, '-');
                }
            }
        }
        return uuid.toString();
    }

    public static boolean isUuid(String uuid, boolean hasPrefix) {
        if (hasPrefix) {
            if (uuid.length() != 41) {
                return false;
            }
            if (!uuid.substring(0, 5).toLowerCase().equals("uuid:")) {
                return false;
            }
            uuid = uuid.substring(5);
        } else if (uuid.length() != 36) {
            return false;
        }
        for (int i = 0; i < 36; ++i) {
            char ch = uuid.charAt(i);
            if (!(i == 8 || i == 13 || i == 18 || i == 23 ? ch != '-' : !(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f'))) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            node = inet.getHostName() + "/" + inet.getHostAddress();
        }
        catch (UnknownHostException e) {
            BaseLogManager.error(class$com$sap$caf$mp$base$util$UUIDGen == null ? (class$com$sap$caf$mp$base$util$UUIDGen = UUIDGen.class$("com.sap.caf.mp.base.util.UUIDGen")) : class$com$sap$caf$mp$base$util$UUIDGen, e.getMessage());
        }
        nodeBytes = node.getBytes();
        String provider = "http://www.sap.com";
        providerBytes = provider.getBytes();
    }
}

