/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import java.text.DecimalFormat;
import java.util.Vector;

public class StringUtilities {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static int m_formatLength = 10;
    private static DecimalFormat m_format = new DecimalFormat("0000000000");

    public static String replaceString(String sString, String sOld, String sNew) {
        StringBuffer result = new StringBuffer();
        int pos = 0;
        do {
            int newpos;
            if ((newpos = sString.indexOf(sOld, pos)) == -1) {
                result.append(sString.substring(pos, sString.length()));
                pos = -1;
                continue;
            }
            result.append(sString.substring(pos, newpos));
            result.append(sNew);
            pos = newpos + sOld.length();
        } while (pos != -1);
        return result.toString();
    }

    public static String[] splitString(String sString, char cDelimiter, boolean returnEmpty) {
        String item;
        int iNum = 0;
        int iPos = 0;
        int iBefore = 0;
        Vector<String> stringList = new Vector<String>();
        String sDelimiter = String.valueOf(cDelimiter);
        iPos = sString.indexOf(sDelimiter);
        while (iPos > -1) {
            item = iNum > 0 ? sString.substring(iBefore + 1, iPos) : sString.substring(iBefore, iPos);
            if (item.length() > 0 || returnEmpty) {
                stringList.add(item);
            }
            iBefore = iPos;
            ++iNum;
            iPos = sString.indexOf(sDelimiter, iPos + 1);
        }
        item = iNum > 0 ? sString.substring(iBefore + 1, sString.length()) : sString;
        if (item.length() > 0 || returnEmpty) {
            stringList.add(item);
        }
        if (stringList.size() == 0) {
            return null;
        }
        String[] result = new String[stringList.size()];
        result = stringList.toArray(result);
        return result;
    }

    public static String marshalByteArray(byte[] input) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(m_format.format(input.length));
        for (int i = 0; i < input.length; ++i) {
            buffer.append(Byte.toString(input[i]));
        }
        return buffer.toString();
    }

    public static byte[] unmarshalByteArray(String input) {
        int length = Integer.parseInt(input.substring(0, 10));
        byte[] result = new byte[length];
        int len = 2;
        int pos = length;
        for (int i = 0; i < length; ++i) {
            result[i] = Byte.parseByte(input.substring(pos, pos + 2));
            pos += 2;
        }
        return result;
    }

    public static final String toString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[offset + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = StringUtilities.charToNibble(s.charAt(i));
            int low = StringUtilities.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }
}

