/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import com.sap.caf.mp.base.util.StringUtilities;

public class MD4Hash {
    private static final int SIZE_BLOCK_BYTES = 64;
    private static final int A = 1732584193;
    private static final int B = -271733879;
    private static final int C = -1732584194;
    private static final int D = 271733878;
    protected long count;
    protected byte[] buffer;
    private final int[] X = new int[16];
    private int a;
    private int b;
    private int c;
    private int d;

    public MD4Hash() {
        this.buffer = new byte[64];
        this.resetContext();
    }

    private byte[] getResult() {
        byte[] digest = new byte[]{(byte)this.a, (byte)(this.a >>> 8), (byte)(this.a >>> 16), (byte)(this.a >>> 24), (byte)this.b, (byte)(this.b >>> 8), (byte)(this.b >>> 16), (byte)(this.b >>> 24), (byte)this.c, (byte)(this.c >>> 8), (byte)(this.c >>> 16), (byte)(this.c >>> 24), (byte)this.d, (byte)(this.d >>> 8), (byte)(this.d >>> 16), (byte)(this.d >>> 24)};
        return digest;
    }

    private void resetContext() {
        this.a = 1732584193;
        this.b = -271733879;
        this.c = -1732584194;
        this.d = 271733878;
    }

    private void update(byte[] b, int offset, int len) {
        int n = (int)(this.count % 64L);
        this.count += (long)len;
        int partLen = 64 - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + 64 - 1 < len) {
                this.transform(b, offset + i);
                i += 64;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    private byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        byte[] result = this.getResult();
        return result;
    }

    private void reset() {
        this.count = 0L;
        int i = 0;
        while (i < 64) {
            this.buffer[i++] = 0;
        }
        this.resetContext();
    }

    private byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] pad = new byte[padding + 8];
        pad[0] = -128;
        long bits = this.count << 3;
        pad[padding++] = (byte)bits;
        pad[padding++] = (byte)(bits >>> 8);
        pad[padding++] = (byte)(bits >>> 16);
        pad[padding++] = (byte)(bits >>> 24);
        pad[padding++] = (byte)(bits >>> 32);
        pad[padding++] = (byte)(bits >>> 40);
        pad[padding++] = (byte)(bits >>> 48);
        pad[padding] = (byte)(bits >>> 56);
        return pad;
    }

    private void transform(byte[] in, int offset) {
        boolean n = false;
        for (int i = 0; i < 16; ++i) {
            this.X[i] = in[offset++] & 0xFF | (in[offset++] & 0xFF) << 8 | (in[offset++] & 0xFF) << 16 | in[offset++] << 24;
        }
        int aa = this.a;
        int bb = this.b;
        int cc = this.c;
        int dd = this.d;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[0];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[1];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[2];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[3];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[4];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[5];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[6];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[7];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[8];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[9];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[10];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[11];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & this.c | ~this.b & this.d) + this.X[12];
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & this.b | ~this.a & this.c) + this.X[13];
        this.d = this.d << 7 | this.d >>> 25;
        this.c += (this.d & this.a | ~this.d & this.b) + this.X[14];
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c & this.d | ~this.c & this.a) + this.X[15];
        this.b = this.b << 19 | this.b >>> 13;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[0] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[4] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[8] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[12] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[1] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[5] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[9] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[13] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[2] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[6] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[10] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[14] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b & (this.c | this.d) | this.c & this.d) + this.X[3] + 1518500249;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a & (this.b | this.c) | this.b & this.c) + this.X[7] + 1518500249;
        this.d = this.d << 5 | this.d >>> 27;
        this.c += (this.d & (this.a | this.b) | this.a & this.b) + this.X[11] + 1518500249;
        this.c = this.c << 9 | this.c >>> 23;
        this.b += (this.c & (this.d | this.a) | this.d & this.a) + this.X[15] + 1518500249;
        this.b = this.b << 13 | this.b >>> 19;
        this.a += (this.b ^ this.c ^ this.d) + this.X[0] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[8] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[4] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[12] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[2] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[10] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[6] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[14] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[1] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[9] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[5] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[13] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += (this.b ^ this.c ^ this.d) + this.X[3] + 1859775393;
        this.a = this.a << 3 | this.a >>> 29;
        this.d += (this.a ^ this.b ^ this.c) + this.X[11] + 1859775393;
        this.d = this.d << 9 | this.d >>> 23;
        this.c += (this.d ^ this.a ^ this.b) + this.X[7] + 1859775393;
        this.c = this.c << 11 | this.c >>> 21;
        this.b += (this.c ^ this.d ^ this.a) + this.X[15] + 1859775393;
        this.b = this.b << 15 | this.b >>> 17;
        this.a += aa;
        this.b += bb;
        this.c += cc;
        this.d += dd;
    }

    public synchronized String computeHash(byte[] data) {
        this.update(data, 0, data.length);
        byte[] digest = this.digest();
        this.reset();
        return StringUtilities.toString(digest, 0, digest.length);
    }

    public synchronized String computeHash(String input) {
        byte[] data = input.getBytes();
        this.update(data, 0, data.length);
        byte[] digest = this.digest();
        this.reset();
        return StringUtilities.toString(digest, 0, digest.length);
    }
}

