/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import com.sap.caf.mp.base.exception.EngineException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamAnalyzer {
    boolean m_isUnicode;
    ByteArrayInputStream m_byteArrayInputStream;

    public InputStreamAnalyzer(InputStream is) throws EngineException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.m_isUnicode = false;
        boolean isFirstByte = true;
        try {
            int c;
            while ((c = is.read()) > -1) {
                if (isFirstByte) {
                    this.m_isUnicode = Character.isUnicodeIdentifierStart((char)c);
                    isFirstByte = false;
                }
                bo.write(c);
                this.m_byteArrayInputStream = new ByteArrayInputStream(bo.toByteArray());
            }
        }
        catch (IOException e) {
            throw new EngineException(e);
        }
    }

    public String getEncodingSetName() {
        String encoding = "UTF-8";
        if (this.m_isUnicode) {
            encoding = "UTF-16";
        }
        return encoding;
    }

    public InputStream getInputStream() {
        return this.m_byteArrayInputStream;
    }
}

