/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class ExternalDate {
    public static final int DATEFORMAT_RFC_1123 = 0;
    public static final int DATEFORMAT_RFC_850 = 1;
    public static final int DATEFORMAT_ANSIASCTIME = 2;
    public static final int DATEFORMAT_ISO_8601 = 3;
    public static final int DATEFORMAT_R3 = 4;
    public static final int CONVERT_R3_DATE_TO_JAVA_DATE = 1;
    public static final int CONVERT_R3_TIME_TO_JAVA_DATE = 2;
    private static final int DAYOFWEEK_FORMAT_SHORT = 0;
    private static final int DAYOFWEEK_FORMAT_LONG = 1;
    private static final String[] MONTH_NAMES_SHORT = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MONTH_NAMES_LONG = new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYOFWEEK_NAMES_SHORT = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] DAYOFWEEK_NAMES_LONG = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static Hashtable m_textComponents;
    static /* synthetic */ Class class$com$sap$caf$mp$base$util$ExternalDate;

    private ExternalDate() {
    }

    private static Date parseTimeStampR3(String ts) throws InvocationException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(0L);
        try {
            int year = Integer.parseInt(ts.substring(0, 4));
            int month = Integer.parseInt(ts.substring(4, 6)) - 1;
            int day = Integer.parseInt(ts.substring(6, 8));
            int hour = Integer.parseInt(ts.substring(8, 10));
            int minute = Integer.parseInt(ts.substring(10, 12));
            int second = Integer.parseInt(ts.substring(12, 14));
            calendar.setTimeInMillis(0L);
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(year, month, day, hour, minute, second);
        }
        catch (Exception ex) {
            throw new InvocationException(ex);
        }
        return calendar.getTime();
    }

    private static Date parseTimeStampRFC1123(Vector components) throws InvocationException {
        if (components.size() != 11) {
            throw new InvocationException();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(0L);
        try {
            int day = Integer.parseInt((String)components.get(2));
            String monthString = (String)components.get(3);
            int month = (Integer)m_textComponents.get(monthString.toLowerCase()) - 1;
            int year = Integer.parseInt((String)components.get(4));
            int hour = Integer.parseInt((String)components.get(5));
            int minute = Integer.parseInt((String)components.get(7));
            int second = Integer.parseInt((String)components.get(9));
            calendar.setTimeZone(TimeZone.getTimeZone((String)components.get(10)));
            calendar.set(year, month, day, hour, minute, second);
        }
        catch (Exception ex) {
            BaseLogManager.error(class$com$sap$caf$mp$base$util$ExternalDate == null ? (class$com$sap$caf$mp$base$util$ExternalDate = ExternalDate.class$("com.sap.caf.mp.base.util.ExternalDate")) : class$com$sap$caf$mp$base$util$ExternalDate, ex);
            throw new InvocationException(ex);
        }
        return calendar.getTime();
    }

    private static Date parseTimeStampRFC850(Vector components) throws InvocationException {
        if (components.size() != 13) {
            throw new InvocationException();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(0L);
        try {
            int day = Integer.parseInt((String)components.get(2));
            String monthString = (String)components.get(4);
            int month = (Integer)m_textComponents.get(monthString.toLowerCase()) - 1;
            int year = Integer.parseInt((String)components.get(6));
            year = year < 30 ? 2000 + year : 1900 + year;
            int hour = Integer.parseInt((String)components.get(7));
            int minute = Integer.parseInt((String)components.get(9));
            int second = Integer.parseInt((String)components.get(11));
            calendar.setTimeZone(TimeZone.getTimeZone((String)components.get(12)));
            calendar.set(year, month, day, hour, minute, second);
        }
        catch (Exception ex) {
            BaseLogManager.error(class$com$sap$caf$mp$base$util$ExternalDate == null ? (class$com$sap$caf$mp$base$util$ExternalDate = ExternalDate.class$("com.sap.caf.mp.base.util.ExternalDate")) : class$com$sap$caf$mp$base$util$ExternalDate, ex);
            throw new InvocationException(ex);
        }
        return calendar.getTime();
    }

    private static Date parseTimeStampISO8601(String ts) throws InvocationException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(0L);
        try {
            int year = Integer.parseInt(ts.substring(0, 4));
            int month = Integer.parseInt(ts.substring(5, 7)) - 1;
            int day = Integer.parseInt(ts.substring(8, 10));
            int hour = Integer.parseInt(ts.substring(11, 13));
            int minute = Integer.parseInt(ts.substring(14, 16));
            int second = Integer.parseInt(ts.substring(17, 19));
            char modifier = ts.charAt(19);
            int secfrag = 0;
            int maxlength = 20;
            if (modifier == '.') {
                secfrag = Integer.parseInt(ts.substring(20, 21));
                modifier = ts.charAt(21);
                maxlength += 2;
            }
            String timeZone = "GMT";
            if (modifier == 'Z') {
                if (ts.length() != maxlength) {
                    throw new InvocationException();
                }
            } else {
                timeZone = timeZone + ts.substring(maxlength - 1);
            }
            TimeZone tz = TimeZone.getTimeZone(timeZone);
            calendar.setTimeZone(tz);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, secfrag * 100);
        }
        catch (Exception ex) {
            throw new InvocationException(ex);
        }
        return calendar.getTime();
    }

    private static Date parseTimeStampANSIASCTIME(Vector components) throws InvocationException {
        if (components.size() != 9) {
            throw new InvocationException("Unknown time stamp format.");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            int day = Integer.parseInt((String)components.get(2));
            String monthString = (String)components.get(1);
            int month = (Integer)m_textComponents.get(monthString.toLowerCase()) - 1;
            int year = Integer.parseInt((String)components.get(8));
            int hour = Integer.parseInt((String)components.get(3));
            int minute = Integer.parseInt((String)components.get(5));
            int second = Integer.parseInt((String)components.get(7));
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(year, month, day, hour, minute, second);
        }
        catch (Exception ex) {
            BaseLogManager.error(class$com$sap$caf$mp$base$util$ExternalDate == null ? (class$com$sap$caf$mp$base$util$ExternalDate = ExternalDate.class$("com.sap.caf.mp.base.util.ExternalDate")) : class$com$sap$caf$mp$base$util$ExternalDate, ex);
            throw new InvocationException("Unknown time stamp format.", ex);
        }
        return calendar.getTime();
    }

    public static Date parseTimeStamp(String ts) throws InvocationException {
        StringTokenizer tokenizer = new StringTokenizer(ts, " ,-:+", true);
        Vector<String> components = new Vector<String>();
        int commaCount = 0;
        int colonCount = 0;
        int hyphenCount = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals(" ")) {
                components.add(token);
            }
            if (token.equals(":")) {
                ++colonCount;
                continue;
            }
            if (token.equals(",")) {
                ++commaCount;
                continue;
            }
            if (!token.equals("-")) continue;
            ++hyphenCount;
        }
        if (components.size() == 1) {
            return ExternalDate.parseTimeStampR3(ts);
        }
        if (commaCount == 1 && colonCount == 2 && hyphenCount == 0) {
            return ExternalDate.parseTimeStampRFC1123(components);
        }
        if (commaCount == 1 && colonCount == 2 && hyphenCount == 2) {
            return ExternalDate.parseTimeStampRFC850(components);
        }
        if (commaCount == 0 && colonCount == 2 && hyphenCount == 0) {
            return ExternalDate.parseTimeStampANSIASCTIME(components);
        }
        return ExternalDate.parseTimeStampISO8601(ts);
    }

    public static String buildTimeStampR3(Date ts) {
        return ExternalDate.buildTimeStampR3(ts, "GMT");
    }

    public static String buildTimeStampR3(Date ts, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ts);
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        StringBuffer result = new StringBuffer();
        result.append(calendar.get(1));
        int value = calendar.get(2) + 1;
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        value = calendar.get(5);
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        return result.toString();
    }

    public static String buildTimeStampRFC1123(Date ts) {
        return ExternalDate.buildTimeStampRFC1123(ts, "GMT");
    }

    public static String buildTimeStampRFC1123(Date ts, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ts);
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        StringBuffer result = new StringBuffer();
        int value = calendar.get(7) - 1;
        result.append(DAYOFWEEK_NAMES_SHORT[value]);
        result.append(", ");
        value = calendar.get(5);
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        result.append(" ");
        value = calendar.get(2);
        result.append(MONTH_NAMES_SHORT[value]);
        result.append(" ");
        value = calendar.get(1);
        result.append(value);
        result.append(" ");
        value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(" ");
        result.append(timeZone);
        return result.toString();
    }

    public static String buildTimeStampRFC850(Date ts) {
        return ExternalDate.buildTimeStampRFC850(ts, "GMT");
    }

    public static String buildTimeStampRFC850(Date ts, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ts);
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        StringBuffer result = new StringBuffer();
        int value = calendar.get(7) - 1;
        result.append(DAYOFWEEK_NAMES_LONG[value]);
        result.append(", ");
        value = calendar.get(5);
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        result.append("-");
        value = calendar.get(2);
        result.append(MONTH_NAMES_SHORT[value]);
        result.append("-");
        value = calendar.get(1);
        String yearval = Integer.toString(value);
        result.append(yearval.substring(2, 4));
        result.append(" ");
        value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(" ");
        result.append(timeZone);
        return result.toString();
    }

    public static String buildTimeStampANSIASCTIME(Date ts) {
        return ExternalDate.buildTimeStampANSIASCTIME(ts, "GMT");
    }

    public static String buildTimeStampANSIASCTIME(Date ts, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ts);
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        StringBuffer result = new StringBuffer();
        int value = calendar.get(7) - 1;
        result.append(DAYOFWEEK_NAMES_SHORT[value]);
        result.append(" ");
        value = calendar.get(2);
        result.append(MONTH_NAMES_SHORT[value]);
        result.append(" ");
        value = calendar.get(5);
        if (value < 10) {
            result.append(" ");
        }
        result.append(value);
        result.append(" ");
        value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(" ");
        value = calendar.get(1);
        result.append(value);
        return result.toString();
    }

    public static String buildTimeStampISO8601(Calendar cal, boolean includeFragment, boolean timeZoneUTC) {
        Calendar calendar = (Calendar)cal.clone();
        if (timeZoneUTC) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        StringBuffer result = new StringBuffer();
        int value = calendar.get(1);
        result.append(value);
        result.append("-");
        value = calendar.get(2) + 1;
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        result.append("-");
        value = calendar.get(5);
        if (value < 10) {
            result.append(" ");
        }
        result.append(value);
        result.append("T");
        value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        result.append(":");
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        int secfrag = calendar.get(14) / 100;
        result.append(".");
        result.append(secfrag);
        if (calendar.getTimeZone().getID().equals("GMT")) {
            result.append("Z");
        } else {
            int off = (calendar.get(16) + calendar.get(15)) / 1000;
            int houroff = off / 3600;
            if (houroff > 0) {
                result.append("+");
            }
            result.append(houroff);
            result.append(":");
            int minuteoff = (off - houroff * 3600) / 60;
            if (minuteoff < 0) {
                minuteoff *= -1;
            }
            if (minuteoff < 10) {
                result.append("0");
            }
            result.append(minuteoff);
        }
        return result.toString();
    }

    public static String buildR3Date(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer result = new StringBuffer();
        result.append(calendar.get(1));
        int value = calendar.get(2) + 1;
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        value = calendar.get(5);
        if (value < 10) {
            result.append("0");
        }
        result.append(value);
        return result.toString();
    }

    public static String buildR3Time(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer result = new StringBuffer();
        int value = calendar.get(11);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        value = calendar.get(12);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        value = calendar.get(13);
        if (value == 0) {
            result.append("00");
        } else if (value < 10) {
            result.append("0");
            result.append(value);
        } else {
            result.append(value);
        }
        return result.toString();
    }

    public static void checkR3Time(String time, Locale locale) throws InvocationException {
        if (time.length() != 8) {
            throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_LENGTH", locale));
        }
        for (int i = 0; i < time.length(); ++i) {
            char hour;
            char current = time.charAt(i);
            if (i != 2 && i != 5) {
                if (current < '0' || current > '9') {
                    throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_ONLY_NUMBERS", locale));
                }
            } else if (current != ':') {
                throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_SEPARATOR", locale));
            }
            if (i == 0 && current > '2') {
                throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_24_HOURS_IN_DAY", locale));
            }
            if (i == 1 && (hour = time.charAt(i - 1)) == '2' && current > '4') {
                throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_24_HOURS_IN_DAY", locale));
            }
            if (i != 3 && i != 6 || current <= '5' && current >= '0') continue;
            if (i == 3) {
                char minutes = time.charAt(i + 1);
                if (current == '6' && minutes == '0') {
                    throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_MINUTE_60", locale));
                }
                throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_MINUTE", locale));
            }
            if (i != 6) continue;
            char seconds = time.charAt(i + 1);
            if (current == '6' && seconds == '0') {
                throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_SECOND_60", locale));
            }
            throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_INVALID_SECOND", locale));
        }
    }

    public static Date buildJavaDate(String dateTimeR3, int conversionType, Locale locale) throws InvocationException {
        if (dateTimeR3 == null) {
            throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_DATE_NULL", locale));
        }
        if (conversionType != 1 && conversionType != 2) {
            throw new InvocationException(BaseResourceHandler.getString("ExternalDate.ERROR_R3CHECK_NO_DATA", locale));
        }
        Date javaDate = null;
        if (conversionType == 1) {
            StringTokenizer divideR3Date = new StringTokenizer(dateTimeR3, "-", false);
            String yearString = "0";
            String monthString = "0";
            String dayString = "0";
            int i = 0;
            while (divideR3Date.hasMoreTokens()) {
                if (i == 0) {
                    yearString = divideR3Date.nextToken();
                }
                if (i == 1) {
                    monthString = divideR3Date.nextToken();
                }
                if (i == 2) {
                    dayString = divideR3Date.nextToken();
                }
                ++i;
            }
            int yearInt = Integer.parseInt(yearString);
            int monthInt = Integer.parseInt(monthString);
            int dayInt = Integer.parseInt(dayString);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(yearInt, monthInt - 1, dayInt);
            javaDate = calendar.getTime();
            return javaDate;
        }
        if (conversionType == 2) {
            ExternalDate.checkR3Time(dateTimeR3, locale);
            StringTokenizer divideR3Date = new StringTokenizer(dateTimeR3, ":", false);
            String hoursString = "0";
            String minutesString = "0";
            String secondsString = "0";
            int i = 0;
            while (divideR3Date.hasMoreTokens()) {
                if (i == 0) {
                    hoursString = divideR3Date.nextToken();
                }
                if (i == 1) {
                    minutesString = divideR3Date.nextToken();
                }
                if (i == 2) {
                    secondsString = divideR3Date.nextToken();
                }
                ++i;
            }
            int hoursInt = Integer.parseInt(hoursString);
            int minutesInt = Integer.parseInt(minutesString);
            int secondsInt = Integer.parseInt(secondsString);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.set(1979, 2, 2, hoursInt - 1, minutesInt, secondsInt);
            javaDate = calendar.getTime();
            return javaDate;
        }
        return javaDate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Integer dayofweekShort = new Integer(0);
        Integer dayofweekLong = new Integer(1);
        m_textComponents = new Hashtable();
        m_textComponents.put("mon", dayofweekShort);
        m_textComponents.put("tue", dayofweekShort);
        m_textComponents.put("wed", dayofweekShort);
        m_textComponents.put("thu", dayofweekShort);
        m_textComponents.put("fri", dayofweekShort);
        m_textComponents.put("sat", dayofweekShort);
        m_textComponents.put("sun", dayofweekShort);
        m_textComponents.put("monday", dayofweekLong);
        m_textComponents.put("tuesday", dayofweekLong);
        m_textComponents.put("wednesday", dayofweekLong);
        m_textComponents.put("thursday", dayofweekLong);
        m_textComponents.put("friday", dayofweekLong);
        m_textComponents.put("saturday", dayofweekLong);
        m_textComponents.put("sunday", dayofweekLong);
        m_textComponents.put("jan", new Integer(1));
        m_textComponents.put("feb", new Integer(2));
        m_textComponents.put("mar", new Integer(3));
        m_textComponents.put("apr", new Integer(4));
        m_textComponents.put("may", new Integer(5));
        m_textComponents.put("jun", new Integer(6));
        m_textComponents.put("jul", new Integer(7));
        m_textComponents.put("aug", new Integer(8));
        m_textComponents.put("sep", new Integer(9));
        m_textComponents.put("oct", new Integer(10));
        m_textComponents.put("nov", new Integer(11));
        m_textComponents.put("dec", new Integer(12));
        m_textComponents.put("january", new Integer(1));
        m_textComponents.put("febuary", new Integer(2));
        m_textComponents.put("march", new Integer(3));
        m_textComponents.put("april", new Integer(4));
        m_textComponents.put("may", new Integer(5));
        m_textComponents.put("june", new Integer(6));
        m_textComponents.put("july", new Integer(7));
        m_textComponents.put("august", new Integer(8));
        m_textComponents.put("september", new Integer(9));
        m_textComponents.put("october", new Integer(10));
        m_textComponents.put("november", new Integer(11));
        m_textComponents.put("december", new Integer(12));
    }
}

