/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ByteArray {
    private static final int CHUNK_SIZE = 8192;
    private int m_length = 0;
    private byte[] m_content = new byte[8192];

    public ByteArray() {
    }

    public ByteArray(InputStream stream) throws IOException {
        this();
        if (stream == null) {
            return;
        }
        int read = -1;
        byte[] buffer = new byte[8192];
        do {
            if ((read = stream.read(buffer, 0, 8192)) <= -1) continue;
            this.appendBytes(buffer, read);
        } while (read != -1);
    }

    public ByteArray(InputStream stream, long length) throws IOException {
        this();
        if (stream == null) {
            return;
        }
        int read = -1;
        long toRead = 0L;
        byte[] buffer = new byte[8192];
        do {
            if ((toRead = length - (long)this.m_length) > 8192L) {
                toRead = 8192L;
            }
            if ((read = stream.read(buffer, 0, (int)toRead)) <= -1) continue;
            this.appendBytes(buffer, read);
        } while (read != -1 && toRead != 0L);
        if ((long)this.m_length != length) {
            throw new IOException();
        }
    }

    public void appendBytes(byte[] bytes, int length) {
        int newSize = this.m_length + length;
        if (newSize > this.m_content.length) {
            newSize = this.m_content.length + 8192;
            byte[] temp = new byte[this.m_length];
            System.arraycopy(this.m_content, 0, temp, 0, this.m_length);
            this.m_content = new byte[newSize];
            System.arraycopy(temp, 0, this.m_content, 0, this.m_length);
        }
        if (this.m_length > 0) {
            System.arraycopy(bytes, 0, this.m_content, this.m_length, length);
        } else {
            System.arraycopy(bytes, 0, this.m_content, 0, length);
        }
        this.m_length += length;
    }

    public void appendBytes(byte[] bytes) {
        this.appendBytes(bytes, bytes.length);
    }

    public int getLength() {
        return this.m_length;
    }

    public byte[] toByteArray(boolean adjust) {
        if (this.m_length == 0) {
            return null;
        }
        if (this.m_content.length != this.m_length && adjust) {
            byte[] result = new byte[this.m_length];
            System.arraycopy(this.m_content, 0, result, 0, this.m_length);
            this.m_content = result;
        }
        return this.m_content;
    }

    public String convertToString(String encoding) throws UnsupportedEncodingException {
        if (this.m_length == 0) {
            return "";
        }
        return new String(this.m_content, 0, this.m_length, encoding);
    }
}

