/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.text;

import com.sap.caf.mp.base.text.TitleText;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class TitleTextList {
    private static final String FALLBACK_LANGUAGE = "en";
    private Hashtable m_texts = new Hashtable();
    private String m_fallbackLanguage;
    private String m_masterLanguage;

    public TitleTextList() {
        this.m_fallbackLanguage = FALLBACK_LANGUAGE;
        this.m_masterLanguage = FALLBACK_LANGUAGE;
    }

    public TitleTextList(String masterLanguage, String fallbackLanguage) {
        this.m_masterLanguage = masterLanguage;
        this.m_fallbackLanguage = fallbackLanguage;
    }

    public void addTitleText(TitleText text) {
        this.m_texts.put(text.getLanguage(), text);
    }

    public void addTitleText(String language, String text) {
        this.m_texts.put(language, new TitleText(language, text));
    }

    public Enumeration elements() {
        return this.m_texts.elements();
    }

    public int size() {
        return this.m_texts.size();
    }

    public TitleText resolveText(Locale locale) {
        return this.resolveText(locale.getLanguage());
    }

    public TitleText resolveText(String language) {
        TitleText text = (TitleText)this.m_texts.get(language);
        if (text != null) {
            return text;
        }
        text = (TitleText)this.m_texts.get(this.m_fallbackLanguage);
        if (text != null) {
            return text;
        }
        text = (TitleText)this.m_texts.get(this.m_masterLanguage);
        if (text != null) {
            return text;
        }
        Enumeration enumeration = this.m_texts.elements();
        if (enumeration.hasMoreElements()) {
            return (TitleText)enumeration.nextElement();
        }
        return null;
    }

    public TitleText getText(String language) {
        return (TitleText)this.m_texts.get(language);
    }

    public String getMasterLanguage() {
        return this.m_masterLanguage;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("TitleTextList, masterLang=" + this.m_masterLanguage);
        Enumeration enumeration = this.m_texts.elements();
        while (enumeration.hasMoreElements()) {
            TitleText text = (TitleText)enumeration.nextElement();
            result.append(", [" + text.getLanguage() + "] " + text.getText());
        }
        return result.toString();
    }
}

