/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.machine;

import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import com.sap.caf.mp.base.swift.exception.StackMachineRuntimeException;
import com.sap.caf.mp.base.swift.fields.DataFields;
import com.sap.caf.mp.base.swift.machine.DataFieldController;
import com.sap.caf.mp.base.swift.machine.StackMachineCommand;
import com.sap.caf.mp.base.swift.machine.StackMachineProgram;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Stack;

public class StackMachine {
    public static final String VALUE_BOOLEAN_TRUE = "1";
    public static final String VALUE_BOOLEAN_FALSE = "0";
    private Stack m_stack = new Stack();
    private StackMachineProgram m_program;
    private long m_runtime = -1L;
    private Stack m_blockStack = new Stack();
    private DataFieldController m_fieldController = null;
    private Locale m_locale;
    static /* synthetic */ Class class$com$sap$caf$mp$base$swift$machine$StackMachine;

    public StackMachine(Locale locale) {
        this.m_locale = locale;
    }

    private StackMachineRuntimeException constructRuntimeException(StackMachineCommand cmd, String msg, Exception ex) {
        StackMachineRuntimeException exc = new StackMachineRuntimeException(msg + " [VM Command: " + cmd.toString() + "]", ex);
        return exc;
    }

    private int executeCommandFormatUrl(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String oper = (String)this.m_stack.pop();
            oper = URLEncoder.encode(oper, "UTF-8");
            this.m_stack.push(oper);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandFormatJS(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String oper = (String)this.m_stack.pop();
            StringBuffer res = new StringBuffer();
            block7: for (int i = 0; i < oper.length(); ++i) {
                char ch = oper.charAt(i);
                switch (ch) {
                    case '\"': {
                        res.append("\\\"");
                        continue block7;
                    }
                    case '\'': {
                        res.append("\\'");
                        continue block7;
                    }
                    case '\\': {
                        res.append("\\\\");
                        continue block7;
                    }
                    default: {
                        res.append(ch);
                    }
                }
            }
            this.m_stack.push(res);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLen(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String oper = (String)this.m_stack.pop();
            String len = Integer.toString(oper.length());
            this.m_stack.push(len);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandNot(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String oper = (String)this.m_stack.pop();
            if (oper.equals(VALUE_BOOLEAN_FALSE)) {
                this.m_stack.push(VALUE_BOOLEAN_TRUE);
            } else {
                this.m_stack.push(VALUE_BOOLEAN_FALSE);
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoopIndex(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_stack.push(Integer.toString(this.m_fieldController.getCurrentLoopIdx()));
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoopInit(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_fieldController.pushLoop();
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoopField(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String name = (String)this.m_stack.pop();
            this.m_fieldController.addLoopField(name);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoopCheck(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            if (this.m_fieldController.hasMoreLoops()) {
                this.m_stack.push(VALUE_BOOLEAN_TRUE);
            } else {
                this.m_stack.push(VALUE_BOOLEAN_FALSE);
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoopFinalize(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_fieldController.popLoop();
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandBlockStart(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_blockStack.push(cmd.m_arg);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandBlockEnd(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_blockStack.pop();
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandBreak(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            if (!this.m_blockStack.isEmpty()) {
                String label = (String)this.m_blockStack.pop();
                line = this.m_program.getTargetAddress(label);
                this.m_blockStack.push(label);
            } else {
                ++line;
            }
            return line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandStop(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            line = this.m_program.getCommandCount();
            return line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandJump(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            line = this.m_program.getTargetAddress(cmd.m_arg);
            return line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandJumpConditional(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String value = (String)this.m_stack.pop();
            line = value.equals(VALUE_BOOLEAN_TRUE) ? this.m_program.getTargetAddress(cmd.m_arg) : ++line;
            return line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandClear(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String name = (String)this.m_stack.pop();
            fields.clear(name);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandRemove(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String name = (String)this.m_stack.pop();
            this.m_fieldController.removeValue(name);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandExists(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String name = (String)this.m_stack.pop();
            if (fields.getExists(name)) {
                this.m_stack.push(VALUE_BOOLEAN_TRUE);
            } else {
                this.m_stack.push(VALUE_BOOLEAN_FALSE);
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandCount(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String name = (String)this.m_stack.pop();
            this.m_stack.push(Integer.toString(fields.getCount(name)));
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandPushLiteral(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            this.m_stack.push(cmd.m_arg);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandPrint(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line, boolean crlf) throws StackMachineRuntimeException {
        try {
            String value = (String)this.m_stack.pop();
            result.append(value);
            if (crlf) {
                result.append("\r\n");
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandStore(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String value = (String)this.m_stack.pop();
            String fieldName = (String)this.m_stack.pop();
            this.m_fieldController.setValue(fieldName, value);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandAppend(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String value = (String)this.m_stack.pop();
            String fieldName = (String)this.m_stack.pop();
            fields.addValue(fieldName, value);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandCompare(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String rightOperandVal = (String)this.m_stack.pop();
            String leftOperandVal = (String)this.m_stack.pop();
            int leftOperand = 0;
            boolean leftIsInt = true;
            if (leftOperandVal.length() > 0) {
                try {
                    leftOperand = Integer.parseInt(leftOperandVal);
                }
                catch (NumberFormatException ex) {
                    leftIsInt = false;
                }
            }
            int rightOperand = 0;
            boolean rightIsInt = true;
            if (rightOperandVal.length() > 0) {
                try {
                    rightOperand = Integer.parseInt(rightOperandVal);
                }
                catch (NumberFormatException ex) {
                    rightIsInt = false;
                }
            }
            boolean value = false;
            switch (cmd.m_op) {
                case 40: {
                    value = leftOperandVal.equals(rightOperandVal);
                    break;
                }
                case 45: {
                    value = !leftOperandVal.equals(rightOperandVal);
                    break;
                }
                case 44: {
                    if (!leftIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_LEFT_OPERAND_NO_NUMBER", this.m_locale), leftOperandVal), null);
                    }
                    if (!rightIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_RIGHT_OPERAND_NO_NUMBER", this.m_locale), rightOperandVal), null);
                    }
                    value = leftOperand >= rightOperand;
                    break;
                }
                case 42: {
                    if (!leftIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_LEFT_OPERAND_NO_NUMBER", this.m_locale), leftOperandVal), null);
                    }
                    if (!rightIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_RIGHT_OPERAND_NO_NUMBER", this.m_locale), rightOperandVal), null);
                    }
                    value = leftOperand > rightOperand;
                    break;
                }
                case 41: {
                    if (!leftIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_LEFT_OPERAND_NO_NUMBER", this.m_locale), leftOperandVal), null);
                    }
                    if (!rightIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_RIGHT_OPERAND_NO_NUMBER", this.m_locale), rightOperandVal), null);
                    }
                    value = leftOperand < rightOperand;
                    break;
                }
                case 43: {
                    if (!leftIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_LEFT_OPERAND_NO_NUMBER", this.m_locale), leftOperandVal), null);
                    }
                    if (!rightIsInt) {
                        throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_RIGHT_OPERAND_NO_NUMBER", this.m_locale), rightOperandVal), null);
                    }
                    boolean bl = value = leftOperand <= rightOperand;
                }
            }
            if (value) {
                this.m_stack.push(VALUE_BOOLEAN_TRUE);
            } else {
                this.m_stack.push(VALUE_BOOLEAN_FALSE);
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandAdd(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String rightOperandVal = (String)this.m_stack.pop();
            String leftOperandVal = (String)this.m_stack.pop();
            int leftOperand = 0;
            boolean leftIsInteger = true;
            if (leftOperandVal.length() > 0) {
                try {
                    leftOperand = Integer.parseInt(leftOperandVal);
                }
                catch (NumberFormatException ex) {
                    leftIsInteger = false;
                }
            }
            int rightOperand = 0;
            boolean rightIsInteger = true;
            if (rightOperandVal.length() > 0) {
                try {
                    rightOperand = Integer.parseInt(rightOperandVal);
                }
                catch (NumberFormatException ex) {
                    rightIsInteger = false;
                }
            }
            if (leftIsInteger && rightIsInteger) {
                this.m_stack.push(Integer.toString(leftOperand + rightOperand));
            } else {
                this.m_stack.push(leftOperandVal + rightOperandVal);
            }
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandMath(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String rightOperandVal = (String)this.m_stack.pop();
            String leftOperandVal = (String)this.m_stack.pop();
            int leftOperand = 0;
            if (leftOperandVal.length() > 0) {
                try {
                    leftOperand = Integer.parseInt(leftOperandVal);
                }
                catch (Exception ex) {
                    throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_OPERAND_NO_INTEGER", this.m_locale), leftOperandVal), ex);
                }
            }
            int rightOperand = 0;
            if (rightOperandVal.length() > 0) {
                try {
                    rightOperand = Integer.parseInt(rightOperandVal);
                }
                catch (Exception ex) {
                    throw this.constructRuntimeException(cmd, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_OPERAND_NO_INTEGER", this.m_locale), rightOperandVal), ex);
                }
            }
            int value = 0;
            switch (cmd.m_op) {
                case 30: {
                    value = leftOperand + rightOperand;
                    break;
                }
                case 31: {
                    value = leftOperand - rightOperand;
                    break;
                }
                case 32: {
                    value = leftOperand * rightOperand;
                    break;
                }
                case 33: {
                    value = leftOperand / rightOperand;
                    break;
                }
                case 34: {
                    value = leftOperand % rightOperand;
                }
            }
            this.m_stack.push(Integer.toString(value));
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommandLoad(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        try {
            String value = this.m_fieldController.getValue(cmd.m_arg);
            this.m_stack.push(value);
            return ++line;
        }
        catch (Exception ex) {
            throw this.constructRuntimeException(cmd, BaseResourceHandler.getString("StackMachine.ERROR_FORM_EXECUTION", this.m_locale), ex);
        }
    }

    private int executeCommand(StackMachineCommand cmd, DataFields fields, StringBuffer result, int line) throws StackMachineRuntimeException {
        switch (cmd.m_op) {
            case 70: {
                return this.executeCommandBreak(cmd, fields, result, line);
            }
            case 80: {
                return this.executeCommandStop(cmd, fields, result, line);
            }
            case 71: {
                return this.executeCommandBlockStart(cmd, fields, result, line);
            }
            case 72: {
                return this.executeCommandBlockEnd(cmd, fields, result, line);
            }
            case 1: {
                return this.executeCommandLoad(cmd, fields, result, line);
            }
            case 30: {
                return this.executeCommandAdd(cmd, fields, result, line);
            }
            case 31: {
                return this.executeCommandMath(cmd, fields, result, line);
            }
            case 32: {
                return this.executeCommandMath(cmd, fields, result, line);
            }
            case 33: {
                return this.executeCommandMath(cmd, fields, result, line);
            }
            case 34: {
                return this.executeCommandMath(cmd, fields, result, line);
            }
            case 40: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 45: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 41: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 43: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 42: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 44: {
                return this.executeCommandCompare(cmd, fields, result, line);
            }
            case 15: {
                return this.executeCommandStore(cmd, fields, result, line);
            }
            case 20: {
                return this.executeCommandPrint(cmd, fields, result, line, false);
            }
            case 21: {
                return this.executeCommandPrint(cmd, fields, result, line, true);
            }
            case 2: {
                return this.executeCommandPushLiteral(cmd, fields, result, line);
            }
            case 14: {
                return this.executeCommandCount(cmd, fields, result, line);
            }
            case 16: {
                return this.executeCommandExists(cmd, fields, result, line);
            }
            case 19: {
                return this.executeCommandAppend(cmd, fields, result, line);
            }
            case 18: {
                return this.executeCommandRemove(cmd, fields, result, line);
            }
            case 17: {
                return this.executeCommandClear(cmd, fields, result, line);
            }
            case 60: {
                return this.executeCommandJump(cmd, fields, result, line);
            }
            case 61: {
                return this.executeCommandJumpConditional(cmd, fields, result, line);
            }
            case 94: {
                return this.executeCommandLoopInit(cmd, fields, result, line);
            }
            case 92: {
                return this.executeCommandLoopField(cmd, fields, result, line);
            }
            case 90: {
                return this.executeCommandLoopCheck(cmd, fields, result, line);
            }
            case 95: {
                return this.executeCommandLoopFinalize(cmd, fields, result, line);
            }
            case 93: {
                return this.executeCommandLoopIndex(cmd, fields, result, line);
            }
            case 50: {
                return this.executeCommandNot(cmd, fields, result, line);
            }
            case 101: {
                return this.executeCommandLen(cmd, fields, result, line);
            }
            case 111: {
                return this.executeCommandFormatUrl(cmd, fields, result, line);
            }
        }
        BaseLogManager.warn(class$com$sap$caf$mp$base$swift$machine$StackMachine == null ? (class$com$sap$caf$mp$base$swift$machine$StackMachine = StackMachine.class$("com.sap.caf.mp.base.swift.machine.StackMachine")) : class$com$sap$caf$mp$base$swift$machine$StackMachine, MessageFormat.format(BaseResourceHandler.getString("StackMachine.ERROR_UNKNOWN_COMMAND", this.m_locale), cmd.toString()));
        return ++line;
    }

    public StringBuffer executeProgram(StackMachineProgram prg, DataFields fields, StringBuffer buffer) throws StackMachineRuntimeException {
        this.m_runtime = -1L;
        long start = System.currentTimeMillis();
        this.m_program = prg;
        this.m_fieldController = new DataFieldController(fields);
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        if (prg.m_lineCount == 0) {
            return buffer;
        }
        int nextLine = 0;
        int lastLine = prg.m_lineCount - 1;
        while (nextLine <= lastLine) {
            StackMachineCommand cmd = (StackMachineCommand)prg.m_operations.get(nextLine);
            nextLine = this.executeCommand(cmd, fields, buffer, nextLine);
        }
        long end = System.currentTimeMillis();
        this.m_runtime = end - start;
        return buffer;
    }

    public long getRunTime() {
        return this.m_runtime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StackEntry {
        private String m_value;

        public StackEntry(String value) {
            this.m_value = value;
        }
    }
}

