/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.machine;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.swift.fields.DataField;
import com.sap.caf.mp.base.swift.fields.DataFields;
import java.util.Enumeration;
import java.util.Hashtable;

public class LoopStatementController {
    private int m_loopIndex;
    private DataFields m_fields;
    private Hashtable m_loopFields;

    public LoopStatementController(DataFields fields) {
        this.m_fields = fields;
        this.m_loopIndex = -1;
        this.m_loopFields = new Hashtable();
    }

    public void addLoopField(String name) {
        DataField field = this.m_fields.createField(name);
        this.m_loopFields.put(name, field);
    }

    public boolean containsField(String name) {
        return this.m_loopFields.containsKey(name);
    }

    public int getLoopIndex() {
        return this.m_loopIndex + 1;
    }

    private int getMaxLoops() {
        int max = 0;
        Enumeration enumeration = this.m_loopFields.elements();
        while (enumeration.hasMoreElements()) {
            DataField fld = (DataField)enumeration.nextElement();
            if (fld.getCount() <= max) continue;
            max = fld.getCount();
        }
        return max;
    }

    public boolean moreLoops() {
        int max = this.getMaxLoops();
        return max - 1 > this.m_loopIndex;
    }

    public void increment() {
        ++this.m_loopIndex;
    }

    public String getValue(String name) {
        DataField fld = (DataField)this.m_loopFields.get(name);
        if (fld == null) {
            return "";
        }
        if (this.m_loopIndex < fld.getCount()) {
            return fld.getValue(this.m_loopIndex);
        }
        return "";
    }

    public void setCurrentValue(String name, String value) throws InvocationException {
        DataField fld = (DataField)this.m_loopFields.get(name);
        if (fld == null) {
            return;
        }
        if (this.m_loopIndex < fld.getCount()) {
            fld.setValue(value, this.m_loopIndex);
        }
    }

    public void removeCurrentValue(String name) throws InvocationException {
        DataField fld = (DataField)this.m_loopFields.get(name);
        if (fld == null) {
            return;
        }
        if (this.m_loopIndex < fld.getCount()) {
            fld.removeValue(this.m_loopIndex);
        }
    }
}

