/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.form;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import com.sap.caf.mp.base.swift.form.IFormReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class FormReaderFileSystem
implements IFormReader {
    public static final String PREFIX_READER = "file";

    public String readForm(String uri, Locale locale) throws EngineException {
        try {
            File file = new File(uri);
            FileInputStream stream = new FileInputStream(file);
            return this.readResourceContent(stream, locale);
        }
        catch (Exception ex) {
            throw new EngineException(ex);
        }
    }

    protected String readResourceContent(InputStream stream, Locale locale) throws EngineException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[2048];
            int read = -1;
            do {
                if ((read = reader.read(chars)) == -1) continue;
                buffer.append(chars, 0, read);
            } while (read != -1);
            return buffer.toString();
        }
        catch (Exception ex) {
            throw new EngineException(BaseResourceHandler.getString("FormReaderFileSystem.ERROR_READ_FORM", locale), ex);
        }
    }
}

