/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.fields;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.swift.fields.DataField;
import java.util.Hashtable;

public class DataFields {
    private Hashtable m_fields = new Hashtable();

    private DataField getField(String name, boolean create) {
        DataField fld = (DataField)this.m_fields.get(name);
        if (fld == null && create) {
            fld = new DataField(name);
            this.m_fields.put(name, fld);
        }
        return fld;
    }

    public String getValue(String name) {
        DataField fld = this.getField(name, false);
        if (fld == null) {
            return "";
        }
        return fld.getValue();
    }

    public String getValue(String name, int idx) {
        DataField fld = this.getField(name, false);
        if (fld == null) {
            return "";
        }
        return fld.getValue(idx);
    }

    public void setValue(String name, String value, int idx) throws InvocationException {
        DataField fld = this.getField(name, true);
        fld.setValue(value, idx);
    }

    public void addValue(String name, String value) {
        DataField fld = this.getField(name, true);
        fld.addValue(value);
    }

    public DataField createField(String name) {
        DataField fld = this.getField(name, true);
        return fld;
    }

    public void setValue(String name, String value) {
        DataField fld = this.getField(name, true);
        fld.setValue(value);
    }

    public void removeValue(String name, int idx) throws InvocationException {
        DataField fld = this.getField(name, true);
        fld.removeValue(idx);
    }

    public void clear(String name) {
        DataField fld = this.getField(name, true);
        fld.clear();
    }

    public int getCount(String name) {
        DataField fld = this.getField(name, false);
        if (fld == null) {
            return 0;
        }
        return fld.getCount();
    }

    public boolean getExists(String name) {
        DataField fld = this.getField(name, false);
        if (fld == null) {
            return false;
        }
        return fld.getCount() > 0;
    }

    public DataField getField(String name) {
        return this.getField(name, false);
    }
}

