/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.fields;

import com.sap.caf.mp.base.exception.InvocationException;
import java.util.Enumeration;
import java.util.Vector;

public class DataField {
    public static final String FIELD_VALUE_EMPTY = "";
    protected String m_name;
    protected Vector m_values;

    public DataField(String name) {
        this.m_name = name;
        this.m_values = new Vector();
    }

    public DataField(String name, String value) {
        this.m_name = name;
        this.m_values = new Vector();
        this.m_values.add(value);
    }

    public DataField(DataField fld) {
        this.m_values = new Vector();
        this.m_name = fld.m_name;
        Enumeration enumeration = fld.m_values.elements();
        while (enumeration.hasMoreElements()) {
            this.m_values.add(enumeration.nextElement());
        }
    }

    public String getValue() {
        if (this.m_values.size() == 0) {
            return FIELD_VALUE_EMPTY;
        }
        return (String)this.m_values.get(0);
    }

    public String getValue(int idx) {
        String result = (String)this.m_values.get(idx);
        if (result == null) {
            return FIELD_VALUE_EMPTY;
        }
        return result;
    }

    public void setValue(String value, int idx) throws InvocationException {
        if (idx > this.m_values.size() - 1) {
            throw new InvocationException("Index out of bounds.");
        }
        this.m_values.set(idx, value);
    }

    public void addValue(String value) {
        this.m_values.add(value);
    }

    public void setValue(String value) {
        if (this.m_values.size() > 0) {
            try {
                this.setValue(value, 0);
            }
            catch (InvocationException invocationException) {}
        } else {
            this.addValue(value);
        }
    }

    public void removeValue(int idx) throws InvocationException {
        if (idx > this.m_values.size() - 1) {
            throw new InvocationException("Index out of bounds.");
        }
        this.m_values.remove(idx);
    }

    public void clear() {
        this.m_values = new Vector();
    }

    public int getCount() {
        return this.m_values.size();
    }

    public String getName() {
        return this.m_name;
    }
}

