/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.compiler;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import com.sap.caf.mp.base.swift.exception.FormCompilerException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class FormTokenizer {
    public static final int TOKEN_TYPE_STREAM = 0;
    public static final int TOKEN_IDENTIFIER = 1;
    public static final int TOKEN_NUMBER = 2;
    public static final int TOKEN_LITERAL = 3;
    public static final int TOKEN_COLON = 4;
    public static final int TOKEN_BRACKETS_OPEN = 5;
    public static final int TOKEN_BRACKETS_CLOSE = 6;
    public static final int TOKEN_EQUALS = 7;
    public static final int TOKEN_BLOCK_OPEN = 8;
    public static final int TOKEN_BLOCK_CLOSE = 9;
    public static final int TOKEN_KEYWORD_EVALUATE = 12;
    public static final int TOKEN_KEYWORD_EXISTS = 13;
    public static final int TOKEN_KEYWORD_COUNT = 16;
    public static final int TOKEN_KEYWORD_PRINT = 14;
    public static final int TOKEN_KEYWORD_PRINTLINE = 15;
    public static final int TOKEN_KEYWORD_IF = 20;
    public static final int TOKEN_KEYWORD_ELSE = 22;
    public static final int TOKEN_KEYWORD_CASE = 30;
    public static final int TOKEN_KEYWORD_SWITCH = 31;
    public static final int TOKEN_KEYWORD_DEFAULT = 32;
    public static final int TOKEN_KEYWORD_WHILE = 35;
    public static final int TOKEN_KEYWORD_LOOP = 40;
    public static final int TOKEN_KEYWORD_LOOPIDX = 41;
    public static final int TOKEN_KEYWORD_CODEXML = 60;
    public static final int TOKEN_KEYWORD_CODEHTML = 61;
    public static final int TOKEN_KEYWORD_CODEJS = 62;
    public static final int TOKEN_KEYWORD_CODEURL = 63;
    public static final int TOKEN_KEYWORD_FORMAT_USER = 64;
    public static final int TOKEN_KEYWORD_FORMAT_DATE = 65;
    public static final int TOKEN_KEYWORD_SUBSTR = 70;
    public static final int TOKEN_KEYWORD_LEN = 71;
    public static final int TOKEN_KEYWORD_NOT = 75;
    public static final int TOKEN_KEYWORD_ADD = 80;
    public static final int TOKEN_KEYWORD_SUB = 81;
    public static final int TOKEN_KEYWORD_MUL = 82;
    public static final int TOKEN_KEYWORD_DIV = 83;
    public static final int TOKEN_KEYWORD_MOD = 84;
    public static final int TOKEN_KEYWORD_EQ = 90;
    public static final int TOKEN_KEYWORD_NE = 91;
    public static final int TOKEN_KEYWORD_LT = 92;
    public static final int TOKEN_KEYWORD_LE = 93;
    public static final int TOKEN_KEYWORD_GT = 94;
    public static final int TOKEN_KEYWORD_GE = 95;
    public static final int TOKEN_OPERATOR_ADD = 100;
    public static final int TOKEN_OPERATOR_SUB = 101;
    public static final int TOKEN_OPERATOR_MUL = 102;
    public static final int TOKEN_OPERATOR_DIV = 103;
    public static final int TOKEN_OPERATOR_LT = 104;
    public static final int TOKEN_OPERATOR_GT = 105;
    public static final int TOKEN_OPERATOR_EXCLAMATION = 106;
    public static final int TOKEN_OPERATOR_EQUALS = 107;
    public static final int TOKEN_KEYWORD_SET = 110;
    public static final int TOKEN_KEYWORD_APPEND = 111;
    public static final int TOKEN_KEYWORD_DELETE = 112;
    public static final int TOKEN_KEYWORD_CLEAR = 113;
    public static final int TOKEN_SEPARATOR = 120;
    public static final int TOKEN_KEYWORD_STOP = 130;
    public static final int TOKEN_KEYWORD_BREAK = 131;
    public static final int TOKEN_KEYWORD_INCLUDE = 140;
    public static final int TOKEN_KEYWORD_COPYFIELDS = 141;
    public static final int TOKEN_KEYWORD_NOPARSE = 142;
    public static final int TOKEN_EXCLAMATION = 150;
    public static final int TOKEN_SEMICOLON = 160;
    private static final int CHARACTER_SWITCH = 96;
    private static final int CHARACTER_WHITESPACE_SPACE = 32;
    private static final int CHARACTER_WHITESPACE_CR = 13;
    private static final int CHARACTER_WHITESPACE_LF = 10;
    private static final int CHARACTER_WHITESPACE_TAB = 9;
    private static final int CHARACTER_ESCAPE = 92;
    private static final String DELIMITER_STREAM = "\r\n`\\";
    private static final String DELIMITER_CONTENT = "\r\n\t `\"+-*/()<>={},:!;";
    private static final String ALLOWED_CHARS_NUMBER = "0123456789";
    private static final String ALLOWED_CHARS_IDENTIFIER = "_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.";
    private static Hashtable m_keywordRegistry = new Hashtable();
    private boolean m_inStream = true;
    private int m_currentLine = 1;
    private int m_currentColumn = 1;
    private StringTokenizer m_tokenizer;
    private FormToken m_lookAheadToken = null;

    public FormTokenizer(String data) {
        this.m_tokenizer = new StringTokenizer(data, DELIMITER_STREAM, true);
    }

    public FormTokenizer(InputStream stream) throws EngineException {
        this.m_tokenizer = new StringTokenizer(this.readResourceContent(stream), DELIMITER_STREAM, true);
    }

    public boolean hasMoreElements() {
        if (this.m_lookAheadToken != null) {
            return true;
        }
        return this.m_tokenizer.hasMoreElements();
    }

    public FormToken nextElement(Locale locale) throws FormCompilerException {
        if (this.m_lookAheadToken == null) {
            this.m_lookAheadToken = this.deliverNextElement(locale);
        }
        FormToken element = this.deliverNextElement(locale);
        FormToken result = null;
        if (element == null) {
            result = this.m_lookAheadToken;
            this.m_lookAheadToken = null;
            return result;
        }
        switch (this.m_lookAheadToken.getType()) {
            case 7: {
                if (element.getType() == 7 && !element.isBeforeWhiteSpace()) {
                    this.m_lookAheadToken = null;
                    element.m_type = 107;
                    return element;
                }
                result = this.m_lookAheadToken;
                this.m_lookAheadToken = element;
                return result;
            }
            case 104: {
                if (element.getType() == 7 && !element.isBeforeWhiteSpace()) {
                    this.m_lookAheadToken = null;
                    element.m_type = 93;
                    return element;
                }
                result = this.m_lookAheadToken;
                this.m_lookAheadToken = element;
                return result;
            }
            case 105: {
                if (element.getType() == 7 && !element.isBeforeWhiteSpace()) {
                    this.m_lookAheadToken = null;
                    element.m_type = 94;
                    return element;
                }
                result = this.m_lookAheadToken;
                this.m_lookAheadToken = element;
                return result;
            }
            case 106: {
                if (element.getType() == 7 && !element.isBeforeWhiteSpace()) {
                    this.m_lookAheadToken = null;
                    element.m_type = 91;
                    return element;
                }
                result = this.m_lookAheadToken;
                this.m_lookAheadToken = element;
                return result;
            }
            case 101: {
                if (element.getType() == 2 && !element.isBeforeWhiteSpace()) {
                    this.m_lookAheadToken = null;
                    element.m_value = "-" + element.m_value;
                    return element;
                }
                result = this.m_lookAheadToken;
                this.m_lookAheadToken = element;
                return result;
            }
        }
        result = this.m_lookAheadToken;
        this.m_lookAheadToken = element;
        return result;
    }

    private FormToken deliverNextElement(Locale locale) throws FormCompilerException {
        FormToken nextToken = null;
        while (this.m_tokenizer.hasMoreElements() && nextToken == null) {
            if (this.m_inStream) {
                nextToken = this.nextStreamToken();
                continue;
            }
            nextToken = this.nextContentToken(locale);
        }
        return nextToken;
    }

    private FormToken nextStreamToken() throws FormCompilerException {
        StringBuffer buf = new StringBuffer();
        String next = null;
        int line = this.m_currentLine;
        int column = this.m_currentColumn;
        boolean previousCr = false;
        boolean previousEscape = false;
        block6: while (this.m_tokenizer.hasMoreElements() && this.m_inStream) {
            next = this.m_tokenizer.nextToken(DELIMITER_STREAM);
            char c = next.charAt(0);
            switch (c) {
                case '\r': {
                    previousEscape = false;
                    column = 1;
                    this.m_currentLine = ++line;
                    this.m_currentColumn = column;
                    previousCr = true;
                    buf.append(next);
                    continue block6;
                }
                case '\n': {
                    previousEscape = false;
                    if (previousCr) {
                        previousCr = false;
                    } else {
                        column = 1;
                        this.m_currentLine = ++line;
                        this.m_currentColumn = column;
                    }
                    buf.append(next);
                    continue block6;
                }
                case '\\': {
                    previousCr = false;
                    previousEscape = true;
                    ++column;
                    continue block6;
                }
                case '`': {
                    previousCr = false;
                    if (previousEscape) {
                        previousEscape = false;
                        buf.append(next);
                    } else {
                        this.m_inStream = false;
                    }
                    ++column;
                    continue block6;
                }
            }
            previousCr = false;
            previousEscape = false;
            buf.append(next);
            column += next.length();
        }
        FormToken result = null;
        if (buf.length() != 0) {
            result = new FormToken(0, buf.toString(), this.m_currentColumn, this.m_currentLine, false);
        }
        this.m_currentColumn = column;
        this.m_currentLine = line;
        return result;
    }

    private FormToken nextContentToken(Locale locale) throws FormCompilerException {
        String next = null;
        int line = this.m_currentLine;
        int column = this.m_currentColumn;
        FormToken result = null;
        boolean previousCr = false;
        boolean beforeWhiteSpace = false;
        block23: while (this.m_tokenizer.hasMoreElements() && !this.m_inStream && result == null) {
            next = this.m_tokenizer.nextToken(DELIMITER_CONTENT);
            char c = next.charAt(0);
            switch (c) {
                case '\r': {
                    ++line;
                    column = 1;
                    beforeWhiteSpace = true;
                    previousCr = true;
                    continue block23;
                }
                case '\n': {
                    beforeWhiteSpace = true;
                    if (previousCr) {
                        previousCr = false;
                        continue block23;
                    }
                    ++line;
                    column = 1;
                    continue block23;
                }
                case ' ': {
                    beforeWhiteSpace = true;
                    ++column;
                    continue block23;
                }
                case '\t': {
                    beforeWhiteSpace = true;
                    ++column;
                    continue block23;
                }
                case '`': {
                    this.m_inStream = true;
                    ++column;
                    continue block23;
                }
                case '(': {
                    ++column;
                    result = new FormToken(5, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case ')': {
                    ++column;
                    result = new FormToken(6, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '\"': {
                    ++column;
                    return this.nextTokenLiteral(locale);
                }
                case '=': {
                    ++column;
                    result = new FormToken(7, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case ':': {
                    ++column;
                    result = new FormToken(4, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '<': {
                    ++column;
                    result = new FormToken(104, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '>': {
                    ++column;
                    result = new FormToken(105, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '!': {
                    ++column;
                    result = new FormToken(106, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case ';': {
                    ++column;
                    result = new FormToken(160, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '+': {
                    ++column;
                    result = new FormToken(100, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '-': {
                    ++column;
                    result = new FormToken(101, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '*': {
                    ++column;
                    result = new FormToken(102, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '/': {
                    ++column;
                    result = new FormToken(103, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '{': {
                    ++column;
                    result = new FormToken(8, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case '}': {
                    ++column;
                    result = new FormToken(9, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
                case ',': {
                    ++column;
                    result = new FormToken(120, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                    continue block23;
                }
            }
            String lookUp = next.toLowerCase();
            column += next.length();
            if (m_keywordRegistry.containsKey(lookUp)) {
                KeywordInfo info = (KeywordInfo)m_keywordRegistry.get(lookUp);
                result = new FormToken(info.m_type, info.m_keyword, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                continue;
            }
            if (this.isNumberToken(next)) {
                result = new FormToken(2, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                continue;
            }
            if (this.isIdentifierToken(next)) {
                result = new FormToken(1, next, this.m_currentColumn, this.m_currentLine, beforeWhiteSpace);
                continue;
            }
            throw new FormCompilerException(MessageFormat.format(BaseResourceHandler.getString("FormTokenizer.ERROR_UNKNOWN_IDENTIFIER", locale), Integer.toString(this.m_currentLine), Integer.toString(this.m_currentColumn), lookUp));
        }
        this.m_currentColumn = column;
        this.m_currentLine = line;
        return result;
    }

    private FormToken nextTokenLiteral(Locale locale) throws FormCompilerException {
        StringBuffer result = new StringBuffer();
        int column = this.m_currentColumn;
        boolean prevEscape = false;
        boolean literalEnd = false;
        block9: while (this.m_tokenizer.hasMoreElements() && !literalEnd) {
            String next = this.m_tokenizer.nextToken("\"\\\r\nrnt");
            column += next.length();
            char c = next.charAt(0);
            switch (c) {
                case '\\': {
                    if (prevEscape) {
                        result.append("\\");
                        prevEscape = false;
                        continue block9;
                    }
                    prevEscape = true;
                    continue block9;
                }
                case '\"': {
                    if (prevEscape) {
                        result.append("\"");
                        prevEscape = false;
                        continue block9;
                    }
                    literalEnd = true;
                    continue block9;
                }
                case '\r': {
                    throw new FormCompilerException(MessageFormat.format(BaseResourceHandler.getString("FormTokenizer.ERROR_EOL_IN_LITERAL", locale), Integer.toString(this.m_currentLine), Integer.toString(this.m_currentColumn)));
                }
                case '\n': {
                    throw new FormCompilerException(MessageFormat.format(BaseResourceHandler.getString("FormTokenizer.ERROR_EOL_IN_LITERAL", locale), Integer.toString(this.m_currentLine), Integer.toString(this.m_currentColumn)));
                }
                case 'r': {
                    if (prevEscape) {
                        result.append("\r");
                        prevEscape = false;
                        continue block9;
                    }
                    result.append("r");
                    continue block9;
                }
                case 'n': {
                    if (prevEscape) {
                        result.append("\n");
                        prevEscape = false;
                        continue block9;
                    }
                    result.append("n");
                    continue block9;
                }
                case 't': {
                    if (prevEscape) {
                        result.append("\t");
                        prevEscape = false;
                        continue block9;
                    }
                    result.append("t");
                    continue block9;
                }
            }
            result.append(next);
            prevEscape = false;
        }
        this.m_currentColumn = column;
        return new FormToken(3, result.toString(), this.m_currentColumn, this.m_currentLine, false);
    }

    private boolean isNumberToken(String token) {
        if (token.length() == 0) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (ALLOWED_CHARS_NUMBER.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean isIdentifierToken(String token) {
        if (token.length() == 0) {
            return false;
        }
        char c = token.charAt(0);
        if (ALLOWED_CHARS_IDENTIFIER.indexOf(c) == -1) {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            c = token.charAt(i);
            if (ALLOWED_CHARS_IDENTIFIER.indexOf(c) != -1 || ALLOWED_CHARS_NUMBER.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    protected String readResourceContent(InputStream stream) throws EngineException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[2048];
            int read = -1;
            do {
                if ((read = reader.read(chars)) == -1) continue;
                buffer.append(chars, 0, read);
            } while (read != -1);
            return buffer.toString();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to parse the html document.", ex);
        }
    }

    static {
        m_keywordRegistry.put("eval", new KeywordInfo(12, "EVAL"));
        m_keywordRegistry.put("exists", new KeywordInfo(13, "EXISTS"));
        m_keywordRegistry.put("write", new KeywordInfo(14, "WRITE"));
        m_keywordRegistry.put("writeln", new KeywordInfo(15, "WRITELN"));
        m_keywordRegistry.put("fcount", new KeywordInfo(16, "FCOUNT"));
        m_keywordRegistry.put("if", new KeywordInfo(20, "IF"));
        m_keywordRegistry.put("else", new KeywordInfo(22, "ELSE"));
        m_keywordRegistry.put("switch", new KeywordInfo(31, "SWITCH"));
        m_keywordRegistry.put("case", new KeywordInfo(30, "CASE"));
        m_keywordRegistry.put("default", new KeywordInfo(32, "DEFAULT"));
        m_keywordRegistry.put("break", new KeywordInfo(131, "BREAK"));
        m_keywordRegistry.put("while", new KeywordInfo(35, "WHILE"));
        m_keywordRegistry.put("loop", new KeywordInfo(40, "LOOP"));
        m_keywordRegistry.put("loopidx", new KeywordInfo(41, "LOOPIDX"));
        m_keywordRegistry.put("codejs", new KeywordInfo(62, "CODEJS"));
        m_keywordRegistry.put("codeurl", new KeywordInfo(63, "CODEURL"));
        m_keywordRegistry.put("substr", new KeywordInfo(70, "SUBSTR"));
        m_keywordRegistry.put("len", new KeywordInfo(71, "LEN"));
        m_keywordRegistry.put("not", new KeywordInfo(75, "NOT"));
        m_keywordRegistry.put("add", new KeywordInfo(80, "ADD"));
        m_keywordRegistry.put("sub", new KeywordInfo(81, "SUB"));
        m_keywordRegistry.put("div", new KeywordInfo(83, "DIV"));
        m_keywordRegistry.put("mod", new KeywordInfo(84, "MOD"));
        m_keywordRegistry.put("mul", new KeywordInfo(82, "MUL"));
        m_keywordRegistry.put("set", new KeywordInfo(110, "SET"));
        m_keywordRegistry.put("append", new KeywordInfo(111, "APPEND"));
        m_keywordRegistry.put("delete", new KeywordInfo(112, "DELETE"));
        m_keywordRegistry.put("clear", new KeywordInfo(113, "CLEAR"));
        m_keywordRegistry.put("stop", new KeywordInfo(130, "STOP"));
        m_keywordRegistry.put("eq", new KeywordInfo(90, "EQ"));
        m_keywordRegistry.put("lt", new KeywordInfo(92, "LT"));
        m_keywordRegistry.put("gt", new KeywordInfo(94, "GT"));
        m_keywordRegistry.put("le", new KeywordInfo(93, "LE"));
        m_keywordRegistry.put("ge", new KeywordInfo(95, "GE"));
    }

    public class FormToken {
        private int m_type;
        private String m_value;
        private int m_line;
        private int m_column;
        private boolean m_beforeWhiteSpace;

        protected FormToken(int type, String value, int col, int line, boolean beforeWhiteSpace) {
            this.m_value = value;
            this.m_type = type;
            this.m_line = line;
            this.m_column = col;
            this.m_beforeWhiteSpace = beforeWhiteSpace;
        }

        public boolean isBeforeWhiteSpace() {
            return this.m_beforeWhiteSpace;
        }

        public int getType() {
            return this.m_type;
        }

        public String getValue() {
            return this.m_value;
        }

        public int getLine() {
            return this.m_line;
        }

        public int getColumn() {
            return this.m_column;
        }

        public String toString() {
            String result = "[Line " + this.m_line + ", Column " + this.m_column + "] " + this.getValue() + " [Type: " + this.m_type + ", WhiteSpaceBefore:" + this.m_beforeWhiteSpace + "]";
            return result;
        }
    }

    private static class KeywordInfo {
        public int m_type;
        public String m_keyword;

        public KeywordInfo(int type, String keyword) {
            this.m_type = type;
            this.m_keyword = keyword;
        }
    }
}

