/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.swift.compiler;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import com.sap.caf.mp.base.swift.compiler.FormTokenizer;
import com.sap.caf.mp.base.swift.exception.FormCompilerException;
import com.sap.caf.mp.base.swift.machine.StackMachineProgram;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class FormCompiler {
    public static final int PTN_TYPE_STMT_BLOCK = 0;
    public static final int PTN_TYPE_OPERAND_LITERAL = 10;
    public static final int PTN_TYPE_OPERAND_NUMBER = 11;
    public static final int PTN_TYPE_OPERAND_IDENTIFIER = 12;
    public static final int PTN_TYPE_OPERATOR_EQ = 20;
    public static final int PTN_TYPE_OPERATOR_LT = 21;
    public static final int PTN_TYPE_OPERATOR_GT = 22;
    public static final int PTN_TYPE_OPERATOR_LE = 23;
    public static final int PTN_TYPE_OPERATOR_GE = 24;
    public static final int PTN_TYPE_OPERATOR_NE = 25;
    public static final int PTN_TYPE_OPERATOR_ADD = 30;
    public static final int PTN_TYPE_OPERATOR_SUB = 31;
    public static final int PTN_TYPE_OPERATOR_MUL = 32;
    public static final int PTN_TYPE_OPERATOR_DIV = 33;
    public static final int PTN_TYPE_OPERATOR_MOD = 34;
    public static final int PTN_TYPE_STMT_WRITE = 40;
    public static final int PTN_TYPE_STMT_WRITELN = 41;
    public static final int PTN_TYPE_STMT_IF = 50;
    public static final int PTN_TYPE_STMT_SWITCH = 51;
    public static final int PTN_TYPE_STMT_LOOP = 60;
    public static final int PTN_TYPE_LOOP_FIELD_LIST = 61;
    public static final int PTN_TYPE_EXPR_EVAL = 70;
    public static final int PTN_TYPE_EXPR_FIELD = 71;
    public static final int PTN_TYPE_EXPR_EXISTS = 72;
    public static final int PTN_TYPE_EXPR_NAME = 73;
    public static final int PTN_TYPE_EXPR_COUNT = 74;
    public static final int PTN_TYPE_EXPR_LOOPIDX = 74;
    public static final int PTN_TYPE_EXPR_FORMAT_CODEXML = 80;
    public static final int PTN_TYPE_EXPR_FORMAT_CODEURL = 81;
    public static final int PTN_TYPE_EXPR_FORMAT_CODEHTML = 82;
    public static final int PTN_TYPE_EXPR_FORMAT_CODEJS = 83;
    public static final int PTN_TYPE_EXPR_FORMAT_USER = 84;
    public static final int PTN_TYPE_EXPR_FORMAT_DATE = 85;
    public static final int PTN_TYPE_EXPR_SUBSTR = 90;
    public static final int PTN_TYPE_EXPR_LEN = 91;
    public static final int PTN_TYPE_EXPR_MATH_ADD = 100;
    public static final int PTN_TYPE_EXPR_MATH_MUL = 101;
    public static final int PTN_TYPE_EXPR_MATH_MOD = 102;
    public static final int PTN_TYPE_EXPR_MATH_DIV = 103;
    public static final int PTN_TYPE_EXPR_MATH_SUB = 104;
    public static final int PTN_TYPE_EXPR_NOT = 105;
    public static final int PTN_TYPE_STMT_ASSIGN = 110;
    public static final int PTN_TYPE_STMT_SET = 111;
    public static final int PTN_TYPE_STMT_STOP = 112;
    public static final int PTN_TYPE_STMT_BREAK = 113;
    public static final int PTN_TYPE_STMT_APPEND = 114;
    public static final int PTN_TYPE_STMT_DELETE = 115;
    public static final int PTN_TYPE_STMT_CLEAR = 116;
    public static final int PTN_TYPE_STMT_WHILE = 120;
    public static final int PTN_TYPE_STMT_INCLUDE = 130;
    private ParseTreeNode m_treeRoot = null;
    private ParseTreeNode m_current = null;
    private long m_buildParseTreeTime = 0L;

    public StackMachineProgram compileForm(FormTokenizer form, Locale locale) throws FormCompilerException {
        this.m_buildParseTreeTime = 0L;
        long start = System.currentTimeMillis();
        this.m_current = this.m_treeRoot = new ParseTreeNodeStatementBlock(null);
        while (form.hasMoreElements()) {
            FormTokenizer.FormToken token = form.nextElement(locale);
            this.m_current.processNextToken(token, locale);
        }
        StackMachineProgram prg = new StackMachineProgram();
        this.m_treeRoot.createStackMachineCommand(prg, false);
        long end = System.currentTimeMillis();
        this.m_buildParseTreeTime = end - start;
        return prg;
    }

    public StackMachineProgram compileForm(String data, Locale locale) throws FormCompilerException {
        return this.compileForm(new FormTokenizer(data), locale);
    }

    public StackMachineProgram compileForm(InputStream stream, Locale locale) throws FormCompilerException, EngineException {
        return this.compileForm(new FormTokenizer(stream), locale);
    }

    private FormCompilerException constructSyntaxErrorException(FormTokenizer.FormToken token, String message, Locale locale) {
        return new FormCompilerException(MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_SYNTAX", locale), "" + token.getLine(), "" + token.getColumn(), message));
    }

    public long getBuildParseTreeTime() {
        return this.m_buildParseTreeTime;
    }

    private class ParseTreeNodeStatementBlock
    extends ParseTreeNode {
        private Vector m_children;
        private boolean m_caseBlock;

        public ParseTreeNodeStatementBlock(ParseTreeNode parent) {
            super(parent);
            this.m_type = 0;
            this.m_children = new Vector();
        }

        public ParseTreeNodeStatementBlock(ParseTreeNode parent, boolean caseBlock) {
            super(parent);
            this.m_type = 0;
            this.m_children = new Vector();
            this.m_caseBlock = true;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 8: {
                    FormCompiler.this.m_current = new ParseTreeNodeStatementBlock(this);
                    this.m_children.add(FormCompiler.this.m_current);
                    break;
                }
                case 9: {
                    if (this.m_parent == null) {
                        throw new FormCompilerException("Parser Error (Line " + token.getLine() + ", Column " + token.getColumn() + "): Block closed without matching block open.");
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    if (!this.m_caseBlock) break;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 0: {
                    ParseTreeNodeStatementPrint ps = new ParseTreeNodeStatementPrint(this, false);
                    ps.m_operand = new ParseTreeNodeOperand(ps, 10, token.getValue());
                    this.m_children.add(ps);
                    break;
                }
                case 14: {
                    ParseTreeNodeStatementPrint ps2 = new ParseTreeNodeStatementPrint(this, false);
                    this.m_children.add(ps2);
                    FormCompiler.this.m_current = ps2;
                    break;
                }
                case 15: {
                    ParseTreeNodeStatementPrint ps3 = new ParseTreeNodeStatementPrint(this, true);
                    this.m_children.add(ps3);
                    FormCompiler.this.m_current = ps3;
                    break;
                }
                case 20: {
                    ParseTreeNodeStatementIf ifstmt = new ParseTreeNodeStatementIf(this);
                    this.m_children.add(ifstmt);
                    FormCompiler.this.m_current = ifstmt;
                    break;
                }
                case 40: {
                    ParseTreeNodeStatementLoop loopStmt = new ParseTreeNodeStatementLoop(this);
                    this.m_children.add(loopStmt);
                    FormCompiler.this.m_current = loopStmt;
                    break;
                }
                case 1: {
                    ParseTreeNodeStatementAssign assignmentStmt = new ParseTreeNodeStatementAssign(this, token);
                    this.m_children.add(assignmentStmt);
                    FormCompiler.this.m_current = assignmentStmt;
                    break;
                }
                case 110: {
                    ParseTreeNodeStatementSet setStmt = new ParseTreeNodeStatementSet(this);
                    this.m_children.add(setStmt);
                    FormCompiler.this.m_current = setStmt;
                    break;
                }
                case 111: {
                    ParseTreeNodeStatementAppend appendStmt = new ParseTreeNodeStatementAppend(this);
                    this.m_children.add(appendStmt);
                    FormCompiler.this.m_current = appendStmt;
                    break;
                }
                case 131: {
                    ParseTreeNodeStatementBreak breakStmt = new ParseTreeNodeStatementBreak(this);
                    this.m_children.add(breakStmt);
                    break;
                }
                case 130: {
                    ParseTreeNodeStatementStop stopStmt = new ParseTreeNodeStatementStop(this);
                    this.m_children.add(stopStmt);
                    break;
                }
                case 31: {
                    ParseTreeNodeStatementSwitch switchStmt = new ParseTreeNodeStatementSwitch(this);
                    this.m_children.add(switchStmt);
                    FormCompiler.this.m_current = switchStmt;
                    break;
                }
                case 35: {
                    ParseTreeNodeStatementWhile whileStmt = new ParseTreeNodeStatementWhile(this);
                    this.m_children.add(whileStmt);
                    FormCompiler.this.m_current = whileStmt;
                    break;
                }
                case 112: {
                    ParseTreeNodeStatementDelete deleteStmt = new ParseTreeNodeStatementDelete(this);
                    this.m_children.add(deleteStmt);
                    FormCompiler.this.m_current = deleteStmt;
                    break;
                }
                case 113: {
                    ParseTreeNodeStatementClear clearStmt = new ParseTreeNodeStatementClear(this);
                    this.m_children.add(clearStmt);
                    FormCompiler.this.m_current = clearStmt;
                    break;
                }
                case 140: {
                    ParseTreeNodeStatementInclude includeStmt = new ParseTreeNodeStatementInclude(this);
                    this.m_children.add(includeStmt);
                    FormCompiler.this.m_current = includeStmt;
                    break;
                }
                case 160: {
                    break;
                }
                case 30: {
                    if (this.m_caseBlock) {
                        FormCompiler.this.m_current = this.m_parent;
                        FormCompiler.this.m_current.processNextToken(token, locale);
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_STATEMENT", locale), token.getValue(), "" + token.getType()), locale);
                }
                case 32: {
                    if (this.m_caseBlock) {
                        FormCompiler.this.m_current = this.m_parent;
                        FormCompiler.this.m_current.processNextToken(token, locale);
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format("Expected: statement, found: {0}, type: {1}", token.getValue(), "" + token.getType()), locale);
                }
                default: {
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_STATEMENT", locale), token.getValue(), "" + token.getType()), locale);
                }
            }
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[BLOCK" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            Enumeration enumeration = this.m_children.elements();
            while (enumeration.hasMoreElements()) {
                ParseTreeNode child = (ParseTreeNode)enumeration.nextElement();
                child.printNode(level + 1);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            Enumeration enumeration = this.m_children.elements();
            while (enumeration.hasMoreElements()) {
                ParseTreeNode nde = (ParseTreeNode)enumeration.nextElement();
                nde.createStackMachineCommand(prg, lval);
            }
        }
    }

    private class ParseTreeNodeStatementPrint
    extends ParseTreeNode {
        private ParseTreeNode m_operand;

        public ParseTreeNodeStatementPrint(ParseTreeNode parent, boolean writeLine) {
            super(parent);
            this.m_type = writeLine ? 41 : 40;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_operand != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_DUPLICATE_ARGUMENT_FOUND", locale), locale);
                    }
                    this.m_operand = new ParseTreeNodeCompoundExpression(this, true);
                    FormCompiler.this.m_current = this.m_operand;
                    break;
                }
                default: {
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[STMT_WRITE_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            if (this.m_operand != null) {
                this.m_operand.printNode(level + 1);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_operand.createStackMachineCommand(prg, lval);
            if (this.m_type == 40) {
                prg.addCommand(20, null);
            } else {
                prg.addCommand(21, null);
            }
        }
    }

    private class ParseTreeNodeStatementSwitch
    extends ParseTreeNode {
        private ParseTreeNode m_expression;
        private boolean m_caseFound;
        private boolean m_colonFound;
        private boolean m_defaultFound;
        private Vector m_caseExpressions;
        private Vector m_caseBlocks;
        private ParseTreeNode m_defaultBlock;
        private boolean m_elseNext = false;

        public ParseTreeNodeStatementSwitch(ParseTreeNode parent) {
            super(parent);
            this.m_type = 51;
            this.m_expression = null;
            this.m_caseBlocks = new Vector();
            this.m_caseExpressions = new Vector();
            this.m_defaultBlock = null;
            this.m_caseFound = false;
            this.m_colonFound = false;
            this.m_defaultFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_expression != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_SWITCH_ALREADY_SPECIFIED", locale), locale);
                    }
                    ParseTreeNodeCompoundExpression expr = new ParseTreeNodeCompoundExpression(this, true);
                    this.m_expression = expr;
                    FormCompiler.this.m_current = expr;
                    break;
                }
                case 8: {
                    if (this.m_expression != null) break;
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_SWITCH_EXPRESSION_FOUND_STATEMENTS", locale), locale);
                }
                case 9: {
                    if (this.m_caseBlocks.size() == 0) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_CASE_STATEMENT_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 30: {
                    this.m_caseFound = true;
                    this.m_colonFound = false;
                    ParseTreeNodeCompoundExpression caseExpr = new ParseTreeNodeCompoundExpression(this, false);
                    this.m_caseExpressions.add(caseExpr);
                    FormCompiler.this.m_current = caseExpr;
                    break;
                }
                case 32: {
                    if (this.m_caseExpressions.size() == 0) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_DEFAULT_WITHOUT_PRECEEDING_CASE", locale), locale);
                    }
                    this.m_defaultFound = true;
                    break;
                }
                case 4: {
                    if (!this.m_caseFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_COLON_WITHOUT_CASE", locale), locale);
                    }
                    if (this.m_colonFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_COLON_WITHOUT_CASE", locale) + token.getValue(), locale);
                    }
                    ParseTreeNodeStatementBlock block = new ParseTreeNodeStatementBlock(this, true);
                    if (!this.m_defaultFound) {
                        this.m_caseBlocks.add(block);
                    } else {
                        this.m_defaultBlock = block;
                    }
                    FormCompiler.this.m_current = block;
                    break;
                }
                default: {
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.Unexpected_token_in_switch_clause___4", locale) + token.getValue(), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "CASE_STMT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            for (int j = 0; j < this.m_caseExpressions.size(); ++j) {
                ParseTreeNode expr = (ParseTreeNode)this.m_caseExpressions.get(j);
                ParseTreeNode block = (ParseTreeNode)this.m_caseBlocks.get(j);
                BaseLogManager.info(this.getClass(), space + " [CASE-BLOCK]");
                BaseLogManager.info(this.getClass(), space + "   [CASE-EXPRESSION]");
                expr.printNode(level + 4);
                BaseLogManager.info(this.getClass(), space + "   [CASE-BLOCK]");
                block.printNode(level + 4);
            }
            if (this.m_defaultBlock != null) {
                BaseLogManager.info(this.getClass(), "  [DEFAULT_BLOCK]");
                this.m_defaultBlock.printNode(level + 3);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            int i;
            StackMachineProgram.ProgramLabel endLabel = prg.addLabel();
            StackMachineProgram.ProgramLabel defaultLabel = prg.addLabel();
            prg.addCommand(71, endLabel.getLabel());
            StackMachineProgram.ProgramLabel[] caseConditionLabel = null;
            StackMachineProgram.ProgramLabel[] caseBlockLabel = null;
            if (this.m_caseBlocks.size() > 0) {
                caseConditionLabel = new StackMachineProgram.ProgramLabel[this.m_caseBlocks.size()];
                caseBlockLabel = new StackMachineProgram.ProgramLabel[this.m_caseBlocks.size()];
                for (i = 0; i < this.m_caseBlocks.size(); ++i) {
                    caseConditionLabel[i] = prg.addLabel();
                    caseBlockLabel[i] = prg.addLabel();
                }
            }
            for (i = 0; i < this.m_caseBlocks.size(); ++i) {
                caseConditionLabel[i].setTargetLine(prg.getCommandCount());
                this.m_expression.createStackMachineCommand(prg, false);
                ParseTreeNode expr = (ParseTreeNode)this.m_caseExpressions.get(i);
                expr.createStackMachineCommand(prg, false);
                prg.addCommand(40, null);
                prg.addCommand(61, caseBlockLabel[i].getLabel());
                if (i < this.m_caseBlocks.size() - 1) {
                    prg.addCommand(60, caseConditionLabel[i + 1].getLabel());
                } else {
                    prg.addCommand(60, defaultLabel.getLabel());
                }
                caseBlockLabel[i].setTargetLine(prg.getCommandCount());
                ParseTreeNode stmtblock = (ParseTreeNode)this.m_caseBlocks.get(i);
                stmtblock.createStackMachineCommand(prg, false);
                prg.addCommand(60, endLabel.getLabel());
            }
            defaultLabel.setTargetLine(prg.getCommandCount());
            if (this.m_defaultBlock != null) {
                this.m_defaultBlock.createStackMachineCommand(prg, false);
            }
            endLabel.setTargetLine(prg.getCommandCount());
            prg.addCommand(72, null);
        }
    }

    private class ParseTreeNodeStatementWhile
    extends ParseTreeNode {
        private ParseTreeNode m_condition;
        private ParseTreeNode m_block;
        private boolean m_elseNext = false;

        public ParseTreeNodeStatementWhile(ParseTreeNode parent) {
            super(parent);
            this.m_type = 50;
            this.m_condition = null;
            this.m_block = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_condition != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_CONDITION_ALREADY_SPECIFIED", locale), locale);
                    }
                    ParseTreeNodeCompoundExpression expr = new ParseTreeNodeCompoundExpression(this, true);
                    this.m_condition = expr;
                    FormCompiler.this.m_current = expr;
                    break;
                }
                case 8: {
                    if (this.m_condition == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, "Expected condidition, found statement block.", locale);
                    }
                    ParseTreeNodeStatementBlock block = new ParseTreeNodeStatementBlock(this);
                    this.m_block = block;
                    FormCompiler.this.m_current = block;
                    break;
                }
                default: {
                    if (this.m_condition == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_WHILE_WITHOUT_CONDITION", locale), locale);
                    }
                    if (this.m_block == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_WHILE_WITHOUT_STATEMENTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[WHILE_STMT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [WHILE-CONDITION]");
            this.m_condition.printNode(level + 2);
            if (this.m_block != null) {
                BaseLogManager.info(this.getClass(), space + " [WHILE-BLOCK]");
                this.m_block.printNode(level + 2);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            StackMachineProgram.ProgramLabel whileExprLabel = prg.addLabel();
            StackMachineProgram.ProgramLabel whileBodyLabel = prg.addLabel();
            StackMachineProgram.ProgramLabel whileEndLabel = prg.addLabel();
            prg.addCommand(71, whileEndLabel.getLabel());
            whileExprLabel.setTargetLine(prg.getCommandCount());
            this.m_condition.createStackMachineCommand(prg, false);
            prg.addCommand(61, whileBodyLabel.getLabel());
            prg.addCommand(60, whileEndLabel.getLabel());
            whileBodyLabel.setTargetLine(prg.getCommandCount());
            this.m_block.createStackMachineCommand(prg, false);
            prg.addCommand(60, whileExprLabel.getLabel());
            whileEndLabel.setTargetLine(prg.getCommandCount());
            prg.addCommand(72, null);
        }
    }

    private class ParseTreeNodeStatementIf
    extends ParseTreeNode {
        private ParseTreeNode m_condition;
        private ParseTreeNode m_trueBlock;
        private ParseTreeNode m_falseBlock;
        private boolean m_elseNext = false;

        public ParseTreeNodeStatementIf(ParseTreeNode parent) {
            super(parent);
            this.m_type = 50;
            this.m_condition = null;
            this.m_trueBlock = null;
            this.m_falseBlock = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_condition != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_CONDITION_ALREADY_SPECIFIED", locale), locale);
                    }
                    ParseTreeNodeCompoundExpression expr = new ParseTreeNodeCompoundExpression(this, true);
                    this.m_condition = expr;
                    FormCompiler.this.m_current = expr;
                    return;
                }
                case 8: {
                    if (this.m_condition == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IF_CLAUSE_CONDITION_FOUND_ELSE", locale), locale);
                    }
                    ParseTreeNodeStatementBlock block = new ParseTreeNodeStatementBlock(this);
                    if (this.m_elseNext) {
                        if (this.m_falseBlock != null) throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_FALSE_BLOCK_ALREADY_DEFINED", locale), locale);
                        this.m_falseBlock = block;
                    } else {
                        if (this.m_trueBlock != null) throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_TRUE_BLOCK_ALREADY_DEFINED", locale), locale);
                        this.m_trueBlock = block;
                    }
                    FormCompiler.this.m_current = block;
                    return;
                }
                case 22: {
                    if (this.m_condition == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_CONDITION_FOUND_STATEMENTS", locale), locale);
                    }
                    if (this.m_trueBlock == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_TRUE_BLOCK_FOUND_ELSE_BLOCK", locale), locale);
                    }
                    this.m_elseNext = true;
                    return;
                }
                default: {
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[IF_STMT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [IF-CONDITION]");
            this.m_condition.printNode(level + 2);
            if (this.m_trueBlock != null) {
                BaseLogManager.info(this.getClass(), space + " [IF-TRUE]");
                this.m_trueBlock.printNode(level + 2);
            }
            if (this.m_falseBlock != null) {
                BaseLogManager.info(this.getClass(), space + " [IF-FALSE]");
                this.m_falseBlock.printNode(level + 2);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_condition.createStackMachineCommand(prg, false);
            StackMachineProgram.ProgramLabel trueLabel = prg.addLabel();
            StackMachineProgram.ProgramLabel falseLabel = prg.addLabel();
            StackMachineProgram.ProgramLabel endLabel = prg.addLabel();
            prg.addCommand(61, trueLabel.getLabel());
            prg.addCommand(60, falseLabel.getLabel());
            trueLabel.setTargetLine(prg.getCommandCount());
            if (this.m_trueBlock != null) {
                this.m_trueBlock.createStackMachineCommand(prg, lval);
            }
            prg.addCommand(60, endLabel.getLabel());
            falseLabel.setTargetLine(prg.getCommandCount());
            if (this.m_falseBlock != null) {
                this.m_falseBlock.createStackMachineCommand(prg, lval);
            }
            endLabel.setTargetLine(prg.getCommandCount());
        }
    }

    private class ParseTreeNodeStatementStop
    extends ParseTreeNode {
        public ParseTreeNodeStatementStop(ParseTreeNode parent) {
            super(parent);
            this.m_type = 112;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[STMT_BREAK_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            prg.addCommand(80, null);
        }
    }

    private class ParseTreeNodeStatementBreak
    extends ParseTreeNode {
        public ParseTreeNodeStatementBreak(ParseTreeNode parent) {
            super(parent);
            this.m_type = 113;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[STMT_BREAK_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            prg.addCommand(70, null);
        }
    }

    private class ParseTreeNodeStatementLoop
    extends ParseTreeNode {
        private ParseTreeNode m_loopFields;
        private ParseTreeNode m_loopBody;

        public ParseTreeNodeStatementLoop(ParseTreeNode parent) {
            super(parent);
            this.m_type = 60;
            this.m_loopFields = null;
            this.m_loopBody = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_loopFields != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_LOOPFIELDLIST_ALREADY_DEFINED", locale), locale);
                    }
                    this.m_loopFields = new ParseTreeNodeLoopFieldList(this);
                    FormCompiler.this.m_current = this.m_loopFields;
                    break;
                }
                case 8: {
                    if (this.m_loopFields == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_LOOPBODY_WITHOUT_FIELDLIST", locale), locale);
                    }
                    this.m_loopBody = new ParseTreeNodeStatementBlock(this);
                    FormCompiler.this.m_current = this.m_loopBody;
                    break;
                }
                default: {
                    if (this.m_loopFields == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_LOOPFIELDLIST_ALREADY_DEFINED", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[LOOP_STMT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [LOOP-FIELDS]");
            this.m_loopFields.printNode(level + 2);
            BaseLogManager.info(this.getClass(), space + " [LOOP-BODY]");
            this.m_loopBody.printNode(level + 2);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            prg.addCommand(94, null);
            this.m_loopFields.createStackMachineCommand(prg, true);
            StackMachineProgram.ProgramLabel endLabel = prg.addLabel();
            prg.addCommand(71, endLabel.getLabel());
            StackMachineProgram.ProgramLabel startLabel = prg.addLabel();
            startLabel.setTargetLine(prg.getCommandCount());
            StackMachineProgram.ProgramLabel blockLabel = prg.addLabel();
            prg.addCommand(90, null);
            prg.addCommand(61, blockLabel.getLabel());
            prg.addCommand(60, endLabel.getLabel());
            blockLabel.setTargetLine(prg.getCommandCount());
            this.m_loopBody.createStackMachineCommand(prg, false);
            prg.addCommand(60, startLabel.getLabel());
            endLabel.setTargetLine(prg.getCommandCount());
            prg.addCommand(72, null);
            prg.addCommand(95, null);
        }
    }

    private class ParseTreeNodeLoopFieldList
    extends ParseTreeNode {
        private Vector m_fields;
        private boolean m_lastSeparator;

        public ParseTreeNodeLoopFieldList(ParseTreeNode parent) {
            super(parent);
            this.m_type = 61;
            this.m_fields = new Vector();
            this.m_lastSeparator = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 1: {
                    if (this.m_fields.size() > 0 && !this.m_lastSeparator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.Expected__end_of_list_or_separator,_found__identifier_158", locale), locale);
                    }
                    this.m_lastSeparator = false;
                    ParseTreeNodeOperand identifier = new ParseTreeNodeOperand(this, 12, token.getValue());
                    this.m_fields.add(identifier);
                    break;
                }
                case 12: {
                    if (this.m_fields.size() > 0 && !this.m_lastSeparator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.EXPECTED_EOL_SEPARATOR_FOUND_IDENTIFIER", locale), locale);
                    }
                    this.m_lastSeparator = false;
                    ParseTreeNodeExpressionEval evalStmt = new ParseTreeNodeExpressionEval(this);
                    this.m_fields.add(evalStmt);
                    FormCompiler.this.m_current = evalStmt;
                    break;
                }
                case 120: {
                    if (this.m_lastSeparator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.EXPECTED_IDENTIFIER_OR_EVAL_FOUND_SEPARATOR", locale), locale);
                    }
                    this.m_lastSeparator = true;
                    break;
                }
                case 6: {
                    if (this.m_fields.size() == 0) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_LOOK_LINKLIST_EMPTY", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_ONLY_IDENTIFIERS_AND_EVAL_STATEMENTS", locale), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[LOOP_FIELD_LIST_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            Enumeration enumeration = this.m_fields.elements();
            while (enumeration.hasMoreElements()) {
                ParseTreeNode item = (ParseTreeNode)enumeration.nextElement();
                item.printNode(level + 1);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            Enumeration enumeration = this.m_fields.elements();
            while (enumeration.hasMoreElements()) {
                ParseTreeNode node = (ParseTreeNode)enumeration.nextElement();
                node.createStackMachineCommand(prg, true);
                prg.addCommand(92, null);
            }
        }
    }

    private class ParseTreeNodeExpressionNot
    extends ParseTreeNode {
        private ParseTreeNode m_expression;

        public ParseTreeNodeExpressionNot(ParseTreeNode parent) {
            super(parent);
            this.m_type = 105;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    this.m_expression = new ParseTreeNodeCompoundExpression(this, true);
                    FormCompiler.this.m_current = this.m_expression;
                    break;
                }
                default: {
                    if (this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EVAL_EXPRESSION_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[NOT_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_expression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_expression.createStackMachineCommand(prg, false);
            prg.addCommand(50, null);
        }
    }

    private class ParseTreeNodeExpressionLen
    extends ParseTreeNode {
        private ParseTreeNode m_expression;

        public ParseTreeNodeExpressionLen(ParseTreeNode parent) {
            super(parent);
            this.m_type = 91;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    this.m_expression = new ParseTreeNodeCompoundExpression(this, true);
                    FormCompiler.this.m_current = this.m_expression;
                    break;
                }
                default: {
                    if (this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EVAL_EXPRESSION_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[LEN_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_expression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_expression.createStackMachineCommand(prg, false);
            prg.addCommand(101, null);
        }
    }

    private class ParseTreeNodeExpressionFormat
    extends ParseTreeNode {
        private ParseTreeNode m_expression;

        public ParseTreeNodeExpressionFormat(ParseTreeNode parent, int type) {
            super(parent);
            this.m_type = type;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    this.m_expression = new ParseTreeNodeCompoundExpression(this, true);
                    FormCompiler.this.m_current = this.m_expression;
                    break;
                }
                default: {
                    if (this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EVAL_EXPRESSION_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[FORMAT_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_expression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_expression.createStackMachineCommand(prg, false);
            switch (this.m_type) {
                case 82: {
                    prg.addCommand(110, null);
                    break;
                }
                case 83: {
                    prg.addCommand(113, null);
                    break;
                }
                case 80: {
                    prg.addCommand(112, null);
                    break;
                }
                case 81: {
                    prg.addCommand(111, null);
                    break;
                }
                case 84: {
                    prg.addCommand(114, null);
                    break;
                }
                case 85: {
                    prg.addCommand(115, null);
                }
            }
        }
    }

    private class ParseTreeNodeExpressionMath
    extends ParseTreeNode {
        private ParseTreeNode m_operand1;
        private ParseTreeNode m_operand2;

        public ParseTreeNodeExpressionMath(ParseTreeNode parent, int type) {
            super(parent);
            this.m_type = type;
            this.m_operand1 = null;
            this.m_operand2 = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_operand1 == null) {
                        this.m_operand1 = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_operand1;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_ARGLIST_FOUND_OPENING_BRACKET", locale), locale);
                }
                case 6: {
                    if (this.m_operand2 == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_NOT_ENOUGH_ARGUMENTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 120: {
                    if (this.m_operand2 == null) {
                        this.m_operand2 = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_operand2;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_TOO_MANY_ARGUMENTS", locale), locale);
                }
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_operand1.createStackMachineCommand(prg, false);
            this.m_operand2.createStackMachineCommand(prg, false);
            switch (this.m_type) {
                case 100: {
                    prg.addCommand(30, null);
                    break;
                }
                case 104: {
                    prg.addCommand(31, null);
                    break;
                }
                case 101: {
                    prg.addCommand(32, null);
                    break;
                }
                case 102: {
                    prg.addCommand(34, null);
                    break;
                }
                case 103: {
                    prg.addCommand(33, null);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[MATH_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [OPERAND_1]");
            this.m_operand1.printNode(level + 2);
            BaseLogManager.info(this.getClass(), space + " [OPERAND_2]");
            this.m_operand2.printNode(level + 2);
        }
    }

    private class ParseTreeNodeStatementAppend
    extends ParseTreeNode {
        private ParseTreeNode m_lval;
        private ParseTreeNode m_expression;

        public ParseTreeNodeStatementAppend(ParseTreeNode parent) {
            super(parent);
            this.m_type = 114;
            this.m_lval = null;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_lval == null) {
                        this.m_lval = new ParseTreeNodeExpressionIdentifier(this);
                        FormCompiler.this.m_current = this.m_lval;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_FOUND_OPENING_BRACKET", locale), locale);
                }
                case 6: {
                    if (this.m_lval == null || this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_NOT_ENOUGH_ARGUMENTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 120: {
                    if (this.m_expression == null) {
                        this.m_expression = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_expression;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_TOO_MANY_ARGUMENTS", locale), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[APPEND_STATEMENT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [APPEND_LVAL]");
            this.m_lval.printNode(level + 2);
            BaseLogManager.info(this.getClass(), space + " [APPEND_EXPRESSION]");
            this.m_expression.printNode(level + 2);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_lval.createStackMachineCommand(prg, true);
            this.m_expression.createStackMachineCommand(prg, false);
            prg.addCommand(19, null);
        }
    }

    private class ParseTreeNodeStatementSet
    extends ParseTreeNode {
        private ParseTreeNode m_lval;
        private ParseTreeNode m_expression;

        public ParseTreeNodeStatementSet(ParseTreeNode parent) {
            super(parent);
            this.m_type = 111;
            this.m_lval = null;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_lval == null) {
                        this.m_lval = new ParseTreeNodeExpressionIdentifier(this);
                        FormCompiler.this.m_current = this.m_lval;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_FOUND_OPENING_BRACKET", locale), locale);
                }
                case 6: {
                    if (this.m_lval == null || this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_NOT_ENOUGH_ARGUMENTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 120: {
                    if (this.m_expression == null) {
                        this.m_expression = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_expression;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_TOO_MANY_ARGUMENTS", locale), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[SET_STATEMENT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [SET_LVAL]");
            this.m_lval.printNode(level + 2);
            BaseLogManager.info(this.getClass(), space + " [SET_EXPRESSION]");
            this.m_expression.printNode(level + 2);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_lval.createStackMachineCommand(prg, true);
            this.m_expression.createStackMachineCommand(prg, lval);
            prg.addCommand(15, null);
        }
    }

    private class ParseTreeNodeStatementInclude
    extends ParseTreeNode {
        private ParseTreeNode m_expression;
        private boolean m_noparse;
        private boolean m_noparseFound;
        private boolean m_copyfields;
        private boolean m_copyfieldsFound;
        private boolean m_lastSeparator;

        public ParseTreeNodeStatementInclude(ParseTreeNode parent) {
            super(parent);
            this.m_type = 130;
            this.m_noparse = false;
            this.m_noparseFound = false;
            this.m_copyfields = false;
            this.m_copyfieldsFound = false;
            this.m_lastSeparator = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_expression == null) {
                        this.m_expression = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_expression;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_ARGLIST_FOUND_OPENING_BRACKET", locale), locale);
                }
                case 6: {
                    if (this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_INCLUDE_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 120: {
                    this.m_lastSeparator = true;
                    break;
                }
                case 141: {
                    if (!this.m_lastSeparator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERRPR_EXPECTED_ARGLIST_SEPARATOR", locale) + token.getValue(), locale);
                    }
                    if (this.m_copyfieldsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_DUPLICATE_ARGUMENT", locale) + token.getValue(), locale);
                    }
                    this.m_lastSeparator = false;
                    this.m_copyfields = true;
                    this.m_copyfieldsFound = true;
                    break;
                }
                case 142: {
                    if (!this.m_lastSeparator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERRPR_EXPECTED_ARGLIST_SEPARATOR", locale) + token.getValue(), locale);
                    }
                    if (this.m_noparseFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_DUPLICATE_ARGUMENT", locale) + token.getValue(), locale);
                    }
                    this.m_lastSeparator = false;
                    this.m_noparse = true;
                    this.m_noparseFound = true;
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[INCLUDE_STATEMENT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [COPYFIELDS] " + this.m_copyfields);
            BaseLogManager.info(this.getClass(), space + " [NOPARSE] " + this.m_noparse);
            BaseLogManager.info(this.getClass(), space + " [INCLUDE_TARGET_ARGUMENT]");
            this.m_expression.printNode(level + 2);
        }
    }

    private class ParseTreeNodeExpressionSubstr
    extends ParseTreeNode {
        private ParseTreeNode m_stringExpression;
        private ParseTreeNode m_offsetExpression;
        private ParseTreeNode m_lengthExpression;

        public ParseTreeNodeExpressionSubstr(ParseTreeNode parent) {
            super(parent);
            this.m_type = 90;
            this.m_stringExpression = null;
            this.m_offsetExpression = null;
            this.m_lengthExpression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_stringExpression == null) {
                        this.m_stringExpression = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_stringExpression;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_ARGLIST", locale), locale);
                }
                case 6: {
                    if (this.m_lengthExpression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_NOT_ENOUGH_ARGUMENTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 120: {
                    if (this.m_lengthExpression == null) {
                        this.m_lengthExpression = new ParseTreeNodeCompoundExpression(this, false);
                        FormCompiler.this.m_current = this.m_lengthExpression;
                        break;
                    }
                    if (this.m_offsetExpression != null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_TOO_MANY_ARGUMENTS", locale), locale);
                    }
                    this.m_offsetExpression = this.m_lengthExpression;
                    this.m_lengthExpression = new ParseTreeNodeCompoundExpression(this, false);
                    FormCompiler.this.m_current = this.m_lengthExpression;
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[SUBSTR_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [SUBSTR_STRING_ARGUMENT]");
            this.m_stringExpression.printNode(level + 2);
            if (this.m_offsetExpression != null) {
                BaseLogManager.info(this.getClass(), space + " [SUBSTR_OFFSET_ARGUMENT]");
                this.m_offsetExpression.printNode(level + 2);
            }
            if (this.m_lengthExpression != null) {
                BaseLogManager.info(this.getClass(), space + " [SUBSTR_LENGTH_ARGUMENT]");
                this.m_lengthExpression.printNode(level + 2);
            }
        }
    }

    private class ParseTreeNodeExpressionEval
    extends ParseTreeNode {
        private ParseTreeNode m_expression;

        public ParseTreeNodeExpressionEval(ParseTreeNode parent) {
            super(parent);
            this.m_type = 70;
            this.m_expression = null;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    this.m_expression = new ParseTreeNodeCompoundExpression(this, true);
                    FormCompiler.this.m_current = this.m_expression;
                    break;
                }
                default: {
                    if (this.m_expression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPRESSION_MISSING", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[EVAL_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_expression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_expression.createStackMachineCommand(prg, false);
        }
    }

    private class ParseTreeNodeStatementAssign
    extends ParseTreeNode {
        private ParseTreeNode m_target;
        private ParseTreeNode m_expression;
        private boolean m_equalsDelivered;

        public ParseTreeNodeStatementAssign(ParseTreeNode parent, FormTokenizer.FormToken token) {
            super(parent);
            this.m_type = 110;
            this.m_target = new ParseTreeNodeOperand(parent, 12, token.getValue());
            this.m_expression = null;
            this.m_equalsDelivered = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 7: {
                    this.m_equalsDelivered = true;
                    this.m_expression = new ParseTreeNodeCompoundExpression(this, false);
                    FormCompiler.this.m_current = this.m_expression;
                    break;
                }
                default: {
                    if (!this.m_equalsDelivered) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_EXPRESSION_FOUND", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[ASSIGN_STMT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            BaseLogManager.info(this.getClass(), space + " [ASSIGNMENT_LVALUE]");
            this.m_target.printNode(level + 2);
            BaseLogManager.info(this.getClass(), space + " [ASSIGNMENT_EXPRESSION]");
            this.m_expression.printNode(level + 2);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_target.createStackMachineCommand(prg, true);
            this.m_expression.createStackMachineCommand(prg, lval);
            prg.addCommand(15, null);
        }
    }

    private class ParseTreeNodeExpressionLoopIdx
    extends ParseTreeNode {
        private boolean m_BracketsFound;

        public ParseTreeNodeExpressionLoopIdx(ParseTreeNode parent) {
            super(parent);
            this.m_type = 74;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_CLOSING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    this.m_BracketsFound = true;
                    break;
                }
                case 6: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_CLOSING_BRACKET_FOUND", locale) + token.getValue(), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[LOOPIDX_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            prg.addCommand(93, null);
        }
    }

    private class ParseTreeNodeExpressionIdentifier
    extends ParseTreeNode {
        private ParseTreeNode m_fieldExpression;
        private boolean m_BracketsFound;

        public ParseTreeNodeExpressionIdentifier(ParseTreeNode parent) {
            super(parent);
            this.m_type = -1;
            this.m_fieldExpression = null;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    this.m_BracketsFound = true;
                    this.m_fieldExpression = new ParseTreeNodeExpressionIdentifier(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                case 6: {
                    if (this.m_fieldExpression == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    if (this.m_BracketsFound) break;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 1: {
                    this.m_fieldExpression = new ParseTreeNodeOperand(this, 12, token.getValue());
                    if (this.m_BracketsFound) break;
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                case 12: {
                    this.m_fieldExpression = new ParseTreeNodeExpressionEval(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        if (this.m_fieldExpression == null) {
                            throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                        }
                        FormCompiler.this.m_current = this.m_parent;
                        FormCompiler.this.m_current.processNextToken(token, locale);
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[IDENTIFIER_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_fieldExpression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_fieldExpression.createStackMachineCommand(prg, lval);
        }
    }

    private class ParseTreeNodeExpressionCount
    extends ParseTreeNode {
        private ParseTreeNode m_fieldExpression;
        private boolean m_BracketsFound;

        public ParseTreeNodeExpressionCount(ParseTreeNode parent) {
            super(parent);
            this.m_type = 74;
            this.m_fieldExpression = null;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                    }
                    this.m_BracketsFound = true;
                    this.m_fieldExpression = new ParseTreeNodeExpressionIdentifier(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                case 6: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[COUNT_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_fieldExpression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_fieldExpression.createStackMachineCommand(prg, true);
            prg.addCommand(14, null);
        }
    }

    private class ParseTreeNodeStatementDelete
    extends ParseTreeNode {
        private ParseTreeNode m_fieldExpression;
        private boolean m_BracketsFound;

        public ParseTreeNodeStatementDelete(ParseTreeNode parent) {
            super(parent);
            this.m_type = 115;
            this.m_fieldExpression = null;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                    }
                    this.m_BracketsFound = true;
                    this.m_fieldExpression = new ParseTreeNodeExpressionIdentifier(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                case 6: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[DELETE_STATEMENT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_fieldExpression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_fieldExpression.createStackMachineCommand(prg, true);
            prg.addCommand(18, null);
        }
    }

    private class ParseTreeNodeStatementClear
    extends ParseTreeNode {
        private ParseTreeNode m_fieldExpression;
        private boolean m_BracketsFound;

        public ParseTreeNodeStatementClear(ParseTreeNode parent) {
            super(parent);
            this.m_type = 116;
            this.m_fieldExpression = null;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                    }
                    this.m_BracketsFound = true;
                    this.m_fieldExpression = new ParseTreeNodeExpressionIdentifier(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                case 6: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPENING_BRACKET_FOUND", locale) + token.getValue(), locale);
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[CLEAR_STATEMENT_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_fieldExpression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_fieldExpression.createStackMachineCommand(prg, true);
            prg.addCommand(17, null);
        }
    }

    private class ParseTreeNodeExpressionExists
    extends ParseTreeNode {
        private ParseTreeNode m_fieldExpression;
        private boolean m_BracketsFound;

        public ParseTreeNodeExpressionExists(ParseTreeNode parent) {
            super(parent);
            this.m_type = 72;
            this.m_fieldExpression = null;
            this.m_BracketsFound = false;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 5: {
                    if (this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_IDENTIFIER_EXPECTED", locale) + token.getValue(), locale);
                    }
                    this.m_BracketsFound = true;
                    this.m_fieldExpression = new ParseTreeNodeExpressionIdentifier(this);
                    FormCompiler.this.m_current = this.m_fieldExpression;
                    break;
                }
                case 6: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_OPENING_BRACKET_EXPECTED", locale) + token.getValue(), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    break;
                }
                default: {
                    if (!this.m_BracketsFound) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_OPENING_BRACKET_EXPECTED_FOUND", locale) + token.getValue(), locale);
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, MessageFormat.format(BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_IDENTIFIER_OR_EVAL_FOUND", locale), token.getValue()), locale);
                }
            }
        }

        public void printNode(int level) {
            String space = "";
            for (int i = 0; i < level; ++i) {
                space = space + " ";
            }
            String output = space + "[EXISTS_EXPRESSION_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            this.m_fieldExpression.printNode(level + 1);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            this.m_fieldExpression.createStackMachineCommand(prg, true);
            prg.addCommand(16, null);
        }
    }

    private class ParseTreeNodeCompoundExpression
    extends ParseTreeNode {
        private Vector m_components;
        private Object m_lastComponent;
        private boolean m_withBrackets;

        public ParseTreeNodeCompoundExpression(ParseTreeNode parent, boolean withBrackets) {
            super(parent);
            this.m_type = -1;
            this.m_components = new Vector();
            FormCompiler.this.m_current = null;
            this.m_withBrackets = withBrackets;
        }

        private void handleFormatExpression(FormTokenizer.FormToken token, int type, Locale locale) throws FormCompilerException {
            if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                this.m_lastComponent = new ParseTreeNodeExpressionFormat(this, type);
                this.m_components.add(this.m_lastComponent);
                FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
            } else {
                if (this.m_withBrackets) {
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERAND_FOUND_FORMATTING", locale), locale);
                }
                FormCompiler.this.m_current = this.m_parent;
                FormCompiler.this.m_current.processNextToken(token, locale);
            }
        }

        private void handleMathExpression(FormTokenizer.FormToken token, int type, Locale locale) throws FormCompilerException {
            if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                this.m_lastComponent = new ParseTreeNodeExpressionMath(this, type);
                this.m_components.add(this.m_lastComponent);
                FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
            } else {
                if (this.m_withBrackets) {
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERAND_FOUND_SUBSTR", locale), locale);
                }
                FormCompiler.this.m_current = this.m_parent;
                FormCompiler.this.m_current.processNextToken(token, locale);
            }
        }

        private void handleOperatorExpression(FormTokenizer.FormToken token, int type, Locale locale) throws FormCompilerException {
            if (this.m_lastComponent != null && this.m_lastComponent instanceof ParseTreeNodeOperator) {
                throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERAND_FOUND_OPERATOR", locale), locale);
            }
            this.m_lastComponent = new ParseTreeNodeOperator(this, type);
            this.m_components.add(this.m_lastComponent);
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
            switch (token.getType()) {
                case 6: {
                    if (this.m_withBrackets) {
                        if (this.m_lastComponent == null) {
                            throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPTECTED_EXPRESSION", locale), locale);
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeOperand) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeCompoundExpression) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionEval) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionExists) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionLoopIdx) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionFormat) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionSubstr) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionLen) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionMath) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionNot) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        if (this.m_lastComponent instanceof ParseTreeNodeExpressionCount) {
                            FormCompiler.this.m_current = this.m_parent;
                            break;
                        }
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_MISSING_ARG_IN_COMPOUNDEXPRESSION", locale), locale);
                    }
                    if (this.m_lastComponent == null) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_EXPRESSION", locale), locale);
                    }
                    if (this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_MISSING_ARG_IN_COMPOUNDEXPRESSION", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 5: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        FormCompiler.this.m_current = new ParseTreeNodeCompoundExpression(this, true);
                        this.m_components.add(FormCompiler.this.m_current);
                        this.m_lastComponent = FormCompiler.this.m_current;
                        break;
                    }
                    throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_COMPOUNDEXPR", locale), locale);
                }
                case 1: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeOperand(this, 12, token.getValue());
                        this.m_components.add(this.m_lastComponent);
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_IDENTIFIER", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 2: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeOperand(this, 11, token.getValue());
                        this.m_components.add(this.m_lastComponent);
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_NUMBER", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 3: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeOperand(this, 10, token.getValue());
                        this.m_components.add(this.m_lastComponent);
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_LITERAL", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 12: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionEval(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_EVAL", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 61: {
                    this.handleFormatExpression(token, 82, locale);
                    break;
                }
                case 60: {
                    this.handleFormatExpression(token, 80, locale);
                    break;
                }
                case 63: {
                    this.handleFormatExpression(token, 81, locale);
                    break;
                }
                case 62: {
                    this.handleFormatExpression(token, 83, locale);
                    break;
                }
                case 64: {
                    this.handleFormatExpression(token, 84, locale);
                    break;
                }
                case 65: {
                    this.handleFormatExpression(token, 85, locale);
                    break;
                }
                case 70: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionSubstr(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_SUBSTR", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 80: {
                    this.handleMathExpression(token, 100, locale);
                    break;
                }
                case 81: {
                    this.handleMathExpression(token, 104, locale);
                    break;
                }
                case 82: {
                    this.handleMathExpression(token, 101, locale);
                    break;
                }
                case 83: {
                    this.handleMathExpression(token, 103, locale);
                    break;
                }
                case 84: {
                    this.handleMathExpression(token, 102, locale);
                    break;
                }
                case 71: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionLen(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_LEN", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 75: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionNot(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_NOT", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 13: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionExists(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_EXISTS", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 16: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionCount(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_COUNT", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 41: {
                    if (this.m_lastComponent == null || this.m_lastComponent instanceof ParseTreeNodeOperator) {
                        this.m_lastComponent = new ParseTreeNodeExpressionLoopIdx(this);
                        this.m_components.add(this.m_lastComponent);
                        FormCompiler.this.m_current = (ParseTreeNode)this.m_lastComponent;
                        break;
                    }
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.ERROR_EXPECTED_OPERATOR_FOUND_FIELD", locale), locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                    break;
                }
                case 91: {
                    this.handleOperatorExpression(token, 25, locale);
                    break;
                }
                case 95: {
                    this.handleOperatorExpression(token, 24, locale);
                    break;
                }
                case 93: {
                    this.handleOperatorExpression(token, 23, locale);
                    break;
                }
                case 92: {
                    this.handleOperatorExpression(token, 21, locale);
                    break;
                }
                case 104: {
                    this.handleOperatorExpression(token, 21, locale);
                    break;
                }
                case 105: {
                    this.handleOperatorExpression(token, 22, locale);
                    break;
                }
                case 94: {
                    this.handleOperatorExpression(token, 22, locale);
                    break;
                }
                case 100: {
                    this.handleOperatorExpression(token, 30, locale);
                    break;
                }
                case 101: {
                    this.handleOperatorExpression(token, 31, locale);
                    break;
                }
                case 102: {
                    this.handleOperatorExpression(token, 32, locale);
                    break;
                }
                case 103: {
                    this.handleOperatorExpression(token, 33, locale);
                    break;
                }
                case 107: {
                    this.handleOperatorExpression(token, 20, locale);
                    break;
                }
                default: {
                    if (this.m_withBrackets) {
                        throw FormCompiler.this.constructSyntaxErrorException(token, BaseResourceHandler.getString("FormCompiler.INVALID_TOKEN", locale) + token.getValue() + "'", locale);
                    }
                    FormCompiler.this.m_current = this.m_parent;
                    FormCompiler.this.m_current.processNextToken(token, locale);
                }
            }
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[COMPEXPR_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
            Enumeration enumeration = this.m_components.elements();
            while (enumeration.hasMoreElements()) {
                ParseTreeNode child = (ParseTreeNode)enumeration.nextElement();
                child.printNode(level + 1);
            }
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            if (this.m_components.size() == 1) {
                ParseTreeNode nde = (ParseTreeNode)this.m_components.get(0);
                nde.createStackMachineCommand(prg, lval);
            } else {
                this.createStackMachineCommand(prg, 0, this.m_components.size() - 1, lval);
            }
        }

        private void createStackMachineCommand(StackMachineProgram prg, int first, int last, boolean lval) {
            ParseTreeNodeOperator oper;
            ParseTreeNode nde;
            int i;
            if (last == first) {
                ParseTreeNode nde2 = (ParseTreeNode)this.m_components.get(first);
                nde2.createStackMachineCommand(prg, lval);
                return;
            }
            for (i = last; i >= first; --i) {
                nde = (ParseTreeNode)this.m_components.get(i);
                if (!(nde instanceof ParseTreeNodeOperator)) continue;
                oper = (ParseTreeNodeOperator)nde;
                if (oper.m_isMult || oper.m_isComp) continue;
                this.createStackMachineCommand(prg, first, i - 1, lval);
                this.createStackMachineCommand(prg, i + 1, last, lval);
                oper.createStackMachineCommand(prg, lval);
                return;
            }
            for (i = last; i >= first; --i) {
                nde = (ParseTreeNode)this.m_components.get(i);
                if (!(nde instanceof ParseTreeNodeOperator)) continue;
                oper = (ParseTreeNodeOperator)nde;
                if (!oper.m_isMult) continue;
                this.createStackMachineCommand(prg, first, i - 1, lval);
                this.createStackMachineCommand(prg, i + 1, last, lval);
                oper.createStackMachineCommand(prg, lval);
                return;
            }
            for (i = last; i >= first; --i) {
                nde = (ParseTreeNode)this.m_components.get(i);
                if (!(nde instanceof ParseTreeNodeOperator)) continue;
                oper = (ParseTreeNodeOperator)nde;
                if (!oper.m_isComp) continue;
                this.createStackMachineCommand(prg, first, i - 1, lval);
                this.createStackMachineCommand(prg, i + 1, last, lval);
                oper.createStackMachineCommand(prg, lval);
                return;
            }
        }
    }

    private class ParseTreeNodeOperator
    extends ParseTreeNode {
        protected boolean m_isMult;
        protected boolean m_isComp;

        public ParseTreeNodeOperator(ParseTreeNode parent, int type) {
            super(parent);
            this.m_type = type;
            this.m_isComp = false;
            this.m_isMult = false;
            switch (type) {
                case 20: {
                    this.m_isComp = true;
                    break;
                }
                case 25: {
                    this.m_isComp = true;
                    break;
                }
                case 21: {
                    this.m_isComp = true;
                    break;
                }
                case 22: {
                    this.m_isComp = true;
                    break;
                }
                case 23: {
                    this.m_isComp = true;
                    break;
                }
                case 24: {
                    this.m_isComp = true;
                    break;
                }
                case 32: {
                    this.m_isMult = true;
                    break;
                }
                case 33: {
                    this.m_isMult = true;
                    break;
                }
                case 34: {
                    this.m_isMult = true;
                    break;
                }
                case 30: {
                    this.m_isMult = false;
                    break;
                }
                case 31: {
                    this.m_isMult = false;
                    break;
                }
                default: {
                    BaseLogManager.error(this.getClass(), "Unexpected operator type: " + this.m_type);
                }
            }
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[OPERATOR_" + this.m_type + "]";
            BaseLogManager.info(this.getClass(), output);
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            switch (this.m_type) {
                case 30: {
                    prg.addCommand(30, null);
                    break;
                }
                case 31: {
                    prg.addCommand(31, null);
                    break;
                }
                case 32: {
                    prg.addCommand(32, null);
                    break;
                }
                case 33: {
                    prg.addCommand(33, null);
                    break;
                }
                case 34: {
                    prg.addCommand(34, null);
                    break;
                }
                case 20: {
                    prg.addCommand(40, null);
                    break;
                }
                case 21: {
                    prg.addCommand(41, null);
                    break;
                }
                case 22: {
                    prg.addCommand(42, null);
                    break;
                }
                case 23: {
                    prg.addCommand(43, null);
                    break;
                }
                case 24: {
                    prg.addCommand(44, null);
                    break;
                }
                case 25: {
                    prg.addCommand(45, null);
                }
            }
        }
    }

    private class ParseTreeNodeOperand
    extends ParseTreeNode {
        private String m_argument;

        public ParseTreeNodeOperand(ParseTreeNode parent, int type, String argument) {
            super(parent);
            this.m_argument = argument;
            this.m_type = type;
        }

        public void processNextToken(FormTokenizer.FormToken token, Locale locale) throws FormCompilerException {
        }

        public void printNode(int level) {
            String output = "";
            for (int i = 0; i < level; ++i) {
                output = output + " ";
            }
            output = output + "[OPERAND_" + this.m_type + "] " + this.m_argument;
        }

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
            switch (this.m_type) {
                case 10: {
                    prg.addCommand(2, this.m_argument);
                    break;
                }
                case 11: {
                    prg.addCommand(2, this.m_argument);
                    break;
                }
                case 12: {
                    if (!lval) {
                        prg.addCommand(1, this.m_argument);
                        break;
                    }
                    prg.addCommand(2, this.m_argument);
                }
            }
        }
    }

    private abstract class ParseTreeNode {
        public ParseTreeNode m_parent;
        public int m_type;

        public ParseTreeNode(ParseTreeNode parent) {
            this.m_parent = parent;
            this.m_type = -1;
        }

        public abstract void processNextToken(FormTokenizer.FormToken var1, Locale var2) throws FormCompilerException;

        public abstract void printNode(int var1);

        public void createStackMachineCommand(StackMachineProgram prg, boolean lval) {
        }
    }
}

