/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.rfc;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.mw.jco.JCO;
import java.util.Properties;

public class SAPConnectionPoolManager {
    public static final String JCO_STANDALONE_CLIENT = "jco.client";
    public static final String JCO_STANDALONE_SYSTEMID = "jco.systemid";
    public static final String JCO_STANDALONE_MESSAGESERVER = "jco.msgsrv";
    public static final String JCO_STANDALONE_USER = "jco.user";
    public static final String JCO_STANDALONE_PASSWORD = "jco.password";
    public static final String JCO_STANDALONE_LOGONGROUP = "jco.logongroup";
    public static final String JCO_STANDALONE_LANGUAGE = "jco.language";
    public static final String JCO_STANDALONE_APPLICATIONSERVER = "jco.applsrv";
    public static final String JCO_STANDALONE_SYSTEMNUMBER = "jco.sysnr";
    public static final String MODE_OF_SERVER = "jco.mode";
    public static final String MAXIMUM_NUMBER_OF_CONNECTION = "maximumNumberConnection";
    public static final String ERROR_INVALID_MODE = "Invalid mode.";
    public static final int MODE_MESSAGE_SERVER = 1;
    public static final int MODE_APPLICATION_SERVER = 2;
    public static final String MODE_OF_SNC = "jco.client.snc_mode";
    public static final String MODE_OF_SNC_ON = "1";
    public static final String MODE_OF_SNC_OFF = "0";
    public static final String SNC_PARTNERNAME = "jco.client.snc_partnername";
    public static final String SNC_QOP = "jco.client.snc_qop";
    public static final String SNC_CUSTOM_PARTNERNAME = "jco.client.snc_myname";
    public static final String SNC_PATH_LIBRARY = "jco.client.snc_lib";
    public static final String JCO_STANDALONE_GWHOST = "jco.client.gwhost";
    public static final String JCO_STANDALONE_GWSERV = "jco.client.gwserv";
    public static final String JCO_STANDALONE_CODEPAGE = "jco.client.codepage";
    public static final String JCO_STANDALONE_MYSAPSSO2 = "jco.client.mysapsso2";
    public static final String JCO_STANDALONE_X509CERT = "jco.client.x509cert";
    private static final int MAXIMUM_NUMBER_OF_CONNECTION_DEFAULT = 2;
    static /* synthetic */ Class class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager;

    public static JCO.Client getJCOClient(Properties properties) throws JCO.Exception, InvocationException {
        JCO.Client jcoClient = null;
        Object jcoPool = null;
        String poolName = null;
        if (properties.getProperty(MAXIMUM_NUMBER_OF_CONNECTION) == null) {
            String maximumNumberConnection = String.valueOf(2);
            properties.setProperty(MAXIMUM_NUMBER_OF_CONNECTION, maximumNumberConnection);
        }
        int mode = Integer.parseInt(properties.getProperty(MODE_OF_SERVER));
        poolName = SAPConnectionPoolManager.createPoolName(properties, mode);
        jcoClient = SAPConnectionPoolManager.instantiateJCOClientObject(poolName, properties);
        return jcoClient;
    }

    private static synchronized String createPoolName(Properties properties, int mode) throws InvocationException {
        StringBuffer poolName = new StringBuffer();
        poolName.append(properties.getProperty(JCO_STANDALONE_CLIENT));
        poolName.append(properties.getProperty(JCO_STANDALONE_USER));
        poolName.append(properties.getProperty(JCO_STANDALONE_LANGUAGE));
        poolName.append(properties.getProperty(MAXIMUM_NUMBER_OF_CONNECTION));
        switch (mode) {
            case 1: {
                poolName.append(properties.getProperty(JCO_STANDALONE_LOGONGROUP));
                poolName.append("-");
                poolName.append(properties.getProperty(JCO_STANDALONE_MESSAGESERVER));
                poolName.append("-");
                poolName.append(properties.getProperty(JCO_STANDALONE_SYSTEMID));
                return poolName.toString();
            }
            case 2: {
                poolName.append("-");
                poolName.append(properties.getProperty(JCO_STANDALONE_APPLICATIONSERVER));
                poolName.append("-");
                poolName.append(properties.getProperty(JCO_STANDALONE_SYSTEMNUMBER));
                return poolName.toString();
            }
        }
        throw new InvocationException(ERROR_INVALID_MODE);
    }

    private static JCO.Pool getJCOPool(String poolName, Properties properties) throws JCO.Exception, InvocationException {
        JCO.Pool jcoPool = null;
        try {
            for (int i = 0; i < JCO.getClientPoolManager().getPoolNames().length; ++i) {
                if (!JCO.getClientPoolManager().getPoolNames()[i].equals(poolName)) continue;
                jcoPool = JCO.getClientPoolManager().getPool(poolName);
                return jcoPool;
            }
            Properties jcoProps = SAPConnectionPoolManager.convertPropsToJCOProps(properties);
            int maximumNumberConnection = Integer.parseInt(properties.getProperty(MAXIMUM_NUMBER_OF_CONNECTION));
            JCO.addClientPool((String)poolName, (int)maximumNumberConnection, (Properties)jcoProps);
            jcoPool = JCO.getClientPoolManager().getPool(poolName);
            return jcoPool;
        }
        catch (JCO.Exception jcoException) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager == null ? (class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager = SAPConnectionPoolManager.class$("com.sap.caf.mp.base.rfc.SAPConnectionPoolManager")) : class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager, "The following Kind of JCO-Exception occured: " + jcoException.getGroup(), (Exception)((Object)jcoException));
            throw new JCO.Exception(jcoException.getGroup(), jcoException.getKey(), jcoException.getMessage());
        }
        catch (Exception exception) {
            BaseLogManager.error(class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager == null ? (class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager = SAPConnectionPoolManager.class$("com.sap.caf.mp.base.rfc.SAPConnectionPoolManager")) : class$com$sap$caf$mp$base$rfc$SAPConnectionPoolManager, exception);
            throw new InvocationException(exception.getLocalizedMessage(), exception);
        }
    }

    private static JCO.Client instantiateJCOClientObject(String poolName, Properties properties) throws JCO.Exception, InvocationException {
        JCO.Client jcoClient = null;
        JCO.Pool jcoPool = SAPConnectionPoolManager.getJCOPool(poolName, properties);
        if (jcoPool != null) {
            jcoClient = JCO.getClient((String)poolName);
        }
        return jcoClient;
    }

    private static Properties convertPropsToJCOProps(Properties props) throws InvocationException {
        Properties jcoProps = new Properties();
        String jcoClient = "jco.client.client";
        String jcoUser = "jco.client.user";
        String jcoPwd = "jco.client.passwd";
        String jcoLanguage = "jco.client.lang";
        String jcoMsHost = "jco.client.mshost";
        String jcoR3Name = "jco.client.r3name";
        String jcoGroupLogOn = "jco.client.group";
        String jcoSysNr = "jco.client.sysnr";
        String jcoAsHost = "jco.client.ashost";
        jcoProps.setProperty(jcoClient, props.getProperty(JCO_STANDALONE_CLIENT));
        jcoProps.setProperty(jcoUser, props.getProperty(JCO_STANDALONE_USER));
        jcoProps.setProperty(jcoPwd, props.getProperty(JCO_STANDALONE_PASSWORD));
        jcoProps.setProperty(jcoLanguage, props.getProperty(JCO_STANDALONE_LANGUAGE));
        int modeServ = Integer.parseInt(props.getProperty(MODE_OF_SERVER));
        if (modeServ == 1) {
            jcoProps.setProperty(jcoR3Name, props.getProperty(JCO_STANDALONE_SYSTEMID));
            jcoProps.setProperty(jcoMsHost, props.getProperty(JCO_STANDALONE_MESSAGESERVER));
            jcoProps.setProperty(jcoGroupLogOn, props.getProperty(JCO_STANDALONE_LOGONGROUP));
        } else if (modeServ == 2) {
            jcoProps.setProperty(jcoAsHost, props.getProperty(JCO_STANDALONE_APPLICATIONSERVER));
            jcoProps.setProperty(jcoSysNr, props.getProperty(JCO_STANDALONE_SYSTEMNUMBER));
        } else {
            throw new InvocationException(ERROR_INVALID_MODE);
        }
        return jcoProps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

