/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.rfc;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;

public class R3ConnectionPropChecker {
    public static void checkPropertiesOfConnection(Properties objProps, Properties newProps, Locale locale) throws InvocationException {
        String modeofRFC = null;
        String nameofSLDConn = null;
        String jcoLanguage = null;
        String jcoPassword = null;
        String jcoUser = null;
        String jcoClient = null;
        String jcoModeSrv = null;
        String jcoApplserv = null;
        String jcoSystemnr = null;
        String jcoLogOnGroup = null;
        String jcoMsgSrv = null;
        String jcoSystemId = null;
        String objModeofRFC = null;
        String objNameofSLDConn = null;
        String objLanguageLogOn = null;
        String objPasswordLogOn = null;
        String objUserLogOn = null;
        String objClientLogOn = null;
        String objModeSrvLogOn = null;
        String objApplservLogOn = null;
        String objSystemnrLogOn = null;
        String objLogOnGroupLogOn = null;
        String objMsgSrvLogOn = null;
        String objSystemIdLogOn = null;
        if (newProps.getProperty("rfc.mode") == null) {
            throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_RFMODE_NULL", locale));
        }
        if (newProps.getProperty("rfc.mode").equals("")) {
            throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_RFCMODE_EMPTY", locale));
        }
        modeofRFC = newProps.getProperty("rfc.mode");
        int modeRFC = 0;
        try {
            modeRFC = Integer.parseInt(modeofRFC);
        }
        catch (NumberFormatException ex) {
            String message = MessageFormat.format(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_RFCMODE_INVALID_FORMAT", locale), modeofRFC);
            throw new InvocationException(message, ex);
        }
        if (modeRFC == 1) {
            objModeofRFC = objProps.getProperty("rfc.mode");
            objNameofSLDConn = objProps.getProperty("rfc.destination");
            if (newProps.getProperty("rfc.destination") == null) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_SLDNAME_NULL", locale));
            }
            if (newProps.getProperty("rfc.destination").equals("")) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_SLDNAME_EMPTY", locale));
            }
            nameofSLDConn = newProps.getProperty("rfc.destination");
            if (!nameofSLDConn.equals(objNameofSLDConn)) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
            }
        } else if (modeRFC == 2) {
            jcoLanguage = newProps.getProperty("jco.language");
            jcoPassword = newProps.getProperty("jco.password");
            jcoUser = newProps.getProperty("jco.user");
            jcoClient = newProps.getProperty("jco.client");
            jcoModeSrv = newProps.getProperty("jco.mode");
            if (jcoLanguage == null || jcoPassword == null || jcoUser == null || jcoClient == null || jcoModeSrv == null) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_GENERIC_PARAM_NULL", locale));
            }
            if (jcoLanguage.equals("") || jcoPassword.equals("") || jcoUser.equals("") || jcoClient.equals("") || jcoModeSrv.equals("")) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_GENERIC_PARAM_INVALID", locale));
            }
            int modeSrv = 0;
            try {
                modeSrv = Integer.parseInt(jcoModeSrv);
            }
            catch (NumberFormatException ex) {
                String message = MessageFormat.format(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_SERVERMODE_INVALID", locale), jcoModeSrv);
                throw new InvocationException(message, ex);
            }
            if (modeSrv == 2) {
                jcoApplserv = newProps.getProperty("jco.applsrv");
                jcoSystemnr = newProps.getProperty("jco.applsrv");
                if (jcoApplserv == null || jcoSystemnr == null) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_SERVERLOGON_PARAM_NULL", locale));
                }
                if (jcoApplserv.equals("") || jcoSystemnr.equals("")) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_SERVERLOGON_PARAM_EMPTY", locale));
                }
            } else if (modeSrv == 1) {
                jcoLogOnGroup = newProps.getProperty("jco.logongroup");
                jcoMsgSrv = newProps.getProperty("jco.msgsrv");
                jcoSystemId = newProps.getProperty("jco.systemid");
                if (jcoLogOnGroup == null || jcoMsgSrv == null || jcoSystemId == null) {
                    throw new InvocationException("The logon group, message server or/and system identifier must not be null, when the mode of server is: \"group logon\"");
                }
                if (jcoLogOnGroup.equals("") || jcoMsgSrv.equals("") || jcoSystemId.equals("")) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_LOGONGROUP_PARAM_EMPTY", locale));
                }
            }
            objLanguageLogOn = objProps.getProperty("jco.language");
            objPasswordLogOn = objProps.getProperty("jco.password");
            objUserLogOn = objProps.getProperty("jco.user");
            objClientLogOn = objProps.getProperty("jco.client");
            objModeSrvLogOn = objProps.getProperty("jco.mode");
            int modeSrvLogOn = Integer.parseInt(jcoModeSrv);
            if (modeSrvLogOn == 2) {
                objApplservLogOn = objProps.getProperty("jco.applsrv");
                objSystemnrLogOn = objProps.getProperty("jco.applsrv");
            } else if (modeSrvLogOn == 1) {
                objLogOnGroupLogOn = objProps.getProperty("jco.logongroup");
                objMsgSrvLogOn = objProps.getProperty("jco.msgsrv");
                objSystemIdLogOn = objProps.getProperty("jco.systemid");
            }
            if (!jcoPassword.equals(objPasswordLogOn)) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
            }
            if (!jcoUser.equals(objUserLogOn)) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
            }
            if (!jcoClient.equals(objClientLogOn)) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
            }
            if (!jcoModeSrv.equals(objModeSrvLogOn)) {
                throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
            }
            if (modeSrvLogOn == 2) {
                if (!jcoApplserv.equals(objApplservLogOn)) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
                }
                if (!jcoSystemnr.equals(objSystemnrLogOn)) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
                }
            } else if (modeSrvLogOn == 1) {
                if (!jcoLogOnGroup.equals(objLogOnGroupLogOn)) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
                }
                if (!jcoMsgSrv.equals(objMsgSrvLogOn)) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
                }
                if (!jcoSystemId.equals(objSystemIdLogOn)) {
                    throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_INVALID_CONFIGURATION", locale));
                }
            }
        } else {
            throw new InvocationException(BaseResourceHandler.getString("R3ConnectionPropChecker.ERROR_MODE_INVALID", locale) + modeofRFC);
        }
    }
}

