/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.protocol.http.HttpClient;
import com.sap.caf.mp.base.protocol.http.HttpClientConnection;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.http.auth.BasicAuthenticator;
import com.sap.caf.mp.base.protocol.http.auth.IAuthenticator;
import com.sap.caf.mp.base.protocol.webdav.PropFindRequest;
import com.sap.caf.mp.base.protocol.webdav.PropFindResponse;
import com.sap.caf.mp.base.protocol.webdav.WebDAVOptionsServer;
import com.sap.caf.mp.base.protocol.webdav.WebDAVProperty;
import com.sap.caf.mp.base.protocol.webdav.WebDAVResource;
import java.util.Enumeration;
import java.util.Vector;

public class WebDAVClient {
    private String m_hostName;
    private int m_port;
    private int m_protocol;
    private IAuthenticator m_authenticator;
    private WebDAVOptionsServer m_serverFeatures;

    public WebDAVClient(int protocol, String hostName, int port, IAuthenticator authenticator) throws InvocationException {
        this.m_protocol = protocol;
        this.m_hostName = hostName;
        this.m_port = port;
        this.m_authenticator = authenticator;
        this.m_serverFeatures = null;
    }

    public WebDAVResource readResource(String resourceUri, Vector properties) throws InvocationException, EngineException {
        long start = System.currentTimeMillis();
        HttpClientConnection connection = HttpClient.getConnection(this.m_protocol, this.m_hostName, this.m_port, this.m_authenticator);
        int type = 0;
        if (properties == null) {
            type = 1;
        }
        PropFindRequest propFind = new PropFindRequest(type, resourceUri, 0, properties);
        PropFindResponse response = propFind.executeRequest(connection);
        long end = System.currentTimeMillis();
        BaseLogManager.performanceInfo(this.getClass(), "WebDAVClient::readResource()", end - start);
        return (WebDAVResource)response.getResponseEntities().get(0);
    }

    public Vector readResourceChildren(String resourceUri, Vector properties) throws InvocationException, EngineException {
        long start = System.currentTimeMillis();
        HttpClientConnection connection = HttpClient.getConnection(this.m_protocol, this.m_hostName, this.m_port, this.m_authenticator);
        int type = 0;
        if (properties == null) {
            type = 1;
        }
        PropFindRequest propFind = new PropFindRequest(type, resourceUri, 1, properties);
        PropFindResponse response = propFind.executeRequest(connection);
        long end = System.currentTimeMillis();
        BaseLogManager.performanceInfo(this.getClass(), "WebDAVClient::readResourceChildren()", end - start);
        Vector result = response.getResponseEntities();
        result.remove(0);
        return result;
    }

    public static void main(String[] args) {
        try {
            HttpClient.setTraceFileName("c:\\temp\\davtrace.txt");
            Vector<WebDAVProperty> props = new Vector<WebDAVProperty>();
            props.add(new WebDAVProperty("http://www.zope.org/propsets/default", "title"));
            BasicAuthenticator auth = new BasicAuthenticator("sap", "sap");
            WebDAVClient client = new WebDAVClient(0, "localhost", 8080, auth);
            client.getServerFeatures();
            WebDAVResource resource = client.readResource("/", props);
            System.out.println(resource.toString());
            resource = client.readResource("/Examples/FileLibrary/Files/example.html", props);
            System.out.println(resource.toString());
            Vector children = client.readResourceChildren("/Control_Panel", props);
            Enumeration enumeration = children.elements();
            while (enumeration.hasMoreElements()) {
                resource = (WebDAVResource)enumeration.nextElement();
                System.out.println(resource.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized WebDAVOptionsServer getServerFeatures() throws InvocationException, EngineException {
        if (this.m_serverFeatures != null) {
            return this.m_serverFeatures;
        }
        long start = System.currentTimeMillis();
        HttpClientConnection connection = HttpClient.getConnection(this.m_protocol, this.m_hostName, this.m_port, this.m_authenticator);
        HttpRequest request = connection.constructHttpRequest(1, "/", 1);
        HttpResponse response = connection.executeRequest(request);
        this.m_serverFeatures = new WebDAVOptionsServer(response);
        long end = System.currentTimeMillis();
        BaseLogManager.performanceInfo(this.getClass(), "WebDAVClient::getServerFeatures()", end - start);
        return this.m_serverFeatures;
    }
}

