/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpClientConnection;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.webdav.PropPatchResponse;
import com.sap.caf.mp.base.protocol.webdav.WebDAVProperty;
import com.sap.caf.mp.base.util.NamespacePrefixes;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropPatchRequest {
    private String m_resourceUri;
    private Vector m_requestProperties;
    private String m_webDavPrefix = NamespacePrefixes.addNamespace("DAV:");
    private int m_depth;
    private Hashtable m_nameSpaces;
    private int m_type;
    private boolean m_includeSet;
    private boolean m_includeRemove;

    protected PropPatchRequest(String resourceUri, Vector properties) {
        this.m_resourceUri = resourceUri;
        this.m_nameSpaces = new Hashtable();
        int count = properties.size();
        for (int i = 0; i < count; ++i) {
            WebDAVProperty prop = (WebDAVProperty)properties.get(i);
            String ns = prop.getNameSpace();
            if (!this.m_nameSpaces.containsKey(ns)) {
                this.m_nameSpaces.put(ns, ns);
            }
            this.m_requestProperties.add(prop);
        }
    }

    private byte[] constructRequestEntity() throws EngineException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":propertyupdate xmlns:");
        buffer.append(this.m_webDavPrefix);
        buffer.append("=\"DAV:\"");
        Enumeration<Object> enumeration = this.m_nameSpaces.elements();
        while (enumeration.hasMoreElements()) {
            String ns = (String)enumeration.nextElement();
            buffer.append(" xmlns:");
            buffer.append(NamespacePrefixes.addNamespace(ns));
            buffer.append("=\"" + ns + "\"");
        }
        buffer.append(">\r\n<");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":prop>\r\n");
        enumeration = this.m_requestProperties.elements();
        while (enumeration.hasMoreElements()) {
            WebDAVProperty prop = (WebDAVProperty)enumeration.nextElement();
            String prefix = NamespacePrefixes.addNamespace(prop.getNameSpace());
            buffer.append("<");
            buffer.append(prefix);
            buffer.append(":");
            buffer.append(prop.getName());
            buffer.append("/>\r\n");
        }
        buffer.append("</");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":prop>\r\n</");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":propertyupdate>\r\n");
        String entity = buffer.toString();
        try {
            return entity.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    protected PropPatchResponse executeRequest(HttpClientConnection connection) throws InvocationException, EngineException {
        byte[] entity = null;
        HttpRequest request = connection.constructHttpRequest("PROPFIND", this.m_resourceUri, 1);
        request.setRequestBody(entity);
        request.setRequestHeader(35, "text/xml; charset=\"utf-8\"");
        if (this.m_depth == -1) {
            request.setRequestHeader("Depth", "infinite");
        } else {
            request.setRequestHeader("Depth", "" + this.m_depth);
        }
        HttpResponse response = connection.executeRequest(request);
        return null;
    }
}

