/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.http.content.IResponseContent;
import com.sap.caf.mp.base.protocol.webdav.WebDAVResource;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropFindResponse {
    private Vector m_responseEntities;

    public PropFindResponse(HttpResponse response) throws EngineException {
        Document doc;
        DocumentBuilder builder;
        IResponseContent content = response.getResponseContent();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EngineException(e.getMessage(), e);
        }
        try {
            doc = builder.parse(content.getInputStream());
        }
        catch (SAXException e) {
            throw new EngineException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EngineException(e.getMessage(), e);
        }
        Element docElement = doc.getDocumentElement();
        this.m_responseEntities = new Vector();
        NodeList children = docElement.getChildNodes();
        int count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String name = child.getLocalName();
            if (name == null || !name.equals("response")) continue;
            this.m_responseEntities.add(new WebDAVResource(child));
        }
    }

    public Vector getResponseEntities() {
        return this.m_responseEntities;
    }
}

